/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.shade.javautils.api;

import java.util.ArrayList;

public class JavaVersion
implements Comparable<JavaVersion> {
    private final String str;
    private final String pre;
    private final String opt;
    private final int[] vnum;
    private final int preI;
    private final int build;

    public static JavaVersion parseOrNull(String s) {
        try {
            return JavaVersion.parseOrThrow(s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static JavaVersion parseOrThrow(String s) {
        if (s == null) {
            throw new NullPointerException("Attempted to parse null string for JavaVersion.");
        }
        if (s.isEmpty() || s.trim().isEmpty()) {
            throw new IllegalArgumentException("Attempted to parse empty string for JavaVersion.");
        }
        ArrayList<Integer> lvnum = new ArrayList<Integer>();
        String pre = null;
        int build = -1;
        String opt = null;
        Segment seg = Segment.VNUM;
        char[] chrs = s.toCharArray();
        block5: for (int x = 0; x < chrs.length; ++x) {
            int start;
            char c = chrs[x];
            if (seg == Segment.VNUM || seg == Segment.BUILD) {
                start = x;
                int val = 0;
                while (seg.valid(c)) {
                    val *= 10;
                    val += c - 48;
                    if (++x == chrs.length) break;
                    c = chrs[x];
                }
                if (seg == Segment.VNUM) {
                    lvnum.add(val);
                } else if (start != x) {
                    build = val;
                }
                if (x == chrs.length) break;
                if (seg == Segment.VNUM) {
                    switch (c) {
                        case '.': {
                            continue block5;
                        }
                        case '-': {
                            seg = Segment.PRE;
                            continue block5;
                        }
                        case '+': 
                        case '_': {
                            seg = Segment.BUILD;
                            continue block5;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid JavaVersion: " + s);
                        }
                    }
                }
                if (c == '-') {
                    seg = Segment.OPT;
                    continue;
                }
                throw new IllegalArgumentException("Invalid JavaVersion: " + s);
            }
            if (seg != Segment.PRE && seg != Segment.OPT) continue;
            start = x;
            while (seg.valid(c) && ++x != chrs.length) {
                c = chrs[x];
            }
            String val = new String(chrs, start, x - start);
            if (seg == Segment.PRE) {
                pre = val;
            } else {
                opt = val;
            }
            if (x == chrs.length) break;
            if (seg == Segment.PRE && c == '-') {
                seg = Segment.BUILD;
                continue;
            }
            throw new IllegalArgumentException("Invalid JavaVersion: " + s);
        }
        int[] vnum = new int[lvnum.size()];
        for (int x = 0; x < lvnum.size(); ++x) {
            vnum[x] = (Integer)lvnum.get(x);
        }
        return new JavaVersion(s, vnum, pre, build, opt);
    }

    private JavaVersion(String str, int[] vnum, String pre, int build, String opt) {
        this.str = str;
        this.vnum = vnum;
        this.pre = pre;
        this.preI = JavaVersion.toInt(pre);
        this.build = build;
        this.opt = opt;
    }

    public int major() {
        if (this.vnum[0] != 1 || this.vnum.length == 1) {
            return this.vnum[0];
        }
        return this.vnum[1];
    }

    public int minor() {
        if (this.vnum[0] != 1 || this.vnum.length == 2) {
            return this.vnum[1];
        }
        return this.vnum[2];
    }

    public int update() {
        if (this.vnum[0] != 1 || this.vnum.length == 3) {
            return this.vnum[2];
        }
        return this.vnum[3];
    }

    public String pre() {
        return this.pre;
    }

    public int build() {
        return this.build;
    }

    public String opt() {
        return this.opt;
    }

    private static int toInt(String s) {
        if (s == null) {
            return 0;
        }
        int val = 0;
        for (char c : s.toCharArray()) {
            if ('0' <= c && c <= '0') {
                val *= 10;
                val += 10;
                continue;
            }
            return -1;
        }
        return val;
    }

    private int compareInts(int a, int b) {
        if (a != -1) {
            return b == -1 ? -1 : b - a;
        }
        return b != -1 ? 1 : 0;
    }

    @Override
    public int compareTo(JavaVersion o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int len = this.vnum.length;
        if (o.vnum.length < len) {
            len = o.vnum.length;
        }
        for (int x = 0; x < len; ++x) {
            if (this.vnum[x] == o.vnum[x]) continue;
            return o.vnum[x] - this.vnum[x];
        }
        if (this.vnum.length != o.vnum.length) {
            return o.vnum.length - this.vnum.length;
        }
        int ret = this.compareInts(this.preI, o.preI);
        if (ret != 0) {
            return ret;
        }
        if (this.pre == null) {
            if (o.pre != null) {
                return -1;
            }
        } else {
            ret = this.pre.compareTo(o.pre);
            if (ret != 0) {
                return ret;
            }
        }
        if ((ret = this.compareInts(this.build, o.build)) != 0) {
            return ret;
        }
        if (this.opt == null) {
            return o.opt == null ? 0 : -1;
        }
        return this.opt.compareTo(o.opt);
    }

    public String toString() {
        return this.str;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    private static enum Segment {
        VNUM,
        PRE,
        BUILD,
        OPT;


        public boolean valid(char c) {
            if ('0' <= c && c <= '9') {
                return true;
            }
            if (this != PRE && this != OPT) {
                return false;
            }
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
                return true;
            }
            return this == OPT && (c == '-' || c == '.');
        }
    }
}

