/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import goblinbob.mobends.core.asset.AssetLocation;
import goblinbob.mobends.core.supporters.BindPoint;
import goblinbob.mobends.core.util.Color;
import goblinbob.mobends.core.util.ColorAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;

public class ConnectionHelper {
    public static ConnectionHelper INSTANCE = new ConnectionHelper();
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private final Gson gson;

    private ConnectionHelper() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(Color.class, (Object)new ColorAdapter());
        builder.registerTypeAdapter(BindPoint.class, (Object)new BindPoint.Adapter());
        builder.registerTypeAdapter(AssetLocation.class, (Object)new AssetLocation.Adapter());
        this.gson = builder.create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public static <T> T sendGetRequest(URL url, Map<String, String> params, Class<T> responseClass) throws IOException, URISyntaxException, ParseException {
        URIBuilder uriBuilder = new URIBuilder(url.toURI());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            uriBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        HttpGet request = new HttpGet(uriBuilder.build());
        try (CloseableHttpResponse response = ConnectionHelper.INSTANCE.httpClient.execute((ClassicHttpRequest)request);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Object object = ConnectionHelper.INSTANCE.gson.fromJson(EntityUtils.toString((HttpEntity)entity), responseClass);
                return (T)object;
            }
        }
        return null;
    }

    public static <T> T sendPostRequest(URL url, JsonObject body, Class<T> responseClass) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        byte[] out = new Gson().toJson((JsonElement)body).getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        connection.setFixedLengthStreamingMode(length);
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.connect();
        try (OutputStream os = connection.getOutputStream();){
            os.write(out);
        }
        BufferedReader json = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        return (T)ConnectionHelper.INSTANCE.gson.fromJson((Reader)json, responseClass);
    }
}

