/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.mixin.reccomplex;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ivorius.reccomplex.json.NBTToJson;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NBTToJson.class}, remap=false)
public abstract class NBTToJsonMixin {
    @Inject(method={"getNBTTypeSmart"}, at={@At(value="HEAD")}, cancellable=true)
    private static void create(JsonElement element, CallbackInfoReturnable<Class<? extends NBTBase>> cir) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            if (array.isEmpty()) {
                cir.setReturnValue(NBTTagList.class);
                return;
            }
            boolean allByte = true;
            boolean allInt = true;
            for (JsonElement arrayElement : array) {
                if (arrayElement.isJsonPrimitive()) {
                    JsonPrimitive primitive = arrayElement.getAsJsonPrimitive();
                    if (!primitive.isNumber() || !(primitive.getAsNumber() instanceof Byte)) {
                        allByte = false;
                    }
                    if (primitive.isNumber() && primitive.getAsNumber() instanceof Integer) continue;
                    allInt = false;
                    continue;
                }
                allByte = false;
                allInt = false;
            }
            if (allByte) {
                cir.setReturnValue(NBTTagByteArray.class);
                return;
            }
            if (allInt) {
                cir.setReturnValue(NBTTagIntArray.class);
                return;
            }
            cir.setReturnValue(NBTTagList.class);
            return;
        }
        if (element.isJsonObject()) {
            Class<NBTTagInt> clazz;
            String key;
            switch (key = element.getAsJsonObject().getAsJsonPrimitive("nbtType").getAsString()) {
                case "int": {
                    Class<NBTTagInt> clazz2 = NBTTagInt.class;
                    break;
                }
                case "long": {
                    Class<NBTTagInt> clazz2 = NBTTagLong.class;
                    break;
                }
                case "short": {
                    Class<NBTTagInt> clazz2 = NBTTagShort.class;
                    break;
                }
                case "float": {
                    Class<NBTTagInt> clazz2 = NBTTagFloat.class;
                    break;
                }
                case "double": {
                    Class<NBTTagInt> clazz2 = NBTTagDouble.class;
                    break;
                }
                case "byte": {
                    Class<NBTTagInt> clazz2 = NBTTagByte.class;
                    break;
                }
                case "list": {
                    Class<NBTTagInt> clazz2 = NBTTagList.class;
                    break;
                }
                case "string": {
                    Class<NBTTagInt> clazz2 = NBTTagString.class;
                    break;
                }
                default: {
                    Class<NBTTagInt> clazz2 = clazz = null;
                }
            }
            if (clazz != null) {
                cir.setReturnValue(clazz);
                return;
            }
            cir.setReturnValue(NBTTagCompound.class);
            return;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                cir.setReturnValue(NBTTagString.class);
                return;
            }
            if (primitive.isNumber()) {
                cir.setReturnValue(NBTPrimitive.class);
                return;
            }
        }
        cir.setReturnValue(null);
    }
}

