/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.transformer.universal;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import top.outlands.foundation.IExplicitTransformer;

public class ReflectFieldTransformer
implements IExplicitTransformer {
    private static final String OUR_REFLECTION_CLASS = "com/cleanroommc/hackery/ReflectionHackery";

    public byte[] transform(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassWriter writer = new ClassWriter(0);
        CV cv = new CV((ClassVisitor)writer);
        reader.accept((ClassVisitor)cv, 0);
        return writer.toByteArray();
    }

    private static class CV
    extends ClassVisitor {
        public CV(ClassVisitor cv) {
            super(589824, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, descriptor, signature, exceptions);
            if (mv != null) {
                mv = new MV(mv);
            }
            return mv;
        }
    }

    private static class MV
    extends MethodVisitor {
        private final Map<String, String> primitiveMap = new HashMap<String, String>(){
            {
                this.put("Boolean", "Z");
                this.put("Byte", "B");
                this.put("Char", "C");
                this.put("Short", "S");
                this.put("Int", "I");
                this.put("Long", "J");
                this.put("Float", "F");
                this.put("Double", "D");
            }
        };

        public MV(MethodVisitor mv) {
            super(589824, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (this.mv != null) {
                if (owner.equals("java/lang/reflect/Field") && (name.startsWith("set") || name.startsWith("get")) && (name.length() == 3 || this.primitiveMap.containsKey(name.substring(3)))) {
                    String newName = name + "Field";
                    Object newDesc = name.length() == 3 ? "Ljava/lang/Object;" : this.primitiveMap.get(name.substring(3));
                    newDesc = name.startsWith("s") ? "(Ljava/lang/reflect/Field;Ljava/lang/Object;" + (String)newDesc + ")V" : "(Ljava/lang/reflect/Field;Ljava/lang/Object;)" + (String)newDesc;
                    this.mv.visitMethodInsn(184, ReflectFieldTransformer.OUR_REFLECTION_CLASS, newName, (String)newDesc, false);
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                }
            }
        }
    }
}

