/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import meldexun.asmutil2.ASMUtil;
import meldexun.asmutil2.ClassTransformException;
import meldexun.asmutil2.IClassTransformer;

public abstract class AbstractClassTransformer
implements IClassTransformer {
    @Override
    public byte[] transform(String obfName, String name, byte[] basicClass) {
        byte[] transformedClass;
        try {
            transformedClass = this.transformOrNull(obfName, name, basicClass);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed transforming class: %s", name);
            ASMUtil.LOGGER.error(errorMessage, (Throwable)e);
            throw new ClassTransformException(errorMessage, e);
        }
        if (transformedClass == null) {
            return basicClass;
        }
        ASMUtil.exportIfEnabled(name, transformedClass);
        return transformedClass;
    }

    protected abstract byte[] transformOrNull(String var1, String var2, byte[] var3);
}

