/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.tileentity.TileEntityMap;
import team.cqr.cqrepoured.util.GuiHandler;

public class BlockMapPlaceholder
extends BlockHorizontal {
    protected static final AxisAlignedBB LADDER_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB LADDER_WEST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB LADDER_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB LADDER_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);

    public BlockMapPlaceholder() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149722_s();
        this.func_149752_b(Float.MAX_VALUE);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K && placer instanceof EntityPlayer && !placer.func_70093_af()) {
            EnumFacing facing1 = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
            int x = pos.func_177958_n() - facing1.func_82601_c();
            int y = pos.func_177956_o() & 0x9FFFFFFF | facing1.func_176736_b() << 29;
            int z = pos.func_177952_p() - facing1.func_82599_e();
            ((EntityPlayer)placer).openGui((Object)CQRMain.INSTANCE, GuiHandler.MAP_GUI_SIMPLE_ID, worldIn, x, y, z);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            playerIn.openGui((Object)CQRMain.INSTANCE, GuiHandler.MAP_GUI_ID, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMap();
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            case NORTH: {
                return LADDER_NORTH_AABB;
            }
            case SOUTH: {
                return LADDER_SOUTH_AABB;
            }
            case WEST: {
                return LADDER_WEST_AABB;
            }
        }
        return LADDER_EAST_AABB;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (this.canAttachTo(worldIn, pos.func_177976_e(), side)) {
            return true;
        }
        if (this.canAttachTo(worldIn, pos.func_177974_f(), side)) {
            return true;
        }
        if (this.canAttachTo(worldIn, pos.func_177978_c(), side)) {
            return true;
        }
        return this.canAttachTo(worldIn, pos.func_177968_d(), side);
    }

    public boolean canAttachTo(World world, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = world.func_180495_p(pos);
        boolean flag = BlockMapPlaceholder.func_193382_c((Block)iblockstate.func_177230_c());
        return !flag && iblockstate.func_193401_d((IBlockAccess)world, pos, side) == BlockFaceShape.SOLID && !iblockstate.func_185897_m();
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (facing.func_176740_k().func_176722_c() && this.canAttachTo(worldIn, pos.func_177972_a(facing.func_176734_d()), facing)) {
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canAttachTo(worldIn, pos.func_177972_a(enumfacing.func_176734_d()), enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (!this.canAttachTo(worldIn, pos.func_177972_a(enumfacing.func_176734_d()), enumfacing)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176745_a();
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

