/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.capability.pathtool;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import team.cqr.cqrepoured.entity.pathfinding.Path;

public class CapabilityPath {
    private final ItemStack stack;
    private final Path path = new Path(){

        @Override
        public void onPathChanged() {
            super.onPathChanged();
            CapabilityPath.this.writeToStack();
        }
    };
    private Path.PathNode selectedNode;
    private boolean readFromStack = false;
    private boolean isReading = false;

    public CapabilityPath(ItemStack stack) {
        this.stack = stack;
    }

    public Path getPath() {
        this.readFromStack();
        return this.path;
    }

    public void setSelectedNode(Path.PathNode selectedNode) {
        this.selectedNode = selectedNode;
        this.writeToStack();
    }

    public Path.PathNode getSelectedNode() {
        this.readFromStack();
        return this.selectedNode;
    }

    private void writeToStack() {
        if (this.isReading) {
            return;
        }
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.stack.func_77982_d(tag);
        }
        tag.func_74782_a("path", (NBTBase)this.path.writeToNBT());
        tag.func_74768_a("selectedNode", this.selectedNode != null ? this.selectedNode.getIndex() : -1);
    }

    private void readFromStack() {
        if (this.readFromStack) {
            return;
        }
        this.readFromStack = true;
        this.isReading = true;
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            this.isReading = false;
            return;
        }
        if (tag.func_150297_b("path", 10)) {
            this.path.readFromNBT(tag.func_74775_l("path"));
        }
        if (tag.func_150297_b("selectedNode", 3)) {
            this.selectedNode = this.path.getNode(tag.func_74762_e("selectedNode"));
        }
        this.isReading = false;
        this.writeToStack();
    }
}

