/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.gui;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.Validate;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.util.GuiHelper;
import team.cqr.cqrepoured.util.datafixer.StructureUpper;
import team.cqr.cqrepoured.util.tool.Progress;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;

public class GuiMigrateStructures
extends GuiScreen {
    private final GuiScreen parent;
    private final List<GuiTextField> textFieldList = new ArrayList<GuiTextField>();
    private GuiTextField textFieldSrc;
    private GuiTextField textFieldDest;
    private GuiButton buttonExit;
    private GuiButton buttonCancel;
    private GuiButton buttonMigrateStructures;
    private boolean canExit = true;
    private Optional<MigrateStructuresTask> task = Optional.empty();

    public GuiMigrateStructures(GuiScreen parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 0;
        this.textFieldSrc = new GuiTextField(id++, this.field_146289_q, this.field_146294_l / 2 - 200, 50, 400, 20);
        this.textFieldSrc.func_146203_f(256);
        this.textFieldSrc.func_146180_a(CQRMain.CQ_STRUCTURE_FILES_FOLDER.getPath());
        this.textFieldDest = new GuiTextField(id++, this.field_146289_q, this.field_146294_l / 2 - 200, 100, 400, 20);
        this.textFieldDest.func_146203_f(256);
        this.textFieldDest.func_146180_a(CQRMain.CQ_MIGRATED_STRUCTURE_FILES_FOLDER.getPath());
        this.buttonExit = new GuiButton(id++, 5, 5, 20, 20, "X"){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                if (!GuiMigrateStructures.this.canExit) {
                    return false;
                }
                GuiMigrateStructures.this.field_146297_k.func_147108_a(GuiMigrateStructures.this.parent);
                return true;
            }
        };
        this.buttonCancel = new GuiButton(id++, this.field_146294_l / 2 - 102, this.field_146295_m - 24, 100, 20, "Cancel"){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                GuiMigrateStructures.this.task.ifPresent(MigrateStructuresTask::cancel);
                return true;
            }
        };
        this.buttonCancel.field_146124_l = false;
        this.buttonMigrateStructures = new GuiButton(id++, this.field_146294_l / 2 + 2, this.field_146295_m - 24, 100, 20, "Migrate Structures"){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                Path src = Paths.get(GuiMigrateStructures.this.textFieldSrc.func_146179_b(), new String[0]);
                Path dest = Paths.get(GuiMigrateStructures.this.textFieldDest.func_146179_b(), new String[0]);
                GuiMigrateStructures.this.task = Optional.of(new MigrateStructuresTask(src, dest));
                GuiMigrateStructures.this.canExit = false;
                ((GuiMigrateStructures)GuiMigrateStructures.this).buttonExit.field_146124_l = false;
                ((GuiMigrateStructures)GuiMigrateStructures.this).buttonCancel.field_146124_l = true;
                ((GuiMigrateStructures)GuiMigrateStructures.this).buttonMigrateStructures.field_146124_l = false;
                GuiMigrateStructures.this.task.ifPresent(task -> task.run().handleAsync((v, t) -> {
                    GuiMigrateStructures.this.canExit = true;
                    ((GuiMigrateStructures)GuiMigrateStructures.this).buttonExit.field_146124_l = true;
                    ((GuiMigrateStructures)GuiMigrateStructures.this).buttonCancel.field_146124_l = false;
                    ((GuiMigrateStructures)GuiMigrateStructures.this).buttonMigrateStructures.field_146124_l = true;
                    if (t != null) {
                        if (t instanceof Exception) {
                            CQRMain.logger.error("Failed migrating structures", t);
                        } else {
                            mc.func_71404_a(new CrashReport("Failed migrating structures", t));
                        }
                    }
                    return null;
                }));
                return true;
            }
        };
        this.textFieldList.clear();
        this.textFieldList.add(this.textFieldSrc);
        this.textFieldList.add(this.textFieldDest);
        this.field_146292_n.add(this.buttonExit);
        this.field_146292_n.add(this.buttonCancel);
        this.field_146292_n.add(this.buttonMigrateStructures);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        Optional<GuiTextField> focusedTextField = this.textFieldList.stream().filter(GuiTextField::func_146206_l).findFirst();
        if (focusedTextField.isPresent()) {
            if (keyCode == 1) {
                focusedTextField.get().func_146195_b(false);
            } else {
                focusedTextField.get().func_146201_a(typedChar, keyCode);
            }
        } else if (keyCode == 1) {
            if (this.canExit) {
                this.field_146297_k.func_147108_a(this.parent);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.textFieldList.forEach(tf -> tf.func_146192_a(mouseX, mouseY, mouseButton));
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.textFieldList.forEach(GuiTextField::func_146178_a);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.textFieldList.forEach(GuiTextField::func_146194_f);
        GuiHelper.drawString(this.field_146289_q, "Source Directory", this.field_146294_l / 2 - 200, 40, 0xF0F0F0, false, false);
        GuiHelper.drawString(this.field_146289_q, "Destination Directory", this.field_146294_l / 2 - 200, 90, 0xF0F0F0, false, false);
        this.task.ifPresent(task -> GuiHelper.drawString(this.field_146289_q, task.getProgress().toString(), this.field_146294_l / 2 + 120, this.field_146295_m - 18, 0xF0F0F0, false, false));
    }

    private static class MigrateStructuresTask {
        private final Path src;
        private final Path dest;
        private final Progress progress = new Progress(1);
        private volatile boolean cancelled;

        public MigrateStructuresTask(Path src, Path dest) {
            Validate.isTrue((boolean)Files.isDirectory(src, new LinkOption[0]));
            Validate.isTrue((!Files.exists(dest, new LinkOption[0]) || Files.isDirectory(dest, new LinkOption[0]) ? 1 : 0) != 0);
            this.src = src;
            this.dest = dest;
        }

        public CompletableFuture<Void> run() {
            return CompletableFuture.runAsync(() -> {
                try {
                    UnaryOperator destFactory;
                    Path[] srcFiles;
                    if (!Files.exists(this.src, new LinkOption[0])) {
                        throw new IllegalArgumentException();
                    }
                    if (Files.isDirectory(this.src, new LinkOption[0])) {
                        if (Files.isRegularFile(this.dest, new LinkOption[0])) {
                            throw new IllegalArgumentException();
                        }
                        srcFiles = (Path[])Files.find(this.src, Integer.MAX_VALUE, (p, a) -> p.getFileName().toString().endsWith(".nbt"), new FileVisitOption[0]).toArray(Path[]::new);
                        destFactory = p -> this.dest.resolve(this.src.relativize((Path)p));
                    } else {
                        if (!this.src.getFileName().toString().endsWith(".nbt")) {
                            throw new IllegalArgumentException();
                        }
                        srcFiles = (Path[])Stream.of(this.src).toArray(Path[]::new);
                        destFactory = Files.isDirectory(this.dest, new LinkOption[0]) ? p -> this.dest.resolve(p.getFileName()) : p -> this.dest;
                    }
                    for (int i = 0; i < srcFiles.length; ++i) {
                        if (this.cancelled) {
                            return;
                        }
                        Path file = srcFiles[i];
                        MigrateStructuresTask.migrate(file, (Path)destFactory.apply(file));
                        this.progress.setProgress((double)i / (double)srcFiles.length);
                    }
                    this.progress.finishStage();
                }
                catch (IOException e) {
                    this.progress.setErrored();
                    throw new RuntimeException(e);
                }
            });
        }

        private static void migrate(Path src, Path dest) throws IOException {
            CQStructure structure = CQStructure.createFromFile(src.toFile());
            NBTTagCompound migratedNBT = StructureUpper.createMigratableNBT(structure);
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(dest, new OpenOption[0]);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)migratedNBT, (OutputStream)out);
            }
        }

        public Progress getProgress() {
            return this.progress;
        }

        public void cancel() {
            this.progress.setCancelled();
            this.cancelled = true;
        }
    }
}

