/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.model.geo;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.model.AnimatedTickingGeoModel;
import team.cqr.cqrepoured.customtextures.IHasTextureOverride;
import team.cqr.cqrepoured.entity.ITextureVariants;

public abstract class ModelGeoCQRBase<T extends EntityLivingBase & IAnimationTickable>
extends AnimatedTickingGeoModel<T> {
    protected final ResourceLocation MODEL_RESLOC;
    protected final ResourceLocation TEXTURE_DEFAULT;
    protected final String ENTITY_REGISTRY_PATH_NAME;
    protected ResourceLocation[] textureVariantCache = null;

    public ModelGeoCQRBase(ResourceLocation model, ResourceLocation textureDefault, String entityName) {
        this.MODEL_RESLOC = model;
        this.TEXTURE_DEFAULT = textureDefault;
        this.ENTITY_REGISTRY_PATH_NAME = entityName;
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (entity instanceof IHasTextureOverride && ((IHasTextureOverride)entity).hasTextureOverride()) {
            return ((IHasTextureOverride)entity).getTextureOverride();
        }
        if (entity instanceof ITextureVariants && ((ITextureVariants)entity).getTextureCount() > 1) {
            int index;
            if (this.textureVariantCache == null) {
                this.textureVariantCache = new ResourceLocation[((ITextureVariants)entity).getTextureCount()];
            }
            if (this.textureVariantCache[index = ((ITextureVariants)entity).getTextureIndex()] == null) {
                this.textureVariantCache[index] = new ResourceLocation("cqrepoured", "textures/entity/" + this.ENTITY_REGISTRY_PATH_NAME + "_" + index + ".png");
            }
            return this.textureVariantCache[index];
        }
        return this.TEXTURE_DEFAULT;
    }

    public ResourceLocation getModelLocation(T object) {
        return this.MODEL_RESLOC;
    }
}

