/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.occlusion;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.occlusion.CachedBlockAccess;
import team.cqr.cqrepoured.client.occlusion.IntIntIntPredicate;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.PartialTicksUtil;

@SideOnly(value=Side.CLIENT)
public class EntityOcclusionTester {
    private static final CachedBlockAccess CACHED_BLOCK_ACCESS = new CachedBlockAccess();
    private static double camX;
    private static double camY;
    private static double camZ;
    private static double minX;
    private static double minY;
    private static double minZ;
    private static double maxX;
    private static double maxY;
    private static double maxZ;
    private static long resultCache;

    public static void onPreRenderTickEvent() {
        Minecraft mc = Minecraft.func_71410_x();
        CACHED_BLOCK_ACCESS.init((World)mc.field_71441_e);
        Entity entity = mc.func_175606_aa();
        if (entity != null) {
            double partialTick = PartialTicksUtil.getCurrentPartialTicks();
            double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * partialTick;
            double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * partialTick;
            double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * partialTick;
            Vec3d cam = ActiveRenderInfo.getCameraPosition();
            camX = x + cam.field_72450_a;
            camY = y + cam.field_72448_b;
            camZ = z + cam.field_72449_c;
        }
    }

    public static void onPostRenderTickEvent() {
        CACHED_BLOCK_ACCESS.clear();
    }

    public static boolean isNotOccluded(AbstractEntityCQR entity) {
        if (CQRMain.isEntityCullingInstalled) {
            return true;
        }
        if (!CQRConfig.advanced.skipHiddenEntityRendering) {
            return true;
        }
        if (!entity.func_184222_aU()) {
            return true;
        }
        AxisAlignedBB aabb = entity.func_184177_bl();
        minX = aabb.field_72340_a - 0.5;
        minY = aabb.field_72338_b - 0.5;
        minZ = aabb.field_72339_c - 0.5;
        maxX = aabb.field_72336_d + 0.5;
        maxY = aabb.field_72337_e + 0.5;
        maxZ = aabb.field_72334_f + 0.5;
        return EntityOcclusionTester.isAABBVisible();
    }

    private static boolean isAABBVisible() {
        if (camX >= minX && camX <= maxX && camY >= minY && camY <= maxY && camZ >= minZ && camZ <= maxZ) {
            return true;
        }
        resultCache = 0L;
        if (camX < minX ? EntityOcclusionTester.isPointOnPlaneVisible(0, EntityOcclusionTester::rayTraceBlocksYZX) : camX > maxX && EntityOcclusionTester.isPointOnPlaneVisible(2, EntityOcclusionTester::rayTraceBlocksYZX)) {
            return true;
        }
        if (camY < minY ? EntityOcclusionTester.isPointOnPlaneVisible(0, EntityOcclusionTester::rayTraceBlocksXZY) : camY > maxY && EntityOcclusionTester.isPointOnPlaneVisible(2, EntityOcclusionTester::rayTraceBlocksXZY)) {
            return true;
        }
        return camZ < minZ ? EntityOcclusionTester.isPointOnPlaneVisible(0, EntityOcclusionTester::rayTraceBlocksXYZ) : camZ > maxZ && EntityOcclusionTester.isPointOnPlaneVisible(2, EntityOcclusionTester::rayTraceBlocksXYZ);
    }

    private static boolean isPointOnPlaneVisible(int z, IntIntIntPredicate predicate) {
        if (predicate.test(1, 1, z)) {
            return true;
        }
        if (predicate.test(0, 0, z)) {
            return true;
        }
        if (predicate.test(0, 2, z)) {
            return true;
        }
        if (predicate.test(2, 0, z)) {
            return true;
        }
        return predicate.test(2, 2, z);
    }

    private static boolean rayTraceBlocksYZX(int y, int z, int x) {
        return EntityOcclusionTester.rayTraceBlocksCached(x, y, z);
    }

    private static boolean rayTraceBlocksXZY(int x, int z, int y) {
        return EntityOcclusionTester.rayTraceBlocksCached(x, y, z);
    }

    private static boolean rayTraceBlocksXYZ(int x, int y, int z) {
        return EntityOcclusionTester.rayTraceBlocksCached(x, y, z);
    }

    private static boolean rayTraceBlocksCached(int x, int y, int z) {
        int offset = ((x * 3 + y) * 3 + z) * 2;
        long value = resultCache >>> offset & 3L;
        if (value == 0L) {
            double endX = minX + (maxX - minX) * (double)x * 0.5;
            double endY = minY + (maxY - minY) * (double)y * 0.5;
            double endZ = minZ + (maxZ - minZ) * (double)z * 0.5;
            double threshold = CQRConfig.advanced.skipHiddenEntityRenderingDiff;
            value = EntityOcclusionTester.raytraceThreshold(camX, camY, camZ, endX, endY, endZ, threshold) ? 2L : 1L;
            resultCache |= value << offset;
        }
        return value == 2L;
    }

    private static boolean raytraceThreshold(double startX, double startY, double startZ, double endX, double endY, double endZ, double threshold) {
        double nextHitZ;
        double nextHitY;
        double d1;
        double nextHitX;
        if (threshold <= 0.0) {
            return EntityOcclusionTester.raytrace(startX, startY, startZ, endX, endY, endZ);
        }
        double dirX = endX - startX;
        double dirY = endY - startY;
        double dirZ = endZ - startZ;
        if (dirX * dirX + dirY * dirY + dirZ * dirZ <= threshold * threshold) {
            return true;
        }
        int x = EntityOcclusionTester.floor(startX);
        int y = EntityOcclusionTester.floor(startY);
        int z = EntityOcclusionTester.floor(startZ);
        int incX = EntityOcclusionTester.signum(dirX);
        int incY = EntityOcclusionTester.signum(dirY);
        int incZ = EntityOcclusionTester.signum(dirZ);
        double dx = incX == 0 ? Double.MAX_VALUE : (double)incX / dirX;
        double dy = incY == 0 ? Double.MAX_VALUE : (double)incY / dirY;
        double dz = incZ == 0 ? Double.MAX_VALUE : (double)incZ / dirZ;
        double percentX = dx * (incX > 0 ? 1.0 - EntityOcclusionTester.frac(startX) : EntityOcclusionTester.frac(startX));
        double percentY = dy * (incY > 0 ? 1.0 - EntityOcclusionTester.frac(startY) : EntityOcclusionTester.frac(startY));
        double percentZ = dz * (incZ > 0 ? 1.0 - EntityOcclusionTester.frac(startZ) : EntityOcclusionTester.frac(startZ));
        if (EntityOcclusionTester.isOpaque(x, y, z) && (threshold -= EntityOcclusionTester.dist(startX, startY, startZ, nextHitX = startX + dirX * (d1 = Math.min(Math.min(Math.min(percentX, percentY), percentZ), 1.0)), nextHitY = startY + dirY * d1, nextHitZ = startZ + dirZ * d1)) <= 0.0) {
            return false;
        }
        while (percentX <= 1.0 || percentY <= 1.0 || percentZ <= 1.0) {
            double nextHitZ2;
            double nextHitY2;
            double d12;
            double nextHitX2;
            double hitZ;
            double hitY;
            EnumFacing.Axis axis;
            if (percentX < percentY) {
                if (percentX < percentZ) {
                    x += incX;
                    percentX += dx;
                    axis = EnumFacing.Axis.X;
                } else {
                    z += incZ;
                    percentZ += dz;
                    axis = EnumFacing.Axis.Z;
                }
            } else if (percentY < percentZ) {
                y += incY;
                percentY += dy;
                axis = EnumFacing.Axis.Y;
            } else {
                z += incZ;
                percentZ += dz;
                axis = EnumFacing.Axis.Z;
            }
            if (!EntityOcclusionTester.isOpaque(x, y, z)) continue;
            double d = axis != EnumFacing.Axis.X ? (axis != EnumFacing.Axis.Y ? percentZ - dz : percentY - dy) : percentX - dx;
            double d2 = Math.min(d, 1.0);
            double hitX = startX + dirX * d2;
            if (!((threshold -= EntityOcclusionTester.dist(hitX, hitY = startY + dirY * d2, hitZ = startZ + dirZ * d2, nextHitX2 = startX + dirX * (d12 = Math.min(Math.min(Math.min(percentX, percentY), percentZ), 1.0)), nextHitY2 = startY + dirY * d12, nextHitZ2 = startZ + dirZ * d12)) <= 0.0)) continue;
            return false;
        }
        return true;
    }

    private static boolean raytrace(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        int z;
        int y;
        int x = EntityOcclusionTester.floor(startX);
        if (EntityOcclusionTester.isOpaque(x, y = EntityOcclusionTester.floor(startY), z = EntityOcclusionTester.floor(startZ))) {
            return false;
        }
        double dirX = endX - startX;
        double dirY = endY - startY;
        double dirZ = endZ - startZ;
        int incX = EntityOcclusionTester.signum(dirX);
        int incY = EntityOcclusionTester.signum(dirY);
        int incZ = EntityOcclusionTester.signum(dirZ);
        double dx = incX == 0 ? Double.MAX_VALUE : (double)incX / dirX;
        double dy = incY == 0 ? Double.MAX_VALUE : (double)incY / dirY;
        double dz = incZ == 0 ? Double.MAX_VALUE : (double)incZ / dirZ;
        double percentX = dx * (incX > 0 ? 1.0 - EntityOcclusionTester.frac(startX) : EntityOcclusionTester.frac(startX));
        double percentY = dy * (incY > 0 ? 1.0 - EntityOcclusionTester.frac(startY) : EntityOcclusionTester.frac(startY));
        double percentZ = dz * (incZ > 0 ? 1.0 - EntityOcclusionTester.frac(startZ) : EntityOcclusionTester.frac(startZ));
        while (percentX <= 1.0 || percentY <= 1.0 || percentZ <= 1.0) {
            if (percentX < percentY) {
                if (percentX < percentZ) {
                    x += incX;
                    percentX += dx;
                } else {
                    z += incZ;
                    percentZ += dz;
                }
            } else if (percentY < percentZ) {
                y += incY;
                percentY += dy;
            } else {
                z += incZ;
                percentZ += dz;
            }
            if (!EntityOcclusionTester.isOpaque(x, y, z)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOpaque(int x, int y, int z) {
        return CACHED_BLOCK_ACCESS.getBlockState(x, y, z).func_185914_p();
    }

    public static int signum(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double frac(double number) {
        return number - (double)EntityOcclusionTester.floor(number);
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(EntityOcclusionTester.distSqr(x1, y1, z1, x2, y2, z2));
    }

    public static double distSqr(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x2 -= x1) * x2 + (y2 -= y1) * y2 + (z2 -= z1) * z2;
    }
}

