/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import team.cqr.cqrepoured.client.model.entity.ModelCQRBiped;
import team.cqr.cqrepoured.client.occlusion.EntityOcclusionTester;
import team.cqr.cqrepoured.client.render.MagicBellRenderer;
import team.cqr.cqrepoured.client.render.entity.layer.equipment.LayerCQREntityArmor;
import team.cqr.cqrepoured.client.render.entity.layer.equipment.LayerCQREntityCape;
import team.cqr.cqrepoured.client.render.entity.layer.equipment.LayerCQREntityPotion;
import team.cqr.cqrepoured.client.render.entity.layer.equipment.LayerCQRHeldItem;
import team.cqr.cqrepoured.client.render.entity.layer.equipment.LayerShoulderEntity;
import team.cqr.cqrepoured.client.render.entity.layer.special.LayerCQRLeaderFeather;
import team.cqr.cqrepoured.client.render.entity.layer.special.LayerCQRSpeechbubble;
import team.cqr.cqrepoured.client.render.texture.InvisibilityTexture;
import team.cqr.cqrepoured.customtextures.IHasTextureOverride;
import team.cqr.cqrepoured.entity.ITextureVariants;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.item.ItemHookshotBase;
import team.cqr.cqrepoured.item.gun.ItemMusket;
import team.cqr.cqrepoured.item.gun.ItemMusketKnife;
import team.cqr.cqrepoured.item.gun.ItemRevolver;

public class RenderCQREntity<T extends AbstractEntityCQR>
extends RenderLiving<T> {
    public ResourceLocation texture;
    public double widthScale;
    public double heightScale;
    private final String entityName;
    protected ResourceLocation[] textureVariantCache = null;

    public RenderCQREntity(RenderManager rendermanagerIn, String textureName) {
        this(rendermanagerIn, textureName, 1.0, 1.0, false);
    }

    public RenderCQREntity(RenderManager rendermanagerIn, String textureName, boolean hasExtraLayer) {
        this(rendermanagerIn, textureName, 1.0, 1.0, hasExtraLayer);
    }

    public RenderCQREntity(RenderManager rendermanagerIn, String textureName, double widthScale, double heightScale) {
        this(rendermanagerIn, textureName, widthScale, heightScale, false);
    }

    public RenderCQREntity(RenderManager rendermanagerIn, String textureName, double widthScale, double heightScale, boolean hasExtraLayer) {
        this(rendermanagerIn, (ModelBase)new ModelCQRBiped(64, 64, hasExtraLayer), 0.5f, textureName, widthScale, heightScale);
    }

    public RenderCQREntity(RenderManager rendermanagerIn, ModelBase model, float shadowSize, String textureName, double widthScale, double heightScale) {
        super(rendermanagerIn, model, shadowSize);
        this.entityName = textureName;
        this.texture = new ResourceLocation("cqrepoured", "textures/entity/" + this.entityName + ".png");
        this.widthScale = widthScale;
        this.heightScale = heightScale;
        this.func_177094_a((LayerRenderer)new LayerCQREntityArmor((RenderLivingBase<?>)this));
        this.func_177094_a((LayerRenderer)new LayerCQRHeldItem((RenderLivingBase<?>)this));
        this.func_177094_a((LayerRenderer)new LayerArrow((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerElytra((RenderLivingBase)this));
        this.func_177094_a(new LayerCQREntityCape(this));
        this.func_177094_a(new LayerCQREntityPotion(this));
        this.func_177094_a(new LayerCQRSpeechbubble(this));
        if (model instanceof ModelBiped) {
            this.func_177094_a(new LayerShoulderEntity(this));
            if (model instanceof ModelCQRBiped) {
                this.func_177094_a(new LayerCQRLeaderFeather(this, ((ModelCQRBiped)model).field_78116_c));
                this.func_177094_a((LayerRenderer)new LayerCustomHead(((ModelCQRBiped)model).field_78116_c));
            }
        }
    }

    protected double getWidthScale(T entity) {
        return this.widthScale * (double)((AbstractEntityCQR)entity).getSizeVariation();
    }

    protected double getHeightScale(T entity) {
        return this.heightScale * (double)((AbstractEntityCQR)entity).getSizeVariation();
    }

    protected void preRenderCallback(T entitylivingbaseIn, float partialTickTime) {
        super.func_77041_b(entitylivingbaseIn, partialTickTime);
        double width = this.getWidthScale(entitylivingbaseIn);
        double height = this.getHeightScale(entitylivingbaseIn);
        GL11.glScaled((double)width, (double)height, (double)width);
        if (this.field_77045_g.field_78093_q) {
            GL11.glTranslatef((float)0.0f, (float)0.6f, (float)0.0f);
        }
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!EntityOcclusionTester.isNotOccluded(entity)) {
            return;
        }
        if (this.field_77045_g instanceof ModelBiped) {
            EnumAction action;
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            ModelBiped model = (ModelBiped)this.field_77045_g;
            ItemStack itemMainHand = entity.func_184614_ca();
            ItemStack itemOffHand = entity.func_184592_cb();
            ModelBiped.ArmPose armPoseMain = ModelBiped.ArmPose.EMPTY;
            ModelBiped.ArmPose armPoseOff = ModelBiped.ArmPose.EMPTY;
            boolean dontRenderOffItem = false;
            boolean dontRenderMainItem = false;
            boolean flagMain = false;
            boolean flagOff = false;
            if (!itemMainHand.func_190926_b()) {
                if (itemMainHand.func_77973_b() instanceof ItemMusket || itemMainHand.func_77973_b() instanceof ItemMusketKnife) {
                    armPoseMain = ModelBiped.ArmPose.BOW_AND_ARROW;
                    dontRenderOffItem = true;
                } else if (itemMainHand.func_77973_b() instanceof ItemRevolver || itemMainHand.func_77973_b() instanceof ItemHookshotBase) {
                    flagMain = true;
                } else if (entity.func_184605_cv() > 0) {
                    action = itemMainHand.func_77975_n();
                    switch (action) {
                        case DRINK: 
                        case EAT: {
                            armPoseMain = ModelBiped.ArmPose.ITEM;
                            break;
                        }
                        case BOW: {
                            armPoseMain = ModelBiped.ArmPose.BOW_AND_ARROW;
                            dontRenderOffItem = true;
                            break;
                        }
                        case BLOCK: {
                            armPoseMain = ModelBiped.ArmPose.BLOCK;
                            break;
                        }
                    }
                }
            }
            if (!itemOffHand.func_190926_b()) {
                if (itemOffHand.func_77973_b() instanceof ItemMusket || itemOffHand.func_77973_b() instanceof ItemMusketKnife) {
                    armPoseOff = ModelBiped.ArmPose.BOW_AND_ARROW;
                    dontRenderMainItem = true;
                } else if (itemMainHand.func_77973_b() instanceof ItemRevolver || itemOffHand.func_77973_b() instanceof ItemHookshotBase) {
                    flagOff = true;
                } else if (entity.func_184605_cv() > 0) {
                    action = itemOffHand.func_77975_n();
                    switch (action) {
                        case DRINK: 
                        case EAT: {
                            armPoseOff = ModelBiped.ArmPose.ITEM;
                            break;
                        }
                        case BOW: {
                            armPoseOff = ModelBiped.ArmPose.BOW_AND_ARROW;
                            dontRenderMainItem = true;
                            break;
                        }
                        case BLOCK: {
                            armPoseOff = ModelBiped.ArmPose.BLOCK;
                            break;
                        }
                    }
                }
            }
            if (entity.func_184591_cq() == EnumHandSide.LEFT) {
                ModelBiped.ArmPose tmp = armPoseMain;
                armPoseMain = armPoseOff;
                armPoseOff = tmp;
                boolean tmp2 = dontRenderMainItem;
                dontRenderMainItem = dontRenderOffItem;
                dontRenderOffItem = tmp2;
            }
            if (!flagMain) {
                model.field_187076_m = armPoseMain;
            }
            if (!flagOff) {
                model.field_187075_l = armPoseOff;
            }
            if (dontRenderMainItem) {
                model.field_187076_m = ModelBiped.ArmPose.EMPTY;
            }
            if (dontRenderOffItem) {
                model.field_187075_l = ModelBiped.ArmPose.EMPTY;
            }
        }
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        if (this.field_77045_g instanceof ModelBiped) {
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
    }

    protected void renderModel(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag;
        boolean bl = flag = ((AbstractEntityCQR)entitylivingbaseIn).getInvisibility() > 0.0f;
        if (flag) {
            GlStateManager.func_179092_a((int)516, (float)((AbstractEntityCQR)entitylivingbaseIn).getInvisibility());
            this.func_110776_a(InvisibilityTexture.get(this.getEntityTexture(entitylivingbaseIn)));
            this.field_77045_g.func_78088_a(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179143_c((int)514);
        }
        super.func_77036_a(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        if (flag) {
            GlStateManager.func_179143_c((int)515);
        }
    }

    protected void renderLivingAt(T entityLivingBaseIn, double x, double y, double z) {
        if (this.field_77045_g instanceof ModelBiped) {
            ((ModelBiped)this.field_77045_g).field_78093_q = entityLivingBaseIn.func_184218_aH() || ((AbstractEntityCQR)entityLivingBaseIn).isSitting();
            ((ModelBiped)this.field_77045_g).field_78117_n = entityLivingBaseIn.func_70093_af();
        }
        super.func_77039_a(entityLivingBaseIn, x, y, z);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        if (entity instanceof IHasTextureOverride && entity.hasTextureOverride()) {
            return entity.getTextureOverride();
        }
        if (entity instanceof ITextureVariants && entity.getTextureCount() > 1) {
            int index;
            if (this.textureVariantCache == null) {
                this.textureVariantCache = new ResourceLocation[entity.getTextureCount()];
            }
            if (this.textureVariantCache[index = entity.getTextureIndex()] == null) {
                this.textureVariantCache[index] = new ResourceLocation("cqrepoured", "textures/entity/" + this.entityName + "_" + index + ".png");
            }
            return this.textureVariantCache[index];
        }
        return this.texture;
    }

    public void func_76979_b(Entity entityIn, double x, double y, double z, float yaw, float partialTicks) {
        this.field_76989_e *= ((AbstractEntityCQR)entityIn).getSizeVariation();
        this.field_76987_f = MathHelper.func_76131_a((float)(1.0f - ((AbstractEntityCQR)entityIn).getInvisibility()), (float)0.0f, (float)1.0f);
        super.func_76979_b(entityIn, x, y, z, yaw, partialTicks);
        this.field_76989_e /= ((AbstractEntityCQR)entityIn).getSizeVariation();
    }

    protected int getTeamColor(T entityIn) {
        if (MagicBellRenderer.outlineColor != -1) {
            return MagicBellRenderer.outlineColor;
        }
        return super.func_188298_c(entityIn);
    }

    public void setupHeadOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupBodyOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupRightArmOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupLeftArmOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupRightLegOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupLeftLegOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupHeadwearOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupPotionOffsets(ModelRenderer modelRenderer) {
    }

    protected void applyTranslations(ModelRenderer modelRenderer) {
        GlStateManager.func_179109_b((float)modelRenderer.field_82906_o, (float)modelRenderer.field_82908_p, (float)modelRenderer.field_82907_q);
        GlStateManager.func_179109_b((float)(modelRenderer.field_78800_c * 0.0625f), (float)(modelRenderer.field_78797_d * 0.0625f), (float)(modelRenderer.field_78798_e * 0.0625f));
    }

    protected void resetTranslations(ModelRenderer modelRenderer) {
        GlStateManager.func_179109_b((float)(-modelRenderer.field_78800_c * 0.0625f), (float)(-modelRenderer.field_78797_d * 0.0625f), (float)(-modelRenderer.field_78798_e * 0.0625f));
        GlStateManager.func_179109_b((float)(-modelRenderer.field_82906_o), (float)(-modelRenderer.field_82908_p), (float)(-modelRenderer.field_82907_q));
    }

    protected void applyRotations(ModelRenderer modelRenderer) {
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected void resetRotations(ModelRenderer modelRenderer) {
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78795_f)), (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78796_g)), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78808_h)), (float)0.0f, (float)0.0f, (float)-1.0f);
    }
}

