/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.client.model.entity.ModelLaser;
import team.cqr.cqrepoured.client.util.EmissiveUtil;
import team.cqr.cqrepoured.entity.boss.AbstractEntityLaser;

public class RenderLaser<T extends AbstractEntityLaser>
extends Render<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cqrepoured", "textures/effects/ray.png");
    private final ModelBase model = new ModelLaser();

    public RenderLaser(RenderManager renderManager) {
        super(renderManager);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return TEXTURE;
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EmissiveUtil.preEmissiveTextureRendering();
        if (((AbstractEntityLaser)((Object)entity)).caster == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        double x1 = ((AbstractEntityLaser)((Object)entity)).caster.field_70142_S + (((AbstractEntityLaser)((Object)entity)).caster.field_70165_t - ((AbstractEntityLaser)((Object)entity)).caster.field_70142_S) * (double)partialTicks;
        double y1 = ((AbstractEntityLaser)((Object)entity)).caster.field_70137_T + (((AbstractEntityLaser)((Object)entity)).caster.field_70163_u - ((AbstractEntityLaser)((Object)entity)).caster.field_70137_T) * (double)partialTicks;
        double z1 = ((AbstractEntityLaser)((Object)entity)).caster.field_70136_U + (((AbstractEntityLaser)((Object)entity)).caster.field_70161_v - ((AbstractEntityLaser)((Object)entity)).caster.field_70136_U) * (double)partialTicks;
        Vec3d offset = ((AbstractEntityLaser)((Object)entity)).getOffsetVector();
        x1 += offset.field_72450_a;
        y1 += offset.field_72448_b;
        z1 += offset.field_72449_c;
        float yaw = this.getYaw(entity, partialTicks);
        float pitch = this.getPitch(entity, partialTicks);
        Entity renderViewEntity = mc.func_175606_aa();
        double x2 = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double y2 = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double z2 = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        GlStateManager.func_179132_a((boolean)false);
        this.func_180548_c((Entity)entity);
        GlStateManager.func_179137_b((double)(x1 - x2), (double)(y1 - y2), (double)(z1 - z2));
        GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)-1.0, (double)-1.0, (double)1.0);
        double laserLength = this.getLaserLength(entity, pitch, yaw);
        GlStateManager.func_179094_E();
        double d3 = 1.0;
        GlStateManager.func_179139_a((double)d3, (double)d3, (double)laserLength);
        float f3 = 0.33333334f;
        GlStateManager.func_179131_c((float)((AbstractEntityLaser)((Object)entity)).getColorR(), (float)((AbstractEntityLaser)((Object)entity)).getColorG(), (float)((AbstractEntityLaser)((Object)entity)).getColorB(), (float)f3);
        this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        double d2 = 0.6666666666666666;
        GlStateManager.func_179139_a((double)d2, (double)d2, (double)laserLength);
        float f2 = 0.6666667f;
        GlStateManager.func_179131_c((float)((AbstractEntityLaser)((Object)entity)).getColorR(), (float)((AbstractEntityLaser)((Object)entity)).getColorG(), (float)((AbstractEntityLaser)((Object)entity)).getColorB(), (float)f2);
        this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        double d1 = 0.3333333333333333;
        GlStateManager.func_179139_a((double)d1, (double)d1, (double)laserLength);
        float f1 = 1.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
        this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        EmissiveUtil.postEmissiveTextureRendering();
    }

    protected float getPitch(T entity, float partialTicks) {
        return this.interpolateRotation(((AbstractEntityLaser)((Object)entity)).prevRotationPitchCQR, ((AbstractEntityLaser)((Object)entity)).rotationPitchCQR, partialTicks);
    }

    protected float getYaw(T entity, float partialTicks) {
        return this.interpolateRotation(((AbstractEntityLaser)((Object)entity)).prevRotationYawCQR, ((AbstractEntityLaser)((Object)entity)).rotationYawCQR, partialTicks);
    }

    protected double getLaserLength(T entity, float partialTicks) {
        return this.getLaserLength(entity, this.getPitch(entity, partialTicks), this.getYaw(entity, partialTicks));
    }

    protected double getLaserLength(T entity, float pitch, float yaw) {
        Vec3d end;
        Vec3d start = entity.func_174791_d();
        RayTraceResult result = ((AbstractEntityLaser)((Object)entity)).field_70170_p.func_147447_a(start, end = start.func_178787_e(Vec3d.func_189986_a((float)pitch, (float)yaw).func_186678_a((double)((AbstractEntityLaser)((Object)entity)).length)), false, true, false);
        double d = result != null ? (double)((float)result.field_72307_f.func_178788_d(entity.func_174791_d()).func_72433_c()) : (double)((AbstractEntityLaser)((Object)entity)).length;
        return d;
    }

    protected float interpolateRotation(float prevRotation, float rotation, float partialTicks) {
        return prevRotation + MathHelper.func_76142_g((float)(rotation - prevRotation)) * partialTicks;
    }

    public void func_76979_b(Entity entityIn, double x, double y, double z, float yaw, float partialTicks) {
    }
}

