/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.shader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;

public class ShaderProgram {
    private static final Logger LOGGER = LogManager.getLogger();
    private int shaderProgram = GL20.glCreateProgram();

    private ShaderProgram(Int2ObjectMap<Supplier<String>> shaderMap) {
        int linkStatus;
        IntArrayList shaderList = new IntArrayList();
        for (Int2ObjectMap.Entry entry : shaderMap.int2ObjectEntrySet()) {
            int compileStatus;
            int shader2 = GL20.glCreateShader((int)entry.getIntKey());
            GL20.glShaderSource((int)shader2, (CharSequence)((CharSequence)((Supplier)entry.getValue()).get()));
            GL20.glCompileShader((int)shader2);
            int logLength = GL20.glGetShaderi((int)shader2, (int)35716);
            if (logLength > 0) {
                LOGGER.info(() -> GL20.glGetShaderInfoLog((int)shader2, (int)logLength));
            }
            if ((compileStatus = GL20.glGetShaderi((int)shader2, (int)35713)) != 1) {
                throw new RuntimeException("Failed to compile shader: " + compileStatus);
            }
            shaderList.add(shader2);
        }
        shaderList.forEach(shader -> GL20.glAttachShader((int)this.shaderProgram, (int)shader));
        GL20.glLinkProgram((int)this.shaderProgram);
        int logLength = GL20.glGetProgrami((int)this.shaderProgram, (int)35716);
        if (logLength > 0) {
            LOGGER.info(() -> GL20.glGetProgramInfoLog((int)this.shaderProgram, (int)logLength));
        }
        if ((linkStatus = GL20.glGetProgrami((int)this.shaderProgram, (int)35714)) != 1) {
            throw new RuntimeException("Failed to link programm: " + linkStatus);
        }
        shaderList.forEach(GL20::glDeleteShader);
    }

    public void use() {
        GL20.glUseProgram((int)this.shaderProgram);
    }

    public void delete() {
        GL20.glDeleteProgram((int)this.shaderProgram);
    }

    public int getShaderProgram() {
        return this.shaderProgram;
    }

    public static class Builder {
        private final Int2ObjectMap<Supplier<String>> shaderMap = new Int2ObjectOpenHashMap();

        public Builder addShader(int type, Supplier<String> source) {
            this.shaderMap.put(type, source);
            return this;
        }

        public ShaderProgram build() {
            return new ShaderProgram(this.shaderMap);
        }
    }
}

