/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.command;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import team.cqr.cqrepoured.util.EntityUtil;
import team.cqr.cqrepoured.util.IndentableStringBuilder;
import team.cqr.cqrepoured.world.structure.protection.IProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegion;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegionManager;

public class CommandGetProtectedRegion
extends CommandBase {
    public String func_71517_b() {
        return "cqr_get_protected_region";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/cqr_get_protected_region x y z";
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        BlockPos pos = CommandGetProtectedRegion.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
        IProtectedRegionManager protectedRegionManager = ProtectedRegionManager.getInstance(sender.func_130014_f_());
        if (protectedRegionManager != null) {
            List<ProtectedRegion> protectedRegions = protectedRegionManager.getProtectedRegionsAt(pos);
            IndentableStringBuilder sb = new IndentableStringBuilder();
            sb.append("Protected Regions at (%d, %d, %d):", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).newLine();
            sb.incrementIndentation();
            if (protectedRegions.isEmpty()) {
                sb.append("NONE");
            } else {
                for (int i = 0; i < protectedRegions.size(); ++i) {
                    ProtectedRegion protectedRegion = protectedRegions.get(i);
                    sb.append(i).append(':').newLine();
                    sb.incrementIndentation();
                    sb.append("Name: %s", protectedRegion.getName()).newLine();
                    sb.append("UUID: %s", protectedRegion.getUuid()).newLine();
                    sb.append("Entities: [").newLine();
                    sb.incrementIndentation();
                    for (UUID entityUUID : protectedRegion.getEntityDependencies()) {
                        Entity entity = EntityUtil.getEntityByUUID(sender.func_130014_f_(), entityUUID);
                        if (entity != null) {
                            sb.append("%s (%d, %d, %d)", entity.getClass().getSimpleName(), MathHelper.func_76143_f((double)entity.field_70165_t), MathHelper.func_76143_f((double)entity.field_70163_u), MathHelper.func_76143_f((double)entity.field_70161_v)).newLine();
                            continue;
                        }
                        sb.append(entityUUID).newLine();
                    }
                    sb.decrementIndentation();
                    sb.append("]").newLine();
                    sb.append("Blocks: [").newLine();
                    sb.incrementIndentation();
                    for (BlockPos blockPos : protectedRegion.getBlockDependencies()) {
                        sb.append("%d, %d, %d", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()).newLine();
                    }
                    sb.decrementIndentation();
                    sb.append("]");
                }
            }
            sb.decrementIndentation();
            sender.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length >= 1 && args.length <= 3) {
            return CommandGetProtectedRegion.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
        }
        return Collections.emptyList();
    }
}

