/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.command;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.tileentity.TileEntityExporter;
import team.cqr.cqrepoured.world.structure.generation.DungeonDataManager;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonGenerationManager;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class CommandImport
extends CommandBase {
    public String func_71517_b() {
        return "cqr_import_all";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/cqr_import_all";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        try {
            World world = sender.func_130014_f_();
            BlockPos pos = sender.func_180425_c().func_177982_a(2, 0, 2);
            Map fileMap = Files.find(CQRMain.CQ_STRUCTURE_FILES_FOLDER.toPath(), Integer.MAX_VALUE, (p, a) -> a.isRegularFile() && p.getFileName().toString().endsWith(".nbt"), new FileVisitOption[0]).collect(Collectors.groupingBy(Path::getParent, LinkedHashMap::new, Collectors.toList()));
            boolean importMode = CQRConfig.advanced.structureImportMode;
            AtomicInteger importModeModifications = new AtomicInteger();
            AtomicInteger z = new AtomicInteger();
            fileMap.values().forEach(files -> {
                AtomicInteger maxSizeZ = new AtomicInteger();
                AtomicInteger x = new AtomicInteger();
                files.forEach(file -> {
                    CQStructure structure = CQStructure.createFromFile(file.toFile());
                    if (x.get() != 0 && x.get() + structure.getSize().func_177958_n() > 1024) {
                        z.getAndAdd(maxSizeZ.get() + 10);
                        maxSizeZ.set(0);
                        x.set(0);
                    }
                    BlockPos structurePos = pos.func_177982_a(x.get(), 0, z.get());
                    DungeonGenerationManager.generate(world, () -> {
                        AtomicInteger atomicInteger = importModeModifications;
                        synchronized (atomicInteger) {
                            importModeModifications.getAndIncrement();
                            CQRConfig.advanced.structureImportMode = true;
                        }
                        try {
                            GeneratableDungeon.Builder builder = new GeneratableDungeon.Builder(world, structurePos.func_177982_a(2, 0, 2), "Import-" + file.getFileName().toString(), DungeonInhabitantManager.DEFAULT_DUNGEON_INHABITANT.getName());
                            structure.addAll(builder, structurePos.func_177982_a(2, 0, 2), Offset.NORTH_EAST);
                            GeneratableDungeon generatableDungeon = builder.build(world);
                            return generatableDungeon;
                        }
                        finally {
                            AtomicInteger atomicInteger2 = importModeModifications;
                            synchronized (atomicInteger2) {
                                if (importModeModifications.decrementAndGet() == 0) {
                                    CQRConfig.advanced.structureImportMode = importMode;
                                }
                            }
                        }
                    }, null, DungeonDataManager.DungeonSpawnType.DUNGEON_PLACER_ITEM);
                    world.func_175656_a(structurePos, CQRBlocks.EXPORTER.func_176223_P());
                    TileEntityExporter exporter = (TileEntityExporter)world.func_175625_s(structurePos);
                    String structureName = StringUtils.removeEnd((String)CQRMain.CQ_STRUCTURE_FILES_FOLDER.toPath().relativize((Path)file).toString(), (String)".nbt");
                    BlockPos[] unprotectedBlocks = structure.getUnprotectedBlockList().toArray(new BlockPos[0]);
                    exporter.setValues(structureName, new BlockPos(2, 0, 2), new BlockPos(1, -1, 1).func_177971_a((Vec3i)structure.getSize()), true, true, unprotectedBlocks);
                    if (structure.getSize().func_177952_p() > maxSizeZ.get()) {
                        maxSizeZ.set(structure.getSize().func_177952_p());
                    }
                    x.getAndAdd(structure.getSize().func_177958_n() + 10);
                });
                z.getAndAdd(maxSizeZ.get() + 30);
            });
            sender.func_145747_a((ITextComponent)new TextComponentString("Imported " + fileMap.values().stream().flatMap(Collection::stream).count() + " structures successfully"));
        }
        catch (Exception e) {
            CQRMain.logger.error("Failed importing structures!", (Throwable)e);
            throw new CommandException("Failed importing structures: %s", new Object[]{e});
        }
    }
}

