/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.customtextures;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.customtextures.CTResourcepack;
import team.cqr.cqrepoured.customtextures.CompressionUtil;
import team.cqr.cqrepoured.customtextures.TextureSet;
import team.cqr.cqrepoured.customtextures.TextureSetManager;
import team.cqr.cqrepoured.customtextures.TextureUtil;
import team.cqr.cqrepoured.network.server.packet.SPacketCustomTextures;

public class ClientPacketHandler {
    public static void handleCTPacketClientside(SPacketCustomTextures message) {
        TextureSetManager.unloadTextures();
        CTResourcepack.clear();
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (Map.Entry<String, byte[]> entry : message.getTextureMap().entrySet()) {
            String path = entry.getKey();
            File tf = new File(CQRMain.CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC, path);
            if (tf == null) continue;
            if (tf.exists()) {
                tf.delete();
            }
            if (tf.getParentFile() != null && !tf.getParentFile().exists()) {
                tf.getParentFile().mkdirs();
            }
            if (CompressionUtil.decodeBase64ToFile(tf, entry.getValue())) {
                fileMap.put(path, tf);
                continue;
            }
            CQRMain.logger.warn("Unable to decode a file using base64! Entry: {}   File: {}", (Object)entry.getValue(), (Object)tf);
        }
        for (Map.Entry<String, Object> entry : message.getTextureSets().entrySet()) {
            TextureSet ts = new TextureSet(entry.getKey());
            for (Map.Entry texEntry : ((Map)entry.getValue()).entrySet()) {
                for (ResourceLocation trs : (Set)texEntry.getValue()) {
                    File file = fileMap.getOrDefault(trs.func_110623_a(), null);
                    if (file != null) {
                        TextureUtil.loadFileInResourcepack(file, trs);
                    }
                    ts.addTexture((ResourceLocation)texEntry.getKey(), trs);
                }
            }
            TextureSetManager.registerTextureSet(ts);
        }
        TextureUtil.reloadResourcepacks();
    }
}

