/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.customtextures;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.customtextures.TextureSetManager;

public class TextureSet {
    private static final Random random = new Random();
    private String name;
    private Map<ResourceLocation, Set<ResourceLocation>> entityTextureMap = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    private static Map<String, File> files = new HashMap<String, File>();
    private static Map<String, ResourceLocation> texNameRLMap = new HashMap<String, ResourceLocation>();

    public TextureSet(String name) {
        this.name = name;
        this.entityTextureMap.clear();
    }

    public void addTexture(ResourceLocation entity, ResourceLocation texture) {
        this.entityTextureMap.computeIfAbsent(entity, key -> new HashSet()).add(texture);
    }

    public TextureSet(Properties config, String name) {
        this.name = name;
        try {
            for (String entry : config.stringPropertyNames()) {
                if (entry.startsWith("#")) continue;
                String rlkey = entry.replace('.', ':');
                ResourceLocation resLoc = new ResourceLocation(rlkey);
                String texturesString = config.getProperty(entry, "");
                if (texturesString.isEmpty()) continue;
                texturesString = texturesString.replaceAll(" ", "");
                for (String texture : texturesString.split(",")) {
                    File tf = new File(CQRMain.CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES, texture + ".png");
                    if (tf == null || !tf.exists()) continue;
                    files.put(texture + ".png", tf);
                    ResourceLocation rs = new ResourceLocation("cqrepoured_ctts_" + this.name, texture + ".png");
                    texNameRLMap.put(texture + ".png", rs);
                    this.addTexture(resLoc, rs);
                    File mf = new File(CQRMain.CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES, texture + ".png.mcmeta");
                    if (mf == null || !mf.exists()) continue;
                    files.put(texture + ".png.mcmeta", mf);
                    rs = new ResourceLocation("cqrepoured_ctts_" + this.name, texture + ".png.mcmeta");
                    texNameRLMap.put(texture + ".png.mcmeta", rs);
                }
            }
            if (!this.entityTextureMap.isEmpty()) {
                TextureSetManager.registerTextureSet(this);
            }
        }
        catch (Exception ex) {
            this.entityTextureMap.clear();
        }
    }

    @Nullable
    public ResourceLocation getRandomTextureFor(Entity ent) {
        ResourceLocation ers = EntityList.func_191301_a((Entity)ent);
        if (this.entityTextureMap.containsKey(ers) && !this.entityTextureMap.get(ers).isEmpty()) {
            Object[] textures = this.entityTextureMap.get(ers).toArray();
            int indx = random.nextInt(textures.length);
            return (ResourceLocation)textures[indx];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Set<ResourceLocation> getTextures() {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>();
        for (Set<ResourceLocation> st : this.entityTextureMap.values()) {
            try {
                ret.addAll(st);
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public void clearTextureCache() {
        for (Set<ResourceLocation> st : this.entityTextureMap.values()) {
            try {
                st.clear();
            }
            catch (Exception exception) {}
        }
        this.entityTextureMap.clear();
        files.clear();
    }

    public static Map<String, File> getLoadedFiles() {
        return new HashMap<String, File>(files);
    }

    public static ResourceLocation getResLocOfTexture(String textureFilePath) {
        return texNameRLMap.getOrDefault(textureFilePath, new ResourceLocation("cqrepoured:wtf"));
    }

    public Map<ResourceLocation, Set<ResourceLocation>> getMappings() {
        return new HashMap<ResourceLocation, Set<ResourceLocation>>(this.entityTextureMap);
    }
}

