/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

public class EntityAIIdleSit
extends AbstractCQREntityAI<AbstractEntityCQR> {
    protected static final int COOLDOWN_BORDER = 50;
    protected static final int COOLDOWN_FOR_PARTNER_CYCLE_BORDER = 100;
    private Entity talkingPartner = null;
    private int cooldown = 0;
    private int cooldwonForPartnerCycle = 0;
    protected final Predicate<AbstractEntityCQR> predicate;

    public EntityAIIdleSit(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(2);
        this.predicate = input -> {
            if (input == null) {
                return false;
            }
            if (!EntitySelectors.field_94557_a.apply(input)) {
                return false;
            }
            return this.isEntityAlly((AbstractEntityCQR)input);
        };
    }

    public boolean func_75250_a() {
        if (!this.entity.field_70122_E) {
            return false;
        }
        if (this.entity.func_70027_ad()) {
            return false;
        }
        if (this.entity.func_184218_aH()) {
            return false;
        }
        if (this.isEntityMoving((Entity)this.entity)) {
            return false;
        }
        return this.entity.func_70638_az() == null;
    }

    public void func_75251_c() {
        this.cooldown = 0;
        this.cooldwonForPartnerCycle = 0;
        this.talkingPartner = null;
        this.entity.setSitting(false);
        this.entity.setChatting(false);
    }

    public void func_75246_d() {
        if (++this.cooldown > 50) {
            this.entity.setSitting(true);
            if (this.entity.hasTrades()) {
                this.entity.setChatting(true);
                return;
            }
            if (++this.cooldwonForPartnerCycle > 100) {
                this.cooldwonForPartnerCycle = 0;
                double x = this.entity.field_70165_t;
                double r = 6.0;
                double y = this.entity.field_70163_u;
                double z = this.entity.field_70161_v;
                AxisAlignedBB aabb = new AxisAlignedBB(x - r, y - r * 0.5, z - r, x + r, y + r * 0.5, z + r);
                List friends = this.entity.field_70170_p.func_175647_a(AbstractEntityCQR.class, aabb, this.predicate);
                if (!friends.isEmpty()) {
                    this.talkingPartner = (Entity)friends.get(this.random.nextInt(friends.size()));
                }
            }
            if (this.talkingPartner != null) {
                if (this.talkingPartner.func_70089_S() && this.entity.func_70068_e(this.talkingPartner) < 64.0) {
                    this.entity.setChatting(true);
                    this.entity.func_70671_ap().func_75651_a(this.talkingPartner, 15.0f, 15.0f);
                    double dx = this.talkingPartner.field_70165_t - this.entity.field_70165_t;
                    double dz = this.talkingPartner.field_70161_v - this.entity.field_70161_v;
                    this.entity.field_70177_z = (float)Math.toDegrees(MathHelper.func_181159_b((double)dz, (double)dx)) - 90.0f;
                } else {
                    this.talkingPartner = null;
                    this.entity.setChatting(false);
                }
            } else {
                this.entity.setChatting(false);
            }
        }
    }

    private boolean isEntityAlly(AbstractEntityCQR possibleAlly) {
        if (possibleAlly == this.entity) {
            return false;
        }
        EntityLivingBase leader = TargetUtil.getLeaderOrOwnerRecursive((EntityLivingBase)this.entity);
        EntityLivingBase targetLeader = TargetUtil.getLeaderOrOwnerRecursive((EntityLivingBase)possibleAlly);
        if (!(leader instanceof EntityPlayer) && targetLeader instanceof EntityPlayer) {
            return false;
        }
        if (!TargetUtil.isAllyCheckingLeaders(leader, targetLeader)) {
            return false;
        }
        return this.entity.func_70635_at().func_75522_a((Entity)possibleAlly);
    }

    private boolean isEntityMoving(Entity entity) {
        return entity.field_70159_w != 0.0 || Math.abs(entity.field_70181_x) > 0.1 || entity.field_70179_y != 0.0;
    }
}

