/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.endercalamity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.AbstractBossAIEnderCalamity;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderCalamity;

public abstract class AbstractBossAIRandomShoot
extends AbstractBossAIEnderCalamity {
    private int cooldown;
    private E_PHASE currentPhase = E_PHASE.PREPARING_TO_SHOOT;
    @Nullable
    protected Entity projectile;

    protected AbstractBossAIRandomShoot(EntityCQREnderCalamity entity) {
        super(entity);
        this.func_75248_a(2);
    }

    @Override
    public boolean func_75250_a() {
        if (this.entity != null && ((EntityCQREnderCalamity)this.entity).hasAttackTarget()) {
            return this.canExecuteDuringPhase(((EntityCQREnderCalamity)this.entity).getCurrentPhase());
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.currentPhase = E_PHASE.PREPARING_TO_TELEPORT;
        this.cooldown = this.execPrepareShoot();
    }

    public boolean faceTarget() {
        return true;
    }

    public void func_75246_d() {
        --this.cooldown;
        if (((EntityCQREnderCalamity)this.entity).hasAttackTarget()) {
            if (this.faceTarget()) {
                ((EntityCQREnderCalamity)this.entity).func_70625_a((Entity)((EntityCQREnderCalamity)this.entity).func_70638_az(), 90.0f, 90.0f);
            }
            ((EntityCQREnderCalamity)this.entity).setCantUpdatePhase(false);
        }
        if (this.cooldown <= 0) {
            switch (this.currentPhase) {
                case PREPARING_TO_SHOOT: {
                    this.cooldown = this.execRandomShoot();
                    this.currentPhase = E_PHASE.SHOOTING;
                    break;
                }
                case PREPARING_TO_TELEPORT: {
                    if (this.projectile != null) {
                        this.projectile.func_70106_y();
                    }
                    this.cooldown = 1;
                    this.currentPhase = E_PHASE.TELEPORT;
                    break;
                }
                case SHOOTING: {
                    this.cooldown = 10;
                    this.currentPhase = E_PHASE.PREPARING_TO_TELEPORT;
                    this.cooldown += this.execAfterShoot();
                    break;
                }
                case TELEPORT: {
                    ((EntityCQREnderCalamity)this.entity).forceTeleport();
                    this.cooldown = this.execPrepareShoot();
                    this.currentPhase = E_PHASE.PREPARING_TO_SHOOT;
                    break;
                }
            }
            ((EntityCQREnderCalamity)this.entity).setCantUpdatePhase(this.currentPhase != E_PHASE.PREPARING_TO_TELEPORT || this.currentPhase != E_PHASE.TELEPORT);
        }
    }

    public int execAfterShoot() {
        return 1;
    }

    public abstract int execPrepareShoot();

    public void func_75251_c() {
        this.killProjectile();
        ((EntityCQREnderCalamity)this.entity).setCantUpdatePhase(false);
        super.func_75251_c();
    }

    protected void killProjectile() {
        if (this.projectile != null) {
            this.projectile.func_70106_y();
        }
    }

    protected abstract int execRandomShoot();

    private static enum E_PHASE {
        TELEPORT,
        SHOOTING,
        PREPARING_TO_SHOOT,
        PREPARING_TO_TELEPORT;

    }
}

