/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.endercalamity;

import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.AbstractBossAIEnderCalamity;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderCalamity;
import team.cqr.cqrepoured.entity.boss.endercalamity.phases.EEnderCalamityPhase;
import team.cqr.cqrepoured.entity.mobs.EntityCQREnderman;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class BossAISummonMinions
extends AbstractBossAIEnderCalamity {
    private int minionSpawnTick = 0;
    private int borderMinion = 80;
    private float borderHPForMinions = 0.75f;

    public BossAISummonMinions(EntityCQREnderCalamity entity) {
        super(entity);
        this.func_75248_a(0);
    }

    public int func_75247_h() {
        return 0;
    }

    @Override
    public boolean func_75250_a() {
        return ((EntityCQREnderCalamity)this.entity).hasAttackTarget() && super.func_75250_a();
    }

    public boolean func_75253_b() {
        return this.func_75250_a() && ((EntityCQREnderCalamity)this.entity).func_110143_aJ() <= this.borderHPForMinions * ((EntityCQREnderCalamity)this.entity).func_110138_aP();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.minionSpawnTick < this.borderMinion) {
            ++this.minionSpawnTick;
            return;
        }
        this.minionSpawnTick = 0;
        if (((EntityCQREnderCalamity)this.entity).getSummonedEntities().size() >= this.getMaxMinionsPerTime()) {
            this.borderMinion = 100;
            if (((EntityCQREnderCalamity)this.entity).filterSummonLists()) {
                this.borderMinion = 50;
            }
        } else {
            this.borderMinion = 80;
            double seed = 1.0f - ((EntityCQREnderCalamity)this.entity).func_110143_aJ() / ((EntityCQREnderCalamity)this.entity).func_110138_aP();
            AbstractEntityCQR minion = this.getNewMinion((int)(seed *= DungeonGenUtils.percentageRandom(0.2, this.world.field_73012_v) ? 4.0 : 3.0), this.world);
            BlockPos pos = ((EntityCQREnderCalamity)this.entity).hasHomePositionCQR() ? ((EntityCQREnderCalamity)this.entity).getHomePositionCQR() : ((EntityCQREnderCalamity)this.entity).func_180425_c();
            pos = pos.func_177982_a(-2 + ((EntityCQREnderCalamity)this.entity).func_70681_au().nextInt(3), 0, -2 + ((EntityCQREnderCalamity)this.entity).func_70681_au().nextInt(3));
            minion.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            ((EntityCQREnderCalamity)this.entity).setSummonedEntityFaction((Entity)minion);
            if (DungeonGenUtils.percentageRandom(0.33, this.world.field_73012_v)) {
                minion.setItemStackToExtraSlot(EntityEquipmentExtraSlot.BADGE, this.generateBadgeWithPotion());
            }
            minion.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, ItemStack.field_190927_a);
            if (minion instanceof EntityCQREnderman) {
                ((EntityCQREnderman)minion).setMayTeleport(false);
            }
            ((EntityCQREnderCalamity)this.entity).addSummonedEntityToList((Entity)minion);
            ((EntityCQREnderCalamity)this.entity).tryEquipSummon((Entity)minion, this.world.field_73012_v);
            this.world.func_72838_d((Entity)minion);
        }
    }

    private int getMaxMinionsPerTime() {
        int absoluteMax = 3;
        float hpPercentage = ((EntityCQREnderCalamity)this.entity).func_110143_aJ() / ((EntityCQREnderCalamity)this.entity).func_110138_aP();
        hpPercentage = 1.0f - hpPercentage;
        return Math.round((float)(absoluteMax += this.world.func_175659_aa().func_151525_a()) * hpPercentage);
    }

    private AbstractEntityCQR getNewMinion(int seed, World world) {
        EntityCQREnderman entity = new EntityCQREnderman(world);
        entity.func_180482_a(this.world.func_175649_E(new BlockPos((Entity)entity)), null);
        switch (seed) {
            case 4: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u));
                entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(CQRItems.SHIELD_SKELETON_FRIENDS));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151161_ac));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151163_ad));
                entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151173_ae));
                entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151175_af));
                break;
            }
            case 3: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
                entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151165_aa));
                entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151167_ab));
                break;
            }
            case 2: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
                break;
            }
            case 1: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            }
        }
        return entity;
    }

    @Override
    protected boolean canExecuteDuringPhase(EEnderCalamityPhase currentPhase) {
        return currentPhase.getPhaseObject().canSummonAlliesDuringPhase();
    }

    private ItemStack generateBadgeWithPotion() {
        ItemStack stack = new ItemStack(CQRItems.BADGE, 1);
        IItemHandler inventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        inventory.insertItem(0, new ItemStack(CQRItems.POTION_HEALING, 1), false);
        return stack;
    }
}

