/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.giantspider;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.bases.ISummoner;
import team.cqr.cqrepoured.entity.boss.EntityCQRGiantSpider;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class BossAISpiderSummonMinions
extends AbstractCQREntityAI<EntityCQRGiantSpider> {
    protected ISummoner summoner = null;
    protected int MAX_MINIONS = 6;
    protected int MAX_MINIONS_AT_A_TIME = 3;
    protected ResourceLocation minionOverride = new ResourceLocation("cqrepoured", "spider_egg");
    private int cooldown = 0;
    private static final int MAX_COOLDOWN = 150;
    private static final int MIN_COOLDOWN = 50;

    public BossAISpiderSummonMinions(EntityCQRGiantSpider spiderqueen) {
        super(spiderqueen);
        this.summoner = spiderqueen;
    }

    public boolean func_75250_a() {
        if (this.summoner == null || this.entity == null) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (!((EntityCQRGiantSpider)this.entity).hasAttackTarget()) {
            return false;
        }
        if (this.getAliveMinionCount() < this.MAX_MINIONS && (double)(((EntityCQRGiantSpider)this.entity).func_110143_aJ() / ((EntityCQRGiantSpider)this.entity).func_110138_aP()) <= 0.75) {
            return this.cooldown <= 0;
        }
        return false;
    }

    protected int getAliveMinionCount() {
        int aliveMinions = 0;
        for (Entity minio : this.summoner.getSummonedEntities()) {
            if (minio == null || minio.field_70128_L) continue;
            ++aliveMinions;
        }
        return aliveMinions;
    }

    public void func_75249_e() {
        if (this.summoner == null || this.entity == null) {
            return;
        }
        int minionCount = Math.min(this.MAX_MINIONS_AT_A_TIME, this.MAX_MINIONS - this.getAliveMinionCount());
        double angle = 360 / minionCount;
        Vec3d v = new Vec3d(1.0, 0.0, 0.0);
        for (int i = 0; i < minionCount; ++i) {
            Vec3d pos = ((EntityCQRGiantSpider)this.entity).func_174791_d().func_178787_e(v);
            v = VectorUtil.rotateVectorAroundY(v, angle);
            Entity minion = EntityList.func_188429_b((ResourceLocation)this.minionOverride, (World)((EntityCQRGiantSpider)this.entity).field_70170_p);
            minion.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            ((EntityCQRGiantSpider)this.entity).field_70170_p.func_72838_d(minion);
            if (this.summoner == null || this.summoner.getSummoner().field_70128_L) continue;
            this.summoner.setSummonedEntityFaction(minion);
            this.summoner.addSummonedEntityToList(minion);
        }
        this.cooldown = DungeonGenUtils.randomBetween(50, 150, ((EntityCQRGiantSpider)this.entity).func_70681_au());
    }

    public boolean func_75253_b() {
        return false;
    }
}

