/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.spectrelord;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.boss.spectrelord.EntityCQRSpectreLord;
import team.cqr.cqrepoured.entity.boss.spectrelord.EntitySpectreLordCurse;
import team.cqr.cqrepoured.faction.Faction;

public class EntityAISpectreLordChannelHate
extends AbstractEntityAISpell<EntityCQRSpectreLord>
implements IEntityAISpellAnimatedVanilla {
    private final List<EntitySpectreLordCurse> curses = new ArrayList<EntitySpectreLordCurse>();
    private float healthLost;
    private float lastHealth;

    public EntityAISpectreLordChannelHate(EntityCQRSpectreLord entity, int cooldown, int chargingTicks, int castingTicks) {
        super(entity, cooldown, chargingTicks, castingTicks);
        this.setup(true, false, false, false);
    }

    @Override
    public boolean shouldContinueExecuting() {
        if (!super.shouldContinueExecuting()) {
            return false;
        }
        if (!this.isCasting()) {
            return true;
        }
        if (!this.curses.isEmpty()) {
            boolean flag = false;
            for (EntitySpectreLordCurse curse : this.curses) {
                if (!curse.func_70089_S()) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
        }
        return this.healthLost < 0.15f;
    }

    @Override
    public void resetTask() {
        super.resetTask();
        for (EntitySpectreLordCurse curse : this.curses) {
            curse.func_70106_y();
        }
        this.curses.clear();
        this.healthLost = 0.0f;
        this.lastHealth = 0.0f;
    }

    @Override
    public void startCastingSpell() {
        super.startCastingSpell();
        this.lastHealth = ((EntityCQRSpectreLord)this.entity).func_110143_aJ() / ((EntityCQRSpectreLord)this.entity).func_110138_aP();
        AxisAlignedBB aabb = new AxisAlignedBB(((EntityCQRSpectreLord)this.entity).field_70165_t - 32.0, ((EntityCQRSpectreLord)this.entity).field_70163_u - 8.0, ((EntityCQRSpectreLord)this.entity).field_70161_v - 32.0, ((EntityCQRSpectreLord)this.entity).field_70165_t + 32.0, ((EntityCQRSpectreLord)this.entity).field_70163_u + (double)((EntityCQRSpectreLord)this.entity).field_70131_O + 8.0, ((EntityCQRSpectreLord)this.entity).field_70161_v + 32.0);
        Faction faction = ((EntityCQRSpectreLord)this.entity).getFaction();
        List list = this.world.func_175647_a(EntityLivingBase.class, aabb, e -> TargetUtil.PREDICATE_ATTACK_TARGET.apply(e) && (faction == null || !faction.isAlly((Entity)e)));
        list.sort((e1, e2) -> {
            double d2;
            boolean flag2;
            boolean flag1;
            if (faction != null) {
                flag1 = faction.isEnemy((Entity)e1);
                flag2 = faction.isEnemy((Entity)e2);
                if (flag1 && !flag2) {
                    return -1;
                }
                if (!flag1 && flag2) {
                    return 1;
                }
            }
            flag1 = e1 instanceof EntityPlayer;
            flag2 = e2 instanceof EntityPlayer;
            if (flag1 && !flag2) {
                return -1;
            }
            if (!flag1 && flag2) {
                return 1;
            }
            double d1 = ((EntityCQRSpectreLord)this.entity).func_70068_e((Entity)e1);
            if (d1 < (d2 = ((EntityCQRSpectreLord)this.entity).func_70068_e((Entity)e2))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        });
        for (int i = 0; i < 8 && i < list.size(); ++i) {
            EntityLivingBase e3 = (EntityLivingBase)list.get(i);
            EntitySpectreLordCurse curse = new EntitySpectreLordCurse(this.world, (EntityLivingBase)this.entity, e3);
            curse.func_70107_b(((EntityCQRSpectreLord)this.entity).field_70165_t, ((EntityCQRSpectreLord)this.entity).field_70163_u, ((EntityCQRSpectreLord)this.entity).field_70161_v);
            this.world.func_72838_d((Entity)curse);
            this.curses.add(curse);
        }
    }

    @Override
    public void castSpell() {
        super.castSpell();
        float f = ((EntityCQRSpectreLord)this.entity).func_110143_aJ() / ((EntityCQRSpectreLord)this.entity).func_110138_aP();
        this.healthLost += Math.max(this.lastHealth - f, 0.0f);
        this.lastHealth = f;
        if (this.tick == this.chargingTicks + this.castingTicks - 1) {
            ((EntityCQRSpectreLord)this.entity).func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200, 1, false, true));
            ((EntityCQRSpectreLord)this.entity).func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 1, false, true));
            AxisAlignedBB aabb = new AxisAlignedBB(((EntityCQRSpectreLord)this.entity).field_70165_t - 32.0, ((EntityCQRSpectreLord)this.entity).field_70163_u - 8.0, ((EntityCQRSpectreLord)this.entity).field_70161_v - 32.0, ((EntityCQRSpectreLord)this.entity).field_70165_t + 32.0, ((EntityCQRSpectreLord)this.entity).field_70163_u + (double)((EntityCQRSpectreLord)this.entity).field_70131_O + 8.0, ((EntityCQRSpectreLord)this.entity).field_70161_v + 32.0);
            Faction faction = ((EntityCQRSpectreLord)this.entity).getFaction();
            for (EntityLivingBase e2 : this.world.func_175647_a(EntityLivingBase.class, aabb, e -> TargetUtil.PREDICATE_ATTACK_TARGET.apply(e) && (faction == null || !faction.isAlly((Entity)e)))) {
                e2.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.entity).func_76348_h(), 4.0f);
                e2.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 1, false, true));
            }
            ((EntityCQRSpectreLord)this.entity).func_184185_a(SoundEvents.field_191244_bn, 1.0f, 0.9f + this.random.nextFloat() * 0.2f);
        }
    }

    @Override
    protected SoundEvent getStartChargingSound() {
        return SoundEvents.field_191247_bq;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public boolean ignoreWeight() {
        return false;
    }

    @Override
    public float getRed() {
        return 0.7f;
    }

    @Override
    public float getGreen() {
        return 0.15f;
    }

    @Override
    public float getBlue() {
        return 0.1f;
    }
}

