/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.spectrelord;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.boss.spectrelord.EntityCQRSpectreLord;
import team.cqr.cqrepoured.entity.boss.spectrelord.EntitySpectreLordIllusion;
import team.cqr.cqrepoured.faction.Faction;

public class EntityAISpectreLordSummonIllusions
extends AbstractEntityAISpell<EntityCQRSpectreLord>
implements IEntityAISpellAnimatedVanilla {
    private final int amount;
    private final int lifeTime;

    public EntityAISpectreLordSummonIllusions(EntityCQRSpectreLord entity, int cooldown, int chargingTicks, int amount, int lifeTime) {
        super(entity, cooldown, chargingTicks, 1);
        this.setup(true, true, true, true);
        this.amount = Math.max(amount, 1);
        this.lifeTime = lifeTime;
    }

    @Override
    public void startCastingSpell() {
        super.startCastingSpell();
        if (((EntityCQRSpectreLord)this.entity).getSummonedEntities().isEmpty()) {
            this.summonIllusions();
        } else {
            this.absorbIllusions();
        }
    }

    private void summonIllusions() {
        Vec3d start = ((EntityCQRSpectreLord)this.entity).func_174824_e(1.0f);
        double d = this.random.nextDouble() * 360.0;
        for (int i = 0; i < this.amount; ++i) {
            double z;
            double y;
            double x;
            double d1 = d + ((double)i / (double)this.amount + (this.random.nextDouble() - 0.5) * 0.1) * 360.0;
            Vec3d look = Vec3d.func_189986_a((float)30.0f, (float)((float)d1));
            Vec3d end = start.func_178787_e(look.func_186678_a(8.0));
            RayTraceResult result = this.world.func_147447_a(start, end, false, true, false);
            if (result != null) {
                x = result.field_72307_f.field_72450_a;
                y = result.field_72307_f.field_72448_b;
                z = result.field_72307_f.field_72449_c;
                if (result.field_178784_b != EnumFacing.UP) {
                    double dx = ((EntityCQRSpectreLord)this.entity).field_70165_t - x;
                    double dz = ((EntityCQRSpectreLord)this.entity).field_70161_v - z;
                    double d2 = 0.5 / Math.sqrt(dx * dx + dz * dz);
                    x += dx * d2;
                    z += dz * d2;
                }
            } else {
                x = end.field_72450_a;
                y = end.field_72448_b;
                z = end.field_72449_c;
            }
            EntitySpectreLordIllusion illusion = new EntitySpectreLordIllusion(this.world, (EntityLivingBase)this.entity, this.lifeTime, i == 0, i == 2);
            illusion.func_70107_b(x, y, z);
            ((EntityCQRSpectreLord)this.entity).tryEquipSummon((Entity)illusion, this.world.field_73012_v);
            illusion.func_180482_a(this.world.func_175649_E(new BlockPos((Entity)illusion)), null);
            ((EntityCQRSpectreLord)this.entity).addSummonedEntityToList((Entity)illusion);
            this.world.func_72838_d((Entity)illusion);
            ((WorldServer)this.world).func_175739_a(EnumParticleTypes.SPELL, illusion.field_70165_t, illusion.field_70163_u + 0.5 * (double)illusion.field_70131_O, illusion.field_70161_v, 8, 0.25, 0.25, 0.25, 0.5, new int[0]);
        }
    }

    private void absorbIllusions() {
        super.startCastingSpell();
        float heal = 0.05f;
        for (Entity e2 : ((EntityCQRSpectreLord)this.entity).getSummonedEntities()) {
            if (!(e2.func_70068_e((Entity)this.entity) <= 1024.0)) continue;
            heal += 0.05f;
            e2.func_70106_y();
            ((WorldServer)this.world).func_175739_a(EnumParticleTypes.SPELL_INSTANT, e2.field_70165_t, e2.field_70163_u + (double)e2.field_70131_O * 0.5, e2.field_70161_v, 4, 0.25, 0.25, 0.25, 0.5, new int[0]);
        }
        AxisAlignedBB aabb = new AxisAlignedBB(((EntityCQRSpectreLord)this.entity).field_70165_t - 8.0, ((EntityCQRSpectreLord)this.entity).field_70163_u - 0.5, ((EntityCQRSpectreLord)this.entity).field_70161_v - 8.0, ((EntityCQRSpectreLord)this.entity).field_70165_t + 8.0, ((EntityCQRSpectreLord)this.entity).field_70163_u + (double)((EntityCQRSpectreLord)this.entity).field_70131_O + 0.5, ((EntityCQRSpectreLord)this.entity).field_70161_v + 8.0);
        Faction faction = ((EntityCQRSpectreLord)this.entity).getFaction();
        for (EntityLivingBase e3 : this.world.func_175647_a(EntityLivingBase.class, aabb, e -> TargetUtil.PREDICATE_ATTACK_TARGET.apply(e) && (faction == null || !faction.isAlly((Entity)e)))) {
            heal += 0.05f;
            e3.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.entity).func_76348_h(), 4.0f);
            e3.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 1, false, false));
        }
        ((EntityCQRSpectreLord)this.entity).func_70691_i(((EntityCQRSpectreLord)this.entity).func_110138_aP() * heal);
    }

    @Override
    protected SoundEvent getStartChargingSound() {
        return SoundEvents.field_191248_br;
    }

    @Override
    public int getWeight() {
        if (((EntityCQRSpectreLord)this.entity).getSummonedEntities().isEmpty()) {
            return 10;
        }
        return ((EntityCQRSpectreLord)this.entity).func_110143_aJ() / ((EntityCQRSpectreLord)this.entity).func_110138_aP() < 0.3334f ? 40 : 20;
    }

    @Override
    public boolean ignoreWeight() {
        return false;
    }

    @Override
    public float getRed() {
        return 0.5f;
    }

    @Override
    public float getGreen() {
        return 0.95f;
    }

    @Override
    public float getBlue() {
        return 1.0f;
    }
}

