/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.bases.ISummoner;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.item.ItemCursedBone;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityAICursedBoneSummoner
extends AbstractCQREntityAI<AbstractEntityCQR>
implements ISummoner {
    private List<Entity> summonedEntities = new ArrayList<Entity>();
    private static final int SUMMONS_PER_CAST = 2;
    private static final int MAX_COOLDOWN = 300;
    private static final int MIN_COOLDOWN = 200;
    private int prevTimeUsed;
    private int cooldown = 20;
    private int chargingTicks = 20;

    public EntityAICursedBoneSummoner(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(0);
    }

    private boolean hasCursedBone() {
        return this.entity.func_184614_ca().func_77973_b() instanceof ItemCursedBone || this.entity.func_184592_cb().func_77973_b() instanceof ItemCursedBone;
    }

    public boolean func_75250_a() {
        this.filterSummons();
        if (!this.hasCursedBone()) {
            return false;
        }
        if (!this.entity.hasAttackTarget()) {
            return false;
        }
        if (this.entity.field_70173_aa - this.prevTimeUsed < this.cooldown) {
            return false;
        }
        return this.summonedEntities.size() < this.getMaxSummonedEntities();
    }

    private int getMaxSummonedEntities() {
        switch (this.world.func_175659_aa()) {
            case HARD: {
                return 6;
            }
            case NORMAL: {
                return 5;
            }
        }
        return 4;
    }

    private void filterSummons() {
        if (this.summonedEntities.isEmpty()) {
            return;
        }
        this.summonedEntities.removeIf(e -> !e.func_70089_S());
    }

    public boolean func_75253_b() {
        if (!this.hasCursedBone()) {
            return false;
        }
        return this.chargingTicks >= 0;
    }

    public void func_75246_d() {
        int remainingEntitySlots;
        int mobCount;
        --this.chargingTicks;
        super.func_75246_d();
        ItemStack stack = this.entity.func_184614_ca();
        if (!(stack.func_77973_b() instanceof ItemCursedBone)) {
            stack = this.entity.func_184592_cb();
            if (!(stack.func_77973_b() instanceof ItemCursedBone)) {
                return;
            }
            this.entity.func_184609_a(EnumHand.OFF_HAND);
        } else {
            this.entity.func_184609_a(EnumHand.MAIN_HAND);
        }
        if (this.chargingTicks < 0 && (mobCount = Math.min(2, remainingEntitySlots = this.getMaxSummonedEntities() - this.summonedEntities.size())) > 0) {
            Vec3d vector = this.entity.func_70040_Z().func_72432_b().func_186678_a(3.0);
            ItemCursedBone cursedBone = (ItemCursedBone)stack.func_77973_b();
            for (int i = 0; i < mobCount; ++i) {
                Vec3d posV = this.entity.func_174791_d().func_178787_e(vector);
                BlockPos pos = new BlockPos(posV.field_72450_a, posV.field_72448_b, posV.field_72449_c);
                Optional<Entity> circle = cursedBone.spawnEntity(pos, this.world, stack, (EntityLivingBase)this.entity, this);
                if (!circle.isPresent()) continue;
                this.summonedEntities.add(circle.get());
                vector = VectorUtil.rotateVectorAroundY(vector, (double)(360 / mobCount));
            }
        }
    }

    public void func_75251_c() {
        this.cooldown = DungeonGenUtils.randomBetween(200, 300, this.entity.func_70681_au());
        this.chargingTicks = 20;
        this.prevTimeUsed = this.entity.field_70173_aa;
        super.func_75251_c();
    }

    @Override
    public Faction getSummonerFaction() {
        return this.entity.getFaction();
    }

    @Override
    public List<Entity> getSummonedEntities() {
        return this.summonedEntities;
    }

    @Override
    public EntityLivingBase getSummoner() {
        return this.entity;
    }

    @Override
    public void addSummonedEntityToList(Entity summoned) {
        this.summonedEntities.add(summoned);
        this.tryEquipSummon(summoned, this.world.field_73012_v);
    }
}

