/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.item;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.EntityUtil;

public class EntityAIHealingPotion
extends AbstractCQREntityAI<AbstractEntityCQR> {
    protected int ticksNotHealing;
    protected boolean isHealing;

    public EntityAIHealingPotion(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.entity.getHealingPotions() > 0 && this.entity.func_110143_aJ() <= Math.max(this.entity.func_110138_aP() * 0.15f, 5.0f);
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75499_g();
        this.ticksNotHealing = 0;
        this.isHealing = false;
    }

    public void func_75251_c() {
        this.ticksNotHealing = 0;
        this.isHealing = false;
        this.entity.func_184602_cy();
        if (this.entity.isHoldingPotion()) {
            this.entity.swapWeaponAndPotionSlotItemStacks();
        }
    }

    public void func_75246_d() {
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (this.isHealing) {
            this.entity.func_184609_a(EnumHand.MAIN_HAND);
        } else if (attackTarget == null) {
            this.startHealing();
        }
        boolean flag = true;
        if (attackTarget != null) {
            int alertRadius = CQRConfig.mobs.alertRadius;
            Vec3d vec1 = this.entity.func_174791_d().func_72441_c((double)alertRadius, (double)alertRadius * 0.5, (double)alertRadius);
            Vec3d vec2 = this.entity.func_174791_d().func_178786_a((double)alertRadius, (double)alertRadius * 0.5, (double)alertRadius);
            AxisAlignedBB aabb = new AxisAlignedBB(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
            List possibleEnts = this.entity.field_70170_p.func_175674_a((Entity)this.entity, aabb, TargetUtil.createPredicateAlly(this.entity.getFaction()));
            if (!possibleEnts.isEmpty()) {
                Entity e1 = null;
                int count = -1;
                double distance = Double.MAX_VALUE;
                for (Entity e2 : possibleEnts) {
                    AxisAlignedBB aabb1 = new AxisAlignedBB(e2.field_70165_t - 4.0, e2.field_70163_u - 2.0, e2.field_70161_v - 4.0, e2.field_70165_t + 4.0, e2.field_70163_u + 2.0, e2.field_70161_v + 4.0);
                    List list = e2.field_70170_p.func_175674_a(e2, aabb1, TargetUtil.createPredicateAlly(this.entity.getFaction()));
                    double d = this.entity.func_70068_e(e2);
                    if (list.size() <= count && (list.size() != count || !(d < distance))) continue;
                    e1 = e2;
                    count = list.size();
                    distance = d;
                }
                if (count >= 5) {
                    this.entity.func_70661_as().func_75497_a(e1, 1.0);
                    flag = false;
                }
            }
            boolean canMoveBackwards = this.canMoveBackwards();
            if (flag) {
                this.updateRotation((Entity)attackTarget, 2.5f, 2.5f);
                if (canMoveBackwards) {
                    EntityUtil.move2D((Entity)this.entity, 0.0, -0.2, this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1.5, this.entity.field_70759_as);
                }
            }
            if (!this.isHealing) {
                if (this.entity.field_70123_F || !canMoveBackwards || this.ticksNotHealing > 80 || this.entity.func_70032_d((Entity)attackTarget) > 8.0f) {
                    this.startHealing();
                } else {
                    this.checkAndPerformBlock();
                }
            }
        }
    }

    private void updateRotation(Entity entity, float deltaYaw, float deltaPitch) {
        double x = entity.field_70165_t - this.entity.field_70165_t;
        double y = entity.field_70163_u - this.entity.field_70163_u;
        double z = entity.field_70161_v - this.entity.field_70161_v;
        double d = Math.sqrt(x * x + z * z);
        float yaw = (float)Math.toDegrees(Math.atan2(-x, z));
        float pitch = (float)Math.toDegrees(Math.atan2(-y, d));
        this.entity.field_70177_z += MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)(yaw - this.entity.field_70177_z)), (float)(-deltaYaw), (float)deltaYaw);
        this.entity.field_70177_z = MathHelper.func_76142_g((float)this.entity.field_70177_z);
        this.entity.field_70125_A += MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)(pitch - this.entity.field_70125_A)), (float)(-deltaPitch), (float)deltaPitch);
        this.entity.field_70125_A = MathHelper.func_76131_a((float)this.entity.field_70125_A, (float)-90.0f, (float)90.0f);
        this.entity.field_70759_as = this.entity.field_70177_z;
    }

    private void checkAndPerformBlock() {
        ItemStack offhand;
        if (!this.entity.func_184585_cz() && (offhand = this.entity.func_184586_b(EnumHand.OFF_HAND)).func_77973_b().isShield(offhand, (EntityLivingBase)this.entity)) {
            this.entity.func_184598_c(EnumHand.OFF_HAND);
        }
    }

    private boolean canMoveBackwards() {
        double sin = -Math.sin(Math.toRadians(this.entity.field_70177_z));
        double cos = Math.cos(Math.toRadians(this.entity.field_70177_z));
        BlockPos pos = new BlockPos(this.entity.field_70165_t - sin, this.entity.field_70163_u - 0.001, this.entity.field_70161_v - cos);
        IBlockState state = this.entity.field_70170_p.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)this.entity.field_70170_p, pos, EnumFacing.UP);
    }

    public void startHealing() {
        if (!this.isHealing) {
            this.isHealing = true;
            if (!this.entity.isHoldingPotion()) {
                this.entity.swapWeaponAndPotionSlotItemStacks();
            }
            this.entity.func_184602_cy();
            this.entity.func_184598_c(EnumHand.MAIN_HAND);
        }
    }
}

