/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.spells;

import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.misc.EntitySummoningCircle;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityAISummonMeteors
extends AbstractEntityAISpell<AbstractEntityCQR>
implements IEntityAISpellAnimatedVanilla {
    protected static final int MIN_FIREBALLS_PER_CAST = 3;
    protected static final int MAX_FIREBALLS_PER_CAST = 12;

    public EntityAISummonMeteors(AbstractEntityCQR entity, int cooldown, int chargingTicks) {
        super(entity, cooldown, chargingTicks, 1);
        this.setup(true, true, true, false);
    }

    @Override
    public void startCastingSpell() {
        Vec3d vector = this.entity.func_70040_Z().func_72432_b();
        vector = vector.func_178787_e(vector).func_178787_e(vector).func_178787_e(vector).func_178787_e(vector);
        int ballCount = DungeonGenUtils.randomBetween(3, 12, this.entity.func_70681_au());
        if (ballCount > 0) {
            double angle = 360.0 / (double)ballCount;
            BlockPos[] spawnPositions = new BlockPos[ballCount];
            BlockPos centeredPos = this.entity.func_70638_az().func_180425_c();
            Vec3d v = this.entity.func_70638_az().func_174791_d().func_178788_d(this.entity.func_174791_d());
            v = v.func_72432_b().func_186678_a((double)Math.abs(ballCount / 3 - 2));
            centeredPos = centeredPos.func_177963_a(v.field_72450_a, v.field_72448_b, v.field_72449_c);
            for (int i = 0; i < ballCount; ++i) {
                spawnPositions[i] = centeredPos.func_177971_a((Vec3i)new BlockPos(VectorUtil.rotateVectorAroundY(vector, angle * (double)i)));
            }
            for (BlockPos p : spawnPositions) {
                if (this.entity.func_70661_as().func_179680_a(p) == null) continue;
                ResourceLocation summon = new ResourceLocation("cqrepoured", "projectile_hot_fireball");
                EntitySummoningCircle.ECircleTexture texture = EntitySummoningCircle.ECircleTexture.METEOR;
                EntitySummoningCircle circle = new EntitySummoningCircle(this.entity.field_70170_p, summon, 0.1f, texture, null);
                circle.setSummon(summon);
                circle.func_70107_b(p.func_177958_n(), (double)p.func_177956_o() + 10.0, p.func_177952_p());
                circle.setVelocityForSummon(new Vec3d(0.0, -1.0, 0.0));
                this.entity.field_70170_p.func_72838_d((Entity)circle);
            }
        }
    }

    @Override
    protected SoundEvent getStartChargingSound() {
        return SoundEvents.field_187855_gD;
    }

    @Override
    protected SoundEvent getStartCastingSound() {
        return SoundEvents.field_193784_dd;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public boolean ignoreWeight() {
        return false;
    }

    @Override
    public float getRed() {
        return 0.8f;
    }

    @Override
    public float getGreen() {
        return 0.0f;
    }

    @Override
    public float getBlue() {
        return 0.0f;
    }
}

