/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.target;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.item.IFakeWeapon;
import team.cqr.cqrepoured.item.ISupportWeapon;

public class EntityAICQRNearestAttackTarget
extends AbstractCQREntityAI<AbstractEntityCQR> {
    public EntityAICQRNearestAttackTarget(AbstractEntityCQR entity) {
        super(entity);
    }

    protected void wrapperSetAttackTarget(EntityLivingBase target) {
        this.entity.func_70624_b(target);
    }

    protected EntityLivingBase wrapperGetAttackTarget() {
        return this.entity.func_70638_az();
    }

    public boolean func_75250_a() {
        if (this.world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.wrapperSetAttackTarget(null);
            return false;
        }
        if (this.isStillSuitableTarget(this.wrapperGetAttackTarget())) {
            return false;
        }
        this.wrapperSetAttackTarget(null);
        return this.random.nextInt(3) == 0;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        AxisAlignedBB aabb = this.entity.func_174813_aQ().func_186662_g(32.0);
        List possibleTargets = this.world.func_72872_a(EntityLivingBase.class, aabb);
        ArrayList<EntityLivingBase> possibleTargetsAlly = new ArrayList<EntityLivingBase>();
        ArrayList<EntityLivingBase> possibleTargetsEnemy = new ArrayList<EntityLivingBase>();
        this.fillLists(possibleTargets, possibleTargetsAlly, possibleTargetsEnemy);
        if (!possibleTargetsAlly.isEmpty()) {
            this.wrapperSetAttackTarget(TargetUtil.getNearestEntity((EntityLiving)this.entity, possibleTargetsAlly));
        } else if (!possibleTargetsEnemy.isEmpty()) {
            this.wrapperSetAttackTarget(TargetUtil.getNearestEntity((EntityLiving)this.entity, possibleTargetsEnemy));
        }
    }

    protected void fillLists(List<EntityLivingBase> list, List<EntityLivingBase> allies, List<EntityLivingBase> enemies) {
        boolean canTargetAlly = this.canTargetAlly();
        for (EntityLivingBase possibleTarget : list) {
            if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)possibleTarget) || !EntitySelectors.field_94557_a.apply((Object)possibleTarget) || possibleTarget == this.entity) continue;
            if (canTargetAlly && this.isSuitableTargetAlly(possibleTarget)) {
                allies.add(possibleTarget);
                continue;
            }
            if (!this.isSuitableTargetEnemy(possibleTarget)) continue;
            enemies.add(possibleTarget);
        }
    }

    protected boolean canTargetAlly() {
        Item item = this.entity.func_184614_ca().func_77973_b();
        return item instanceof ISupportWeapon || item instanceof IFakeWeapon;
    }

    protected boolean isSuitableTargetAlly(EntityLivingBase possibleTarget) {
        Faction faction = this.entity.getFaction();
        if (faction == null) {
            return false;
        }
        if (!TargetUtil.isAllyCheckingLeaders((EntityLivingBase)this.entity, possibleTarget)) {
            return false;
        }
        if (possibleTarget.func_110143_aJ() >= possibleTarget.func_110138_aP()) {
            return false;
        }
        if (!this.entity.isInSightRange((Entity)possibleTarget)) {
            return false;
        }
        return this.entity.func_70635_at().func_75522_a((Entity)possibleTarget);
    }

    protected boolean isSuitableTargetEnemy(EntityLivingBase possibleTarget) {
        if (!TargetUtil.isEnemyCheckingLeaders((EntityLivingBase)this.entity, possibleTarget)) {
            return false;
        }
        if (!this.entity.func_70635_at().func_75522_a((Entity)possibleTarget)) {
            return false;
        }
        if (this.entity.isInAttackReach(possibleTarget)) {
            return true;
        }
        if (this.entity.isEntityInFieldOfView(possibleTarget)) {
            return this.entity.isInSightRange((Entity)possibleTarget);
        }
        return !possibleTarget.func_70093_af() && this.entity.func_70068_e((Entity)possibleTarget) < 144.0;
    }

    protected boolean isStillSuitableTarget(EntityLivingBase possibleTarget) {
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)possibleTarget)) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply((Object)possibleTarget)) {
            return false;
        }
        if (possibleTarget == this.entity) {
            return false;
        }
        if (this.entity.func_70068_e((Entity)possibleTarget) > 4096.0) {
            return false;
        }
        if (TargetUtil.isAllyCheckingLeaders((EntityLivingBase)this.entity, possibleTarget)) {
            if (!this.canTargetAlly()) {
                return false;
            }
            if (possibleTarget.func_110143_aJ() >= possibleTarget.func_110138_aP()) {
                return false;
            }
        } else if (this.canTargetAlly()) {
            AxisAlignedBB aabb = this.entity.func_174813_aQ().func_186662_g(32.0);
            List possibleTargets = this.world.func_72872_a(EntityLivingBase.class, aabb);
            for (EntityLivingBase possibleTargetAlly : possibleTargets) {
                if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)possibleTargetAlly) || !EntitySelectors.field_94557_a.apply((Object)possibleTargetAlly) || possibleTargetAlly == this.entity || !this.isSuitableTargetAlly(possibleTargetAlly)) continue;
                return false;
            }
        }
        return true;
    }
}

