/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.target;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.item.IFakeWeapon;
import team.cqr.cqrepoured.item.ISupportWeapon;

public class EntityAIHurtByTarget
extends AbstractCQREntityAI<AbstractEntityCQR> {
    private static final double MAX_PATH_END_TO_TARGET_DISTANCE_SQ = 2.0;
    private static final int MAX_PATH_LENGTH = 20;
    private static final double MAX_PATH_COMPLEXITY = 4.0;
    protected EntityLivingBase attackTarget;
    protected int prevRevengeTimer;

    public EntityAIHurtByTarget(AbstractEntityCQR entity) {
        super(entity);
    }

    public boolean func_75250_a() {
        if (this.world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (this.entity.func_142015_aE() == this.prevRevengeTimer) {
            return false;
        }
        EntityLivingBase revengeTarget = this.entity.func_70643_av();
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)revengeTarget)) {
            return false;
        }
        if (!revengeTarget.func_70089_S()) {
            return false;
        }
        Faction faction = this.entity.getFaction();
        if (faction == null) {
            return false;
        }
        if (!EntityAIHurtByTarget.isEnemyCheckingLeadersWhenAttacked(this.entity, revengeTarget)) {
            return false;
        }
        if (!this.entity.isInSightRange((Entity)revengeTarget)) {
            return false;
        }
        this.attackTarget = revengeTarget;
        return true;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        this.prevRevengeTimer = this.entity.func_142015_aE();
        this.trySetAttackTarget(this.entity);
        Faction faction = this.entity.getFaction();
        if (faction != null && faction.isEnemy((Entity)this.attackTarget) && !(this.entity.getLeader() instanceof EntityPlayer)) {
            this.callForHelp();
        }
    }

    protected void callForHelp() {
        double x = this.entity.field_70165_t;
        double y = this.entity.field_70163_u + (double)this.entity.func_70047_e();
        double z = this.entity.field_70161_v;
        double r = CQRConfig.mobs.alertRadius;
        AxisAlignedBB aabb = new AxisAlignedBB(x - r, y - r * 0.5, z - r, x + r, y + r * 0.5, z + r);
        List allies = this.world.func_175647_a(AbstractEntityCQR.class, aabb, this::isSuitableAlly);
        for (AbstractEntityCQR ally : allies) {
            this.trySetAttackTarget(ally);
        }
    }

    protected boolean isSuitableAlly(AbstractEntityCQR possibleAlly) {
        if (!EntitySelectors.field_94557_a.apply((Object)possibleAlly)) {
            return false;
        }
        if (possibleAlly == this.entity) {
            return false;
        }
        if (!EntityAIHurtByTarget.isAllyCheckingLeadersWhenAttacked(this.entity, (EntityLivingBase)possibleAlly)) {
            return false;
        }
        Path path = possibleAlly.func_70661_as().func_75494_a((Entity)this.entity);
        if (path == null) {
            return false;
        }
        PathPoint end = path.func_75870_c();
        if (end == null) {
            return false;
        }
        if (this.entity.func_70092_e(end.field_75839_a, end.field_75837_b, end.field_75838_c) > 2.0) {
            return false;
        }
        if (path.func_75874_d() > 20) {
            return false;
        }
        return (double)EntityAIHurtByTarget.getPathComplexity(path) <= 4.0;
    }

    protected boolean trySetAttackTarget(AbstractEntityCQR ally) {
        ItemStack stack = ally.func_184614_ca();
        if (stack.func_77973_b() instanceof ISupportWeapon) {
            return false;
        }
        if (stack.func_77973_b() instanceof IFakeWeapon) {
            return false;
        }
        if (!EntityAIHurtByTarget.isEnemyCheckingLeadersWhenAttacked(ally, this.attackTarget)) {
            return false;
        }
        EntityLivingBase oldAttackTarget = ally.func_70638_az();
        if (oldAttackTarget != null && ally.func_70635_at().func_75522_a((Entity)oldAttackTarget) && ally.func_70068_e((Entity)oldAttackTarget) < ally.func_70068_e((Entity)this.attackTarget)) {
            return false;
        }
        ally.func_70624_b(this.attackTarget);
        return true;
    }

    private static boolean isAllyCheckingLeadersWhenAttacked(AbstractEntityCQR entity, EntityLivingBase possibleAlly) {
        EntityLivingBase leader = TargetUtil.getLeaderOrOwnerRecursive((EntityLivingBase)entity);
        EntityLivingBase targetLeader = TargetUtil.getLeaderOrOwnerRecursive(possibleAlly);
        if (!(leader instanceof EntityPlayer) && targetLeader instanceof EntityPlayer) {
            return false;
        }
        return TargetUtil.isAllyCheckingLeaders(leader, targetLeader);
    }

    private static boolean isEnemyCheckingLeadersWhenAttacked(AbstractEntityCQR entity, EntityLivingBase possibleEnemy) {
        EntityLivingBase leader = TargetUtil.getLeaderOrOwnerRecursive((EntityLivingBase)entity);
        if (!(leader instanceof EntityPlayer)) {
            return !TargetUtil.isAllyCheckingLeaders(leader, possibleEnemy);
        }
        return TargetUtil.isEnemyCheckingLeaders(leader, possibleEnemy);
    }

    private static int getPathComplexity(Path path) {
        if (path.func_75874_d() == 0) {
            return 0;
        }
        int pathComplexity = 0;
        EnumFacing.Axis prevPrevPrevAxis = null;
        EnumFacing.Axis prevPrevAxis = null;
        EnumFacing.Axis prevAxis = null;
        int prevX = path.func_75877_a((int)0).field_75839_a;
        int prevZ = path.func_75877_a((int)0).field_75838_c;
        for (int i = 0; i < path.func_75874_d(); ++i) {
            PathPoint point = path.func_75877_a(i);
            int x = point.field_75839_a;
            int z = point.field_75838_c;
            EnumFacing.Axis axis = x != prevX ? EnumFacing.Axis.X : (z != prevZ ? EnumFacing.Axis.Z : EnumFacing.Axis.Y);
            if (prevAxis == axis && prevAxis != prevPrevAxis && prevPrevAxis == prevPrevPrevAxis) {
                ++pathComplexity;
            }
            prevPrevPrevAxis = prevPrevAxis;
            prevPrevAxis = prevAxis;
            prevAxis = axis;
            prevX = x;
            prevZ = z;
        }
        return pathComplexity;
    }
}

