/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.network.server.packet.SPacketSyncLaserRotation;
import team.cqr.cqrepoured.util.math.BoundingBox;

public abstract class AbstractEntityLaser
extends Entity
implements IEntityAdditionalSpawnData {
    public EntityLivingBase caster;
    public float length;
    public float rotationYawCQR;
    public float rotationPitchCQR;
    public float prevRotationYawCQR;
    public float prevRotationPitchCQR;
    public float serverRotationYawCQR;
    public float serverRotationPitchCQR;
    private final Object2IntMap<EntityLivingBase> hitInfoMap = new Object2IntOpenHashMap();
    private final Map<BlockPos, BreakingInfo> blockBreakMap = new HashMap<BlockPos, BreakingInfo>();

    protected AbstractEntityLaser(World worldIn) {
        this(worldIn, null, 4.0f);
    }

    protected AbstractEntityLaser(World worldIn, EntityLivingBase caster, float length) {
        super(worldIn);
        this.caster = caster;
        this.length = length;
        this.field_70158_ak = true;
        this.field_70145_X = true;
        this.func_70105_a(0.1f, 0.1f);
    }

    public Vec3d getOffsetVector() {
        if (this.caster == null) {
            return Vec3d.field_186680_a;
        }
        Vec3d v = new Vec3d(0.0, (double)this.caster.field_70131_O * 0.6, 0.0);
        v = v.func_178787_e(this.caster.func_70040_Z().func_186678_a(0.25));
        return v;
    }

    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public boolean func_184198_c(NBTTagCompound compound) {
        return false;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        return compound;
    }

    public double laserEffectRadius() {
        return 0.25;
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && !this.caster.func_70089_S()) {
            this.func_70106_y();
        }
        super.func_70030_z();
        this.prevRotationYawCQR = this.rotationYawCQR;
        this.prevRotationPitchCQR = this.rotationPitchCQR;
        if (this.field_70170_p.field_72995_K) {
            this.rotationYawCQR = this.serverRotationYawCQR;
            this.rotationPitchCQR = this.serverRotationPitchCQR;
        } else {
            this.updatePositionAndRotation();
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketSyncLaserRotation(this), (Entity)this);
        }
        if (!this.field_70170_p.field_72995_K) {
            BreakingInfo breakingInfo;
            float breakProgress;
            IBlockState state;
            BlockPos pos;
            double d;
            Vec3d end;
            Vec3d start = this.func_174791_d();
            RayTraceResult result = this.field_70170_p.func_147447_a(start, end = start.func_178787_e(Vec3d.func_189986_a((float)this.rotationPitchCQR, (float)this.rotationYawCQR).func_186678_a((double)this.length)), false, false, false);
            double d2 = d = result != null ? (double)((float)result.field_72307_f.func_178788_d(this.func_174791_d()).func_72433_c()) : (double)this.length;
            if (result != null && this.canHitBlock(pos = result.func_178782_a(), state = this.field_70170_p.func_180495_p(pos)) && (breakProgress = this.onHitBlock(pos, state)) > 0.0f) {
                if (breakProgress >= 1.0f) {
                    this.field_70170_p.func_175698_g(pos);
                } else {
                    breakingInfo = this.blockBreakMap.computeIfAbsent(pos, key -> new BreakingInfo());
                    breakingInfo.lastTimeHit = this.field_70173_aa;
                    BreakingInfo breakingInfo2 = breakingInfo;
                    breakingInfo2.progress = breakingInfo2.progress + breakProgress;
                    if (breakingInfo.progress >= 1.0f) {
                        this.field_70170_p.func_175698_g(pos);
                        this.blockBreakMap.remove(pos);
                        int i = 0x1000000 + this.func_145782_y() * 256 + breakingInfo.id;
                        this.field_70170_p.func_175715_c(i, pos, -1);
                    }
                }
            }
            Iterator<Map.Entry<BlockPos, BreakingInfo>> iterator = this.blockBreakMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, BreakingInfo> entry = iterator.next();
                BreakingInfo breakingInfo3 = entry.getValue();
                if (this.field_70173_aa - breakingInfo3.lastTimeHit >= this.blockBreakThreshhold()) {
                    breakingInfo = breakingInfo3;
                    breakingInfo.progress = breakingInfo.progress - this.blockBreakRevert();
                }
                int i = 0x1000000 + this.func_145782_y() * 256 + breakingInfo3.id;
                if (breakingInfo3.progress <= 0.0f) {
                    iterator.remove();
                    this.field_70170_p.func_175715_c(i, entry.getKey(), -1);
                    continue;
                }
                this.field_70170_p.func_175715_c(i, entry.getKey(), (int)(breakingInfo3.progress * 10.0f));
            }
            Vec3d vec1 = new Vec3d(-this.laserEffectRadius(), -this.laserEffectRadius(), 0.0);
            Vec3d vec2 = new Vec3d(this.laserEffectRadius(), this.laserEffectRadius(), d);
            BoundingBox bb = new BoundingBox(vec1, vec2, Math.toRadians(this.rotationYawCQR), Math.toRadians(this.rotationPitchCQR), start);
            for (EntityLivingBase entity : BoundingBox.getEntitiesInsideBB(this.field_70170_p, this.caster, EntityLivingBase.class, bb)) {
                if (!this.canHitEntity(entity) || this.field_70173_aa - this.hitInfoMap.getInt((Object)entity) < this.getEntityHitRate()) continue;
                this.onEntityHit(entity);
                this.hitInfoMap.put((Object)entity, this.field_70173_aa);
            }
        }
    }

    public boolean canHitBlock(BlockPos pos, IBlockState state) {
        return true;
    }

    public float onHitBlock(BlockPos pos, IBlockState state) {
        float hardness = state.func_185887_b(this.field_70170_p, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (hardness == 0.0f) {
            return 1.0f;
        }
        int ticks = hardness <= 2.0f ? 40 + MathHelper.func_76123_f((float)(hardness * 20.0f)) : MathHelper.func_76123_f((float)(20.0f * (8.0f * hardness) / (hardness + 2.0f)));
        return 1.0f / (float)ticks + 1.0E-7f;
    }

    public int blockBreakThreshhold() {
        return 60;
    }

    public float blockBreakRevert() {
        return 0.02f;
    }

    public int getEntityHitRate() {
        return 10;
    }

    public boolean canHitEntity(EntityLivingBase entity) {
        return !TargetUtil.isAllyCheckingLeaders(this.caster, entity);
    }

    public void onEntityHit(EntityLivingBase entity) {
        entity.func_70097_a(new DamageSource("ray").func_76348_h(), this.getDamage());
    }

    public boolean canBreakBlocks() {
        return false;
    }

    public int getBreakingSpeed() {
        return 1;
    }

    public float getDamage() {
        return 3.0f;
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K) {
            for (Map.Entry<BlockPos, BreakingInfo> entry : this.blockBreakMap.entrySet()) {
                int i = 0x1000000 + this.func_145782_y() * 256 + entry.getValue().id;
                this.field_70170_p.func_175715_c(i, entry.getKey(), -1);
            }
        }
    }

    public abstract void setupPositionAndRotation();

    public abstract void updatePositionAndRotation();

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.caster.func_145782_y());
        buffer.writeFloat(this.length);
        buffer.writeFloat(this.rotationYawCQR);
        buffer.writeFloat(this.rotationPitchCQR);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.caster = (EntityLivingBase)this.field_70170_p.func_73045_a(additionalData.readInt());
        this.length = additionalData.readFloat();
        this.rotationYawCQR = additionalData.readFloat();
        this.rotationPitchCQR = additionalData.readFloat();
        this.prevRotationYawCQR = this.rotationYawCQR;
        this.prevRotationPitchCQR = this.rotationPitchCQR;
    }

    public float getColorR() {
        return 0.1f;
    }

    public float getColorG() {
        return 0.7f;
    }

    public float getColorB() {
        return 0.9f;
    }

    private static class BreakingInfo {
        private static int counter;
        private int lastTimeHit;
        private float progress;
        private int id = counter++ % 256;

        private BreakingInfo() {
        }
    }
}

