/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss;

import java.util.Random;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.Capes;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.ai.boss.walkerking.BossAIWalkerLightningCircles;
import team.cqr.cqrepoured.entity.ai.boss.walkerking.BossAIWalkerLightningSpiral;
import team.cqr.cqrepoured.entity.ai.boss.walkerking.BossAIWalkerTornadoAttack;
import team.cqr.cqrepoured.entity.ai.boss.walkerking.EntityAIWalkerIllusions;
import team.cqr.cqrepoured.entity.ai.spells.EntityAIAntiAirSpellWalker;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.entity.misc.EntityColoredLightningBolt;
import team.cqr.cqrepoured.entity.misc.EntityIceSpike;
import team.cqr.cqrepoured.entity.misc.EntityWalkerKingIllusion;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.faction.FactionRegistry;
import team.cqr.cqrepoured.init.CQRCreatureAttributes;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.item.armor.ItemArmorDyable;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityCQRWalkerKing
extends AbstractEntityCQRBoss {
    private int lightningTick = 0;
    private int borderLightning = 20;
    private boolean active = false;
    private int activationCooldown = 80;
    private int dragonAttackCooldown = 0;
    private int lavaCounterAttackCooldown = 0;

    public EntityCQRWalkerKing(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 200;
    }

    @Override
    public void enableBossBar() {
        super.enableBossBar();
        if (this.bossInfoServer != null) {
            this.bossInfoServer.func_186745_a(BossInfo.Color.PURPLE);
            this.bossInfoServer.func_186743_c(CQRConfig.bosses.enableWalkerKingFog);
            this.bossInfoServer.func_186741_a(CQRConfig.bosses.enableWalkerKingFog);
            this.bossInfoServer.func_186742_b(true);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.spellHandler.addSpell(0, new EntityAIAntiAirSpellWalker(this));
        this.spellHandler.addSpell(1, new EntityAIWalkerIllusions(this, 600, 40));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new BossAIWalkerTornadoAttack(this));
        this.field_70714_bg.func_75776_a(16, (EntityAIBase)new BossAIWalkerLightningCircles(this));
        this.field_70714_bg.func_75776_a(17, (EntityAIBase)new BossAIWalkerLightningSpiral(this));
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void func_70636_d() {
        if (this.dragonAttackCooldown > 0) {
            --this.dragonAttackCooldown;
        }
        if (this.field_70143_R > 12.0f) {
            boolean teleport;
            BlockPos teleportPos = null;
            boolean bl = teleport = this.func_70638_az() != null || this.getHomePositionCQR() != null;
            if (this.func_70638_az() != null && !this.field_70170_p.field_72995_K) {
                Vec3d v = this.func_70638_az().func_70040_Z();
                v = v.func_72432_b();
                v = v.func_178786_a(0.0, v.field_72448_b, 0.0);
                v = v.func_186678_a(3.0);
                teleportPos = new BlockPos(this.func_70638_az().func_174791_d().func_178788_d(v));
                if (this.field_70170_p.func_175665_u(teleportPos) || this.field_70170_p.func_175665_u(teleportPos.func_177972_a(EnumFacing.UP)) || this.field_70170_p.func_175623_d(teleportPos.func_177972_a(EnumFacing.DOWN))) {
                    teleportPos = this.func_70638_az().func_180425_c();
                }
            } else if (this.getHomePositionCQR() != null && !this.field_70170_p.field_72995_K) {
                teleportPos = this.getHomePositionCQR();
            }
            if (teleport) {
                for (int ix = -1; ix <= 1; ++ix) {
                    for (int iz = -1; iz <= 1; ++iz) {
                        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)ix, this.field_70163_u + 2.0, this.field_70161_v + (double)iz, 10, 0.0, 0.0, 0.0, 0.25, new int[]{0, 0, 0});
                    }
                }
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, true);
                this.func_184595_k(teleportPos.func_177958_n(), teleportPos.func_177956_o(), teleportPos.func_177952_p());
            }
        }
        if (this.active && !this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null) {
                --this.activationCooldown;
                if (this.activationCooldown < 0) {
                    this.active = false;
                    this.field_70170_p.func_72912_H().func_76069_a(false);
                    this.activationCooldown = 80;
                }
            } else {
                this.field_70170_p.func_72912_H().func_176142_i(0);
                this.field_70170_p.func_72912_H().func_76080_g(400);
                this.field_70170_p.func_72912_H().func_76090_f(200);
                this.field_70170_p.func_72912_H().func_76084_b(true);
                this.field_70170_p.func_72912_H().func_76069_a(true);
            }
            ++this.lightningTick;
            if (this.lightningTick > this.borderLightning) {
                this.lightningTick = 0;
                this.borderLightning = 50;
                int x = -20 + this.func_70681_au().nextInt(41);
                int z = -20 + this.func_70681_au().nextInt(41);
                int y = -10 + this.func_70681_au().nextInt(21);
                EntityColoredLightningBolt entitybolt = new EntityColoredLightningBolt(this.field_70170_p, this.field_70165_t + (double)x, this.field_70163_u + (double)y, this.field_70161_v + (double)z, true, false, 0.34f, 0.08f, 0.43f, 0.4f);
                this.field_70170_p.func_72838_d((Entity)entitybolt);
            }
            if (this.func_180799_ab() && this.hasAttackTarget() && this.lavaCounterAttackCooldown <= 0) {
                this.teleportBehindEntity((Entity)this.func_70638_az());
                this.func_70652_k((Entity)this.func_70638_az());
                this.lavaCounterAttackCooldown = 20;
            }
            if (this.lavaCounterAttackCooldown > 0) {
                --this.lavaCounterAttackCooldown;
            }
            if (this.field_70134_J || this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockWeb) {
                this.handleInWeb();
            }
        } else if (this.field_70170_p.field_72995_K) {
            this.active = false;
        }
        super.func_70636_d();
    }

    private void handleInWeb() {
        if (this.hasAttackTarget()) {
            this.field_70170_p.func_175698_g(this.func_180425_c());
            EntityWalkerKingIllusion illusion = new EntityWalkerKingIllusion(1200, this, this.func_130014_f_());
            illusion.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)illusion);
            this.teleportBehindEntity((Entity)this.func_70638_az());
            this.func_70652_k((Entity)this.func_70638_az());
        }
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        this.func_70691_i(1.0f);
    }

    private void backStabAttacker(DamageSource source) {
        if (source.func_76346_g() != null && this.teleportBehindEntity(source.func_76346_g())) {
            this.func_70652_k(source.func_76346_g());
        }
    }

    private boolean teleportBehindEntity(Entity entity) {
        return this.teleportBehindEntity(entity, false);
    }

    private boolean teleportBehindEntity(Entity entity, boolean force) {
        Vec3d p = entity.func_174791_d().func_178788_d(entity.func_70040_Z().func_186678_a(2.0 + (double)entity.field_70130_N * 0.5));
        if (this.func_70661_as().func_188555_b(new BlockPos(p.field_72450_a, p.field_72448_b, p.field_72449_c))) {
            for (int ix = -1; ix <= 1; ++ix) {
                for (int iz = -1; iz <= 1; ++iz) {
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)ix, this.field_70163_u + 2.0, this.field_70161_v + (double)iz, 10, 0.0, 0.0, 0.0, 0.25, new int[]{0, 0, 0});
                }
            }
            this.func_184185_a(CQRSounds.WALKER_KING_LAUGH, 10.0f, 1.0f);
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, true);
            if (force) {
                this.teleport(p.field_72450_a, p.field_72448_b, p.field_72449_c);
                return true;
            }
            return this.func_184595_k(p.field_72450_a, p.field_72448_b, p.field_72449_c);
        }
        return false;
    }

    private void handleAttackedByDragon(Entity dragon) {
        if (CQRConfig.advanced.enableSpecialFeatures && dragon.func_184179_bs() != null && dragon instanceof EntityLiving && dragon.func_184179_bs() instanceof EntityLivingBase) {
            dragon.func_184179_bs().func_184210_p();
        }
        this.func_184185_a(CQRSounds.WALKER_KING_LAUGH, 10.0f, 1.0f);
        int lightningCount = 6 + this.func_70681_au().nextInt(3);
        double angle = 360 / lightningCount;
        double dragonSize = dragon.field_70130_N > dragon.field_70131_O ? (double)dragon.field_70130_N : (double)dragon.field_70131_O;
        Vec3d v = new Vec3d(3.0 + 3.0 * dragonSize, 0.0, 0.0);
        for (int i = 0; i < lightningCount; ++i) {
            Vec3d p = VectorUtil.rotateVectorAroundY(v, (double)i * angle);
            int dY = -3 + this.func_70681_au().nextInt(7);
            EntityColoredLightningBolt clb = new EntityColoredLightningBolt(this.field_70170_p, dragon.field_70165_t + p.field_72450_a, dragon.field_70163_u + (double)dY, dragon.field_70161_v + p.field_72449_c, false, false, 1.0f, 0.0f, 0.0f, 0.4f);
            this.field_70170_p.func_72838_d((Entity)clb);
        }
        dragon.func_70097_a(DamageSource.field_76376_m, 10.0f);
    }

    private void handleActivation() {
        if (!this.field_70170_p.field_72995_K && !this.field_70170_p.func_72912_H().func_76061_m()) {
            this.func_184185_a(CQRSounds.WALKER_KING_LAUGH, 10.0f, 1.0f);
            this.active = true;
            this.activationCooldown = 80;
            this.field_70170_p.func_72912_H().func_176142_i(0);
            this.field_70170_p.func_72912_H().func_76080_g(400);
            this.field_70170_p.func_72912_H().func_76090_f(200);
            this.field_70170_p.func_72912_H().func_76084_b(true);
            this.field_70170_p.func_72912_H().func_76069_a(true);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        ResourceLocation resLoc;
        if (source == DamageSource.field_82727_n) {
            this.func_70691_i(amount / 2.0f);
            return true;
        }
        if (source == DamageSource.field_76379_h) {
            return true;
        }
        if (source == DamageSource.field_76368_d && this.hasAttackTarget() && this.func_70613_aW()) {
            EntityWalkerKingIllusion illusion = new EntityWalkerKingIllusion(1200, this, this.func_130014_f_());
            illusion.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)illusion);
            this.teleportBehindEntity((Entity)this.func_70638_az(), true);
            this.func_70652_k((Entity)this.func_70638_az());
            return false;
        }
        if (!(source.func_76364_f() != null && source.func_76364_f() instanceof EntitySpectralArrow || CQRConfig.bosses.armorForTheWalkerKing)) {
            amount *= 0.5f;
        }
        if (source.func_76364_f() != null) {
            if (source.func_76364_f() instanceof EntitySpectralArrow) {
                super.func_70097_a(source, amount *= 2.0f);
                return true;
            }
            if ((source.func_76364_f() instanceof EntityThrowable || source.func_76364_f() instanceof EntityArrow) && !this.field_70170_p.field_72995_K) {
                this.backStabAttacker(source);
                return false;
            }
        }
        this.handleActivation();
        if (source.func_76346_g() != null && !this.field_70170_p.field_72995_K && (resLoc = EntityList.func_191301_a((Entity)source.func_76346_g())) != null) {
            Faction fac;
            boolean dragonFactionFlag;
            boolean flag;
            boolean bl = flag = resLoc.func_110624_b().equalsIgnoreCase("iceandfire") && CQRConfig.advanced.enableSpecialFeatures;
            if (flag) {
                amount /= 2.0f;
            }
            boolean bl2 = dragonFactionFlag = (fac = FactionRegistry.instance((Entity)this).getFactionOf(source.func_76346_g())) != null && (fac.getName().equalsIgnoreCase("DRAGON") || fac.getName().equalsIgnoreCase("DRAGONS"));
            if (this.dragonAttackCooldown <= 0 && (dragonFactionFlag || resLoc.func_110623_a().contains("dragon") || resLoc.func_110623_a().contains("wyrm") || resLoc.func_110623_a().contains("wyvern") || flag)) {
                this.dragonAttackCooldown = 80;
                this.handleAttackedByDragon(source.func_76346_g());
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack shieldStack = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
            if (amount > 0.0f && this.func_184583_d(source) && shieldStack != null && !shieldStack.func_190926_b() && shieldStack.func_77973_b() instanceof ItemShield) {
                this.func_184185_a(CQRSounds.WALKER_KING_LAUGH, 10.0f, 1.0f);
                if (source.func_76364_f() instanceof EntityLivingBase && ((EntityLivingBase)source.func_76364_f()).func_184614_ca().func_77973_b() instanceof ItemAxe && DungeonGenUtils.percentageRandom(0.75, this.func_70681_au())) {
                    Vec3d v = source.func_76364_f().func_174791_d().func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(1.25);
                    v = v.func_72441_c(0.0, 0.75, 0.0);
                    EntityLivingBase attacker = (EntityLivingBase)source.func_76364_f();
                    attacker.field_70159_w = v.field_72450_a;
                    attacker.field_70181_x = v.field_72448_b;
                    attacker.field_70179_y = v.field_72449_c;
                    attacker.field_70133_I = true;
                    this.func_184609_a(EnumHand.OFF_HAND);
                    return false;
                }
            }
            if (this.func_70681_au().nextDouble() < 0.2 && source.func_76346_g() != null && this.func_70681_au().nextDouble() < 0.7) {
                this.func_70652_k(source.func_76346_g());
                this.func_184185_a(CQRSounds.WALKER_KING_LAUGH, 10.0f, 1.0f);
                this.teleportBehindEntity(source.func_76346_g());
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_184583_d(DamageSource damageSourceIn) {
        if (super.func_184583_d(damageSourceIn)) {
            if (this.func_70681_au().nextDouble() < 0.3) {
                return true;
            }
            if (this.func_70681_au().nextDouble() < 0.1) {
                this.counterAttack();
            }
        }
        return false;
    }

    private void counterAttack() {
        this.counterAttack((Entity)this.func_70638_az());
    }

    private void counterAttack(Entity entitylivingbase) {
        float f2;
        int k;
        double d0 = Math.min(entitylivingbase.field_70163_u, this.field_70163_u);
        double d1 = Math.max(entitylivingbase.field_70163_u, this.field_70163_u) + 1.0;
        float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - this.field_70161_v), (double)(entitylivingbase.field_70165_t - this.field_70165_t));
        for (int i = 0; i < 5; ++i) {
            float f1 = f + (float)i * (float)Math.PI * 0.4f;
            this.spawnFangs(this.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * 1.5, this.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * 1.5, d0, d1, f1, 0);
        }
        for (k = 0; k < 8; ++k) {
            f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
            this.spawnFangs(this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 2.5, this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 2.5, d0, d1, f2, 3);
        }
        for (k = 0; k < 11; ++k) {
            f2 = f + (float)k * (float)Math.PI * 2.0f / 11.0f + 1.2566371f;
            this.spawnFangs(this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 3.5, this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, d0, d1, f2, 6);
        }
    }

    private void spawnFangs(double x, double z, double minY, double maxY, float rotationYawRadians, int warmupDelayTicks) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            IBlockState iblockstate;
            AxisAlignedBB axisalignedbb;
            if (this.field_70170_p.func_175677_d(blockpos, true) || !this.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
            if (!this.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = this.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != null) {
                d0 = axisalignedbb.field_72337_e;
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
        if (flag) {
            EntityIceSpike entityevokerfangs = new EntityIceSpike(this.field_70170_p, x, (double)blockpos.func_177956_o() + d0, z, rotationYawRadians, warmupDelayTicks, (EntityLivingBase)this);
            this.field_70170_p.func_72838_d((Entity)entityevokerfangs);
        }
    }

    @Override
    public boolean hasCape() {
        return this.field_70725_aQ <= 0;
    }

    @Override
    public ResourceLocation getResourceLocationOfCape() {
        return Capes.CAPE_WALKER;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_WALKER_KING;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.AbyssWalkerKing;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.WALKERS;
    }

    protected SoundEvent func_184639_G() {
        return CQRSounds.WALKER_AMBIENT;
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        return CQRSounds.WALKER_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return CQRSounds.WALKER_KING_DEATH_EFFECT;
    }

    @Override
    protected SoundEvent getFinalDeathSound() {
        return CQRSounds.WALKER_KING_DEATH;
    }

    protected float func_70647_i() {
        return 0.75f * super.func_70647_i();
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getSword());
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(CQRItems.SHIELD_WALKER_KING, 1));
        this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, new ItemStack(CQRItems.POTION_HEALING, 3));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CQRItems.KING_CROWN, 1));
        if (CQRConfig.bosses.armorForTheWalkerKing) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
            if (!nbttagcompound.func_150297_b("display", 10)) {
                nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
            }
            nbttagcompound1.func_74768_a("color", 0x9000FF);
            ItemStack chest = new ItemStack(CQRItems.CHESTPLATE_DIAMOND_DYABLE, 1, 0, nbttagcompound);
            ((ItemArmorDyable)CQRItems.CHESTPLATE_DIAMOND_DYABLE).func_82813_b(chest, 0x9000FF);
            this.func_184201_a(EntityEquipmentSlot.CHEST, chest);
            ItemStack legs = new ItemStack(CQRItems.LEGGINGS_DIAMOND_DYABLE, 1, 0, nbttagcompound);
            ((ItemArmorDyable)CQRItems.LEGGINGS_DIAMOND_DYABLE).func_82813_b(legs, 0x9000FF);
            this.func_184201_a(EntityEquipmentSlot.LEGS, legs);
            ItemStack boobs = new ItemStack(CQRItems.BOOTS_DIAMOND_DYABLE, 1, 0, nbttagcompound);
            ((ItemArmorDyable)CQRItems.BOOTS_DIAMOND_DYABLE).func_82813_b(boobs, 0x9000FF);
            this.func_184201_a(EntityEquipmentSlot.FEET, boobs);
        }
    }

    private ItemStack getSword() {
        ItemStack sword = new ItemStack(CQRItems.SWORD_WALKER, 1);
        sword = EnchantmentHelper.func_77504_a((Random)this.func_70681_au(), (ItemStack)sword, (int)30, (boolean)true);
        if (!EnchantmentHelper.func_190939_c((ItemStack)sword)) {
            sword.func_77966_a(Enchantments.field_190940_C, 1);
        }
        return sword;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.field_70170_p.func_72912_H().func_76069_a(false);
        super.func_70645_a(cause);
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.field_70725_aQ > 150 && this.field_70725_aQ % 5 == 0) {
            this.dropExperience(MathHelper.func_76141_d((float)50.0f));
        }
    }

    @Override
    protected void onFinalDeath() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.dropExperience(MathHelper.func_76141_d((float)1200.0f));
        }
    }

    @Override
    protected boolean usesEnderDragonDeath() {
        return true;
    }

    @Override
    protected boolean doesExplodeOnDeath() {
        return false;
    }

    @Override
    protected EnumParticleTypes getDeathAnimParticles() {
        return EnumParticleTypes.EXPLOSION_HUGE;
    }

    protected int func_70693_a(EntityPlayer player) {
        return super.func_70693_a(player);
    }

    private void dropExperience(int p_184668_1_) {
        while (p_184668_1_ > 0) {
            int i = EntityXPOrb.func_70527_a((int)p_184668_1_);
            p_184668_1_ -= i;
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return CQRCreatureAttributes.VOID;
    }
}

