/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.exterminator;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.capability.electric.IDontSpreadElectrocution;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.IDontRenderFire;
import team.cqr.cqrepoured.entity.IMechanical;
import team.cqr.cqrepoured.entity.IServerAnimationReceiver;
import team.cqr.cqrepoured.entity.ISizable;
import team.cqr.cqrepoured.entity.MultiPartEntityPartSizable;
import team.cqr.cqrepoured.entity.ai.EntityAIFollowAttackTarget;
import team.cqr.cqrepoured.entity.ai.EntityAIFollowPath;
import team.cqr.cqrepoured.entity.ai.EntityAIIdleSit;
import team.cqr.cqrepoured.entity.ai.EntityAIMoveToHome;
import team.cqr.cqrepoured.entity.ai.EntityAIMoveToLeader;
import team.cqr.cqrepoured.entity.ai.EntityAIOpenCloseDoor;
import team.cqr.cqrepoured.entity.ai.EntityAITasksProfiled;
import team.cqr.cqrepoured.entity.ai.attack.EntityAIAttack;
import team.cqr.cqrepoured.entity.ai.attack.EntityAIAttackRanged;
import team.cqr.cqrepoured.entity.ai.attack.EntityAIBackstab;
import team.cqr.cqrepoured.entity.ai.attack.special.EntityAIAttackSpecial;
import team.cqr.cqrepoured.entity.ai.attack.special.EntityAIHooker;
import team.cqr.cqrepoured.entity.ai.attack.special.EntityAILooter;
import team.cqr.cqrepoured.entity.ai.boss.exterminator.BossAIArmCannon;
import team.cqr.cqrepoured.entity.ai.boss.exterminator.BossAIExterminatorHandLaser;
import team.cqr.cqrepoured.entity.ai.boss.exterminator.BossAIExterminatorHulkSmash;
import team.cqr.cqrepoured.entity.ai.boss.exterminator.BossAIExterminatorStun;
import team.cqr.cqrepoured.entity.ai.item.EntityAICursedBoneSummoner;
import team.cqr.cqrepoured.entity.ai.item.EntityAIFireball;
import team.cqr.cqrepoured.entity.ai.item.EntityAIPotionThrower;
import team.cqr.cqrepoured.entity.ai.target.EntityAICQRNearestAttackTarget;
import team.cqr.cqrepoured.entity.ai.target.EntityAIHurtByTarget;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.ai.target.exterminator.EntityAITargetElectrocute;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.entity.boss.exterminator.SubEntityExterminatorBackpack;
import team.cqr.cqrepoured.entity.boss.exterminator.SubEntityExterminatorFieldEmitter;
import team.cqr.cqrepoured.entity.projectiles.ProjectileCannonBall;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.init.CQRMaterials;
import team.cqr.cqrepoured.item.staff.ItemStaffHealing;
import team.cqr.cqrepoured.network.server.packet.exterminator.SPacketUpdateEmitterTarget;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityCQRExterminator
extends AbstractEntityCQRBoss
implements IDontSpreadElectrocution,
IMechanical,
IDontRenderFire,
IEntityMultiPart,
IAnimatable,
IServerAnimationReceiver,
IAnimationTickable {
    private MultiPartEntityPart[] parts;
    private EntityLivingBase electroCuteTargetEmitterLeft;
    private EntityLivingBase electroCuteTargetEmitterRight;
    private int stunTime = 0;
    protected static final DataParameter<Boolean> IS_STUNNED = EntityDataManager.func_187226_a(EntityCQRExterminator.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> ARMS_BLOCKED_BY_LONG_ANIMATION = EntityDataManager.func_187226_a(EntityCQRExterminator.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> PUNCH_IS_KICK = EntityDataManager.func_187226_a(EntityCQRExterminator.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> CANNON_RAISED = EntityDataManager.func_187226_a(EntityCQRExterminator.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> EMITTER_LEFT_ACTIVE = EntityDataManager.func_187226_a(EntityCQRExterminator.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> EMITTER_RIGHT_ACTIVE = EntityDataManager.func_187226_a(EntityCQRExterminator.class, (DataSerializer)DataSerializers.field_187198_h);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean partSoundFlag;
    private static final String ANIM_NAME_PREFIX = "animation.exterminator.";
    public static final String ANIM_NAME_SPIN_COILS = "animation.exterminator.spin_tesla_coils";
    public static final String ANIM_NAME_INACTIVE = "animation.exterminator.inactive";
    public static final String ANIM_NAME_DEATH = "animation.exterminator.death";
    public static final String ANIM_NAME_STUN = "animation.exterminator.stun";
    public static final String ANIM_NAME_CANNON_RAISED = "animation.exterminator.raised_cannon";
    public static final String ANIM_NAME_CANNON_LOWERED = "animation.exterminator.lowered_cannon";
    public static final String ANIM_NAME_CANNON_SHOOT = "animation.exterminator.shoot_cannon";
    public static final String ANIM_NAME_THROW = "animation.exterminator.throw";
    public static final String ANIM_NAME_GROUND_SMASH = "animation.exterminator.ground_slam";
    @SideOnly(value=Side.CLIENT)
    private boolean shootIndicator;
    @SideOnly(value=Side.CLIENT)
    private boolean throwIndicator;
    @SideOnly(value=Side.CLIENT)
    private boolean smashIndicator;
    public static final String ANIM_NAME_PUNCH = "animation.exterminator.punch";
    public static final String ANIM_NAME_KICK = "animation.exterminator.kick";
    public static final int ARMS_THROW_DURATION = 14;
    public static final int GROUND_SLAM_DURATION = 60;
    private int animationTimer = -1;
    private String currentAnimationPlaying;
    private DamageSource deathCause = null;
    private static final int CANNON_RAISE_OR_LOWER_DURATION = 40;
    private static final int CANNON_SHOOT_DURATION = 12;
    private int cannonArmTimer = 0;
    private int cannonTimeOut = 0;
    @SideOnly(value=Side.CLIENT)
    private boolean kickInProgressClient;

    public EntityCQRExterminator(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 100;
        this.parts = new MultiPartEntityPart[5];
        this.parts[0] = new SubEntityExterminatorBackpack(this, "exterminator_backpack", this::isAnyEmitterActive);
        this.parts[1] = new SubEntityExterminatorFieldEmitter(this, "emitter_left", this::getElectroCuteTargetLeft, this::isEmitterLeftActive, this::setEmitterLeftActive);
        this.parts[2] = new SubEntityExterminatorFieldEmitter(this, "emitter_right", this::getElectroCuteTargetRight, this::isEmitterRightActive, this::setEmitterRightActive);
        this.parts[3] = new MultiPartEntityPartSizable<EntityCQRExterminator>(this, "main_hitbox_left", this.getDefaultWidth() / 3.0f, this.getDefaultHeight()){

            public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
                if (this.field_70259_a == null || ((EntityLivingBase)this.field_70259_a).field_70128_L) {
                    return false;
                }
                return ((EntityLivingBase)this.field_70259_a).func_184230_a(player, hand);
            }
        };
        this.parts[4] = new MultiPartEntityPartSizable<EntityCQRExterminator>(this, "main_hitbox_right", this.getDefaultWidth() / 3.0f, this.getDefaultHeight()){

            public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
                if (this.field_70259_a == null || ((EntityLivingBase)this.field_70259_a).field_70128_L) {
                    return false;
                }
                return ((EntityLivingBase)this.field_70259_a).func_184230_a(player, hand);
            }
        };
    }

    protected boolean isAnyEmitterActive() {
        try {
            return this.getEmitterLeft().isActive() || this.getEmitterRight().isActive();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    @Nullable
    private SubEntityExterminatorFieldEmitter getEmitterLeft() {
        return (SubEntityExterminatorFieldEmitter)this.parts[1];
    }

    @Nullable
    private SubEntityExterminatorFieldEmitter getEmitterRight() {
        return (SubEntityExterminatorFieldEmitter)this.parts[2];
    }

    protected boolean isEmitterLeftActive() {
        return (Boolean)this.field_70180_af.func_187225_a(EMITTER_LEFT_ACTIVE);
    }

    protected void setEmitterLeftActive(boolean value) {
        this.field_70180_af.func_187227_b(EMITTER_LEFT_ACTIVE, (Object)value);
    }

    protected boolean isEmitterRightActive() {
        return (Boolean)this.field_70180_af.func_187225_a(EMITTER_RIGHT_ACTIVE);
    }

    protected void setEmitterRightActive(boolean value) {
        this.field_70180_af.func_187227_b(EMITTER_RIGHT_ACTIVE, (Object)value);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STUNNED, (Object)false);
        this.field_70180_af.func_187214_a(CANNON_RAISED, (Object)false);
        this.field_70180_af.func_187214_a(PUNCH_IS_KICK, (Object)false);
        this.field_70180_af.func_187214_a(ARMS_BLOCKED_BY_LONG_ANIMATION, (Object)false);
        this.field_70180_af.func_187214_a(EMITTER_LEFT_ACTIVE, (Object)false);
        this.field_70180_af.func_187214_a(EMITTER_RIGHT_ACTIVE, (Object)false);
    }

    protected void func_82167_n(Entity entityIn) {
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)CQRMaterials.ArmorMaterials.ARMOR_HEAVY_IRON.func_78044_b(EntityEquipmentSlot.CHEST));
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a((double)CQRMaterials.ArmorMaterials.ARMOR_HEAVY_IRON.func_189416_e());
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn.field_70130_N * entityIn.field_70130_N * entityIn.field_70131_O > this.getWidth() * this.getWidth() * this.getHeight()) {
            super.func_70108_f(entityIn);
        }
    }

    @Override
    protected void func_184651_r() {
        if (CQRConfig.advanced.debugAI) {
            this.field_70714_bg = new EntityAITasksProfiled(this.field_70170_p.field_72984_F, this.field_70170_p);
            this.field_70715_bh = new EntityAITasksProfiled(this.field_70170_p.field_72984_F, this.field_70170_p);
        }
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOpenCloseDoor(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new BossAIExterminatorStun(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new BossAIExterminatorHulkSmash(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new BossAIExterminatorHandLaser(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new BossAIArmCannon(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIAttackSpecial(this));
        this.field_70714_bg.func_75776_a(13, new EntityAIAttackRanged<EntityCQRExterminator>(this));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIPotionThrower(this));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAIFireball(this));
        this.field_70714_bg.func_75776_a(16, (EntityAIBase)new EntityAIHooker(this));
        this.field_70714_bg.func_75776_a(17, (EntityAIBase)new EntityAIBackstab(this));
        this.field_70714_bg.func_75776_a(18, (EntityAIBase)new EntityAIAttack(this){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityCQRExterminator.this.isStunned();
            }

            @Override
            public boolean func_75253_b() {
                return super.func_75253_b() && !EntityCQRExterminator.this.isStunned();
            }
        });
        this.field_70714_bg.func_75776_a(19, (EntityAIBase)new EntityAICursedBoneSummoner(this));
        this.field_70714_bg.func_75776_a(20, (EntityAIBase)new EntityAIFollowAttackTarget(this));
        this.field_70714_bg.func_75776_a(24, (EntityAIBase)new EntityAILooter(this));
        this.field_70714_bg.func_75776_a(30, (EntityAIBase)new EntityAIMoveToLeader(this));
        this.field_70714_bg.func_75776_a(31, (EntityAIBase)new EntityAIFollowPath(this));
        this.field_70714_bg.func_75776_a(32, (EntityAIBase)new EntityAIMoveToHome(this));
        this.field_70714_bg.func_75776_a(33, (EntityAIBase)new EntityAIIdleSit(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAICQRNearestAttackTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetElectrocute(this, this::getElectroCuteTargetLeft, this::setElectroCuteTargetLeft));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetElectrocute(this, this::getElectroCuteTargetRight, this::setElectroCuteTargetRight));
    }

    public EntityLivingBase getElectroCuteTargetLeft() {
        return this.electroCuteTargetEmitterLeft;
    }

    public void setElectroCuteTargetLeft(EntityLivingBase electroCuteTargetA) {
        this.electroCuteTargetEmitterLeft = electroCuteTargetA;
        if (this.func_70613_aW()) {
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketUpdateEmitterTarget(this, true), (Entity)this);
        }
    }

    public EntityLivingBase getElectroCuteTargetRight() {
        return this.electroCuteTargetEmitterRight;
    }

    public void setElectroCuteTargetRight(EntityLivingBase electroCuteTargetB) {
        this.electroCuteTargetEmitterRight = electroCuteTargetB;
        if (this.func_70613_aW()) {
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketUpdateEmitterTarget(this, false), (Entity)this);
        }
    }

    public void setStunned(boolean value, int ticks) {
        if (this.func_70613_aW() && value && ticks / 3 >= this.stunTime) {
            this.stunTime += ticks / 3;
        }
        this.setStunned(value);
    }

    public void setStunned(boolean value) {
        if (this.isCannonRaised() && value) {
            this.switchCannonArmState(false);
        }
        this.field_70180_af.func_187227_b(IS_STUNNED, (Object)value);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (this.isStunned()) {
            this.stunTime += 16;
        } else {
            if (TargetUtil.PREDICATE_IS_ELECTROCUTED.apply((Object)this)) {
                return;
            }
            this.setStunned(true, 100);
        }
    }

    public boolean isStunned() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STUNNED);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_EXTERMINATOR;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.Exterminatior;
    }

    @Override
    protected EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.ILLAGERS;
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean canReceiveElectricDamageCurrently() {
        return IMechanical.super.canReceiveElectricDamageCurrently() || this.isStunned();
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_spin_coils", 0.0f, this::predicateSpinCoils));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_kick_and_punch", 0.0f, this::predicateSimpleAttack));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_long_animations", 0.0f, this::predicateBigAnimations));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_cannon_arm_state", 40.0f, this::predicateCannonArmPosition));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_main", 30.0f, this::predicateAnimationMain));
    }

    private <E extends IAnimatable> PlayState predicateSpinCoils(AnimationEvent<E> event) {
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_SPIN_COILS, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateAnimationMain(AnimationEvent<E> event) {
        if (this.canPlayDeathAnimation()) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_DEATH, Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.isStunned()) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_STUN, Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().transitionLengthTicks = 30.0;
        if (super.isSitting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_INACTIVE, Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(null);
        event.getController().clearAnimationCache();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicateCannonArmPosition(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S() || super.isSitting()) {
            return PlayState.STOP;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(CANNON_RAISED)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_CANNON_RAISED, Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_CANNON_LOWERED, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateBigAnimations(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            return PlayState.STOP;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(ARMS_BLOCKED_BY_LONG_ANIMATION)).booleanValue()) {
            if (this.shootIndicator) {
                event.getController().clearAnimationCache();
                this.shootIndicator = false;
                event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_CANNON_SHOOT, Boolean.valueOf(false)));
            } else if (this.throwIndicator) {
                event.getController().clearAnimationCache();
                this.throwIndicator = false;
                event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_THROW, Boolean.valueOf(false)));
            } else if (this.smashIndicator) {
                event.getController().clearAnimationCache();
                this.smashIndicator = false;
                event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_GROUND_SMASH, Boolean.valueOf(false)));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicateSimpleAttack(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            return PlayState.STOP;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(ARMS_BLOCKED_BY_LONG_ANIMATION)).booleanValue()) {
            return PlayState.STOP;
        }
        if (this.func_70678_g(event.getPartialTick()) > 0.0f) {
            boolean isKicking;
            this.kickInProgressClient = isKicking = ((Boolean)this.field_70180_af.func_187225_a(PUNCH_IS_KICK)).booleanValue();
            event.getController().setAnimation(new AnimationBuilder().addAnimation(isKicking ? ANIM_NAME_KICK : ANIM_NAME_PUNCH, Boolean.valueOf(false)));
        } else {
            this.kickInProgressClient = false;
            event.getController().setAnimation(null);
            event.getController().clearAnimationCache();
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public float getDefaultHeight() {
        return 2.75f;
    }

    @Override
    public float getDefaultWidth() {
        return 2.0f;
    }

    protected boolean isEmitterShortCircuited(SubEntityExterminatorFieldEmitter emitter) {
        return emitter.isActive() && (emitter.func_70090_H() || emitter.func_70026_G());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (TargetUtil.PREDICATE_IS_ELECTROCUTED.apply((Object)this) && (this.func_70026_G() || this.func_70090_H()) && !this.isStunned()) {
            this.setStunned(true, 10);
        }
        if (!this.isStunned()) {
            this.setStunned(this.isEmitterShortCircuited(this.getEmitterLeft()) || this.isEmitterShortCircuited(this.getEmitterRight()), 100);
        }
        if (this.func_70613_aW()) {
            if (this.stunTime > 0) {
                --this.stunTime;
            }
            this.setStunned(this.stunTime > 0);
        }
        for (MultiPartEntityPart part : this.parts) {
            this.field_70170_p.func_72866_a((Entity)part, true);
            part.func_70071_h_();
        }
        this.alignParts();
    }

    public void func_70030_z() {
        this.updateAnimationTimersServer();
        super.func_70030_z();
    }

    @Override
    public void sendAnimationUpdate(String animationName) {
        if (this.isCurrentlyPlayingAnimation()) {
            return;
        }
        IServerAnimationReceiver.super.sendAnimationUpdate(animationName);
        switch (animationName) {
            case "animation.exterminator.shoot_cannon": {
                this.animationTimer = this.cannonArmTimer;
                break;
            }
            case "animation.exterminator.throw": {
                this.animationTimer = 14;
                break;
            }
            case "animation.exterminator.ground_slam": {
                this.setEmitterLeftActive(false);
                this.setEmitterRightActive(false);
                this.animationTimer = 60;
                break;
            }
            default: {
                this.currentAnimationPlaying = null;
                this.animationTimer = -1;
                return;
            }
        }
        this.currentAnimationPlaying = animationName;
        this.field_70180_af.func_187227_b(ARMS_BLOCKED_BY_LONG_ANIMATION, (Object)true);
    }

    public int getCurrentAnimationTicks() {
        return this.animationTimer;
    }

    protected void updateAnimationTimersServer() {
        if (this.cannonArmTimer > 0) {
            --this.cannonArmTimer;
        }
        if (this.cannonTimeOut > 0) {
            --this.cannonTimeOut;
            if (this.cannonTimeOut <= 0) {
                this.switchCannonArmState(false);
            }
        }
        if (this.animationTimer > 0) {
            --this.animationTimer;
            if (this.animationTimer <= 0) {
                this.onAnimationEnd(this.currentAnimationPlaying);
                this.currentAnimationPlaying = null;
                this.field_70180_af.func_187227_b(ARMS_BLOCKED_BY_LONG_ANIMATION, (Object)false);
            }
        }
    }

    public void onAnimationEnd(String animationName) {
    }

    @Nullable
    public String getCurrentAnimation() {
        return this.currentAnimationPlaying;
    }

    public boolean isCurrentlyPlayingAnimation() {
        return this.animationTimer > 0;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_70965_a(null, source, amount);
    }

    public boolean func_70965_a(@Nullable MultiPartEntityPart part, DamageSource source, float amount) {
        boolean sentFromPart = part != this.parts[3] && part != this.parts[4] || part == null;
        this.handleAttackedByLargeGroups();
        boolean overrideFlag = false;
        if (source == DamageSource.field_76369_e && !this.func_70090_H() && this.isAnyEmitterActive()) {
            amount *= 2.0f;
            this.setStunned(true, 150);
        }
        if (source.func_76364_f() instanceof ProjectileCannonBall && source.func_76346_g() != this) {
            return super.func_70097_a(source, amount);
        }
        if (source.func_94541_c() && source.func_76346_g() != null && source.func_76346_g() == this) {
            return false;
        }
        if (source.func_76357_e() || source == DamageSource.field_76380_i || source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).func_184812_l_()) {
            return super.func_70097_a(source, amount);
        }
        if (source.func_76347_k()) {
            return false;
        }
        if (this.isStunned()) {
            if (source == DamageSource.field_180137_b) {
                amount /= 4.0f;
                overrideFlag = true;
            }
            if (sentFromPart) {
                amount *= 2.0f;
            }
        } else if (TargetUtil.PREDICATE_IS_ELECTROCUTED.apply((Object)this)) {
            this.partSoundFlag = true;
            this.func_184185_a(this.func_184601_bQ(source), 1.0f, 1.0f);
            return true;
        }
        if (!sentFromPart && !this.isStunned()) {
            this.partSoundFlag = true;
            this.func_184185_a(this.func_184601_bQ(source), 1.0f, 1.0f);
            return true;
        }
        this.partSoundFlag = false;
        return overrideFlag |= super.func_70097_a(source, amount);
    }

    private void handleAttackedByLargeGroups() {
        List<Entity> groupInFrontOfMe;
        if (this.func_70681_au().nextBoolean() && !this.isCannonRaised() && !this.isCurrentlyPlayingAnimation() && (groupInFrontOfMe = this.isSurroundedByGroupWithMinSize(5)) != null) {
            this.tryStartThrowingAnimation(groupInFrontOfMe, null);
        }
    }

    @Nullable
    public List<Entity> isSurroundedByGroupWithMinSize(int minSize) {
        List groupInFrontOfMe = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_191194_a(this.func_70040_Z().func_72432_b().func_186678_a((double)(this.getWidth() / 2.0f))).func_186662_g(1.0));
        groupInFrontOfMe.removeIf(entity -> entity instanceof MultiPartEntityPart);
        if (groupInFrontOfMe.size() >= minSize) {
            return groupInFrontOfMe;
        }
        return null;
    }

    public boolean func_70067_L() {
        return this.isStunned();
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.isStunned()) {
            return false;
        }
        boolean result = super.func_70652_k(entityIn);
        if (result) {
            if (this.isCurrentlyPlayingAnimation()) {
                if (this.currentAnimationPlaying.equalsIgnoreCase(ANIM_NAME_THROW) && !(this.func_184614_ca().func_77973_b() instanceof ItemStaffHealing)) {
                    Vec3d v = entityIn.func_174791_d().func_178788_d(this.func_174791_d());
                    v = v.func_72432_b().func_186678_a(1.5);
                    entityIn.field_70159_w += v.field_72450_a;
                    entityIn.field_70181_x += v.field_72448_b + 0.75;
                    entityIn.field_70179_y += v.field_72449_c;
                    entityIn.field_70133_I = true;
                    this.field_70180_af.func_187227_b(PUNCH_IS_KICK, (Object)true);
                }
            } else {
                this.field_70180_af.func_187227_b(PUNCH_IS_KICK, (Object)false);
                if (this.func_70681_au().nextBoolean() && !this.isCannonRaised()) {
                    List affectedEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_191194_a(this.func_70040_Z().func_72432_b().func_186678_a((double)this.getWidth() * 0.75 * (double)this.getSizeVariation())));
                    this.tryStartThrowingAnimation(affectedEntities, entityIn);
                }
            }
        }
        return result;
    }

    protected void tryStartThrowingAnimation(List<Entity> affectedEntities, Entity attackingMob) {
        if (!affectedEntities.isEmpty()) {
            Predicate<Entity> checkPred = TargetUtil.createPredicateNonAlly(this.getFaction());
            affectedEntities.forEach(entity -> {
                if (entity instanceof EntityLivingBase && !TargetUtil.areInSameParty((Entity)this, entity) && !TargetUtil.isAllyCheckingLeaders((EntityLivingBase)this, (EntityLivingBase)entity) || checkPred.test((Entity)entity)) {
                    Vec3d flyDirection = entity.func_174791_d().func_178788_d(this.func_174791_d()).func_72441_c(0.0, (double)this.getSizeVariation() * 0.4 * (double)DungeonGenUtils.randomBetween(1, 5, this.func_70681_au()), 0.0);
                    entity.field_70159_w += flyDirection.field_72450_a;
                    entity.field_70181_x += flyDirection.field_72448_b;
                    entity.field_70179_y += flyDirection.field_72449_c;
                    entity.field_70133_I = true;
                    if (entity != attackingMob) {
                        super.func_70652_k((Entity)entity);
                    }
                }
            });
            this.sendAnimationUpdate(ANIM_NAME_THROW);
        }
    }

    public Entity[] func_70021_al() {
        return this.parts;
    }

    private void alignParts() {
        Vec3d offsetMainHitbox = VectorUtil.rotateVectorAroundY(this.func_70040_Z().func_72432_b().func_186678_a((double)(this.getDefaultWidth() * this.getSizeVariation() / 6.0f)), 90.0);
        this.parts[4].func_70107_b(this.field_70165_t + offsetMainHitbox.field_72450_a, this.field_70163_u, this.field_70161_v + offsetMainHitbox.field_72449_c);
        this.parts[3].func_70107_b(this.field_70165_t - offsetMainHitbox.field_72450_a, this.field_70163_u, this.field_70161_v - offsetMainHitbox.field_72449_c);
        Vec3d offset = this.func_70040_Z().func_72432_b().func_186678_a(-0.25 * (double)this.getSizeVariation());
        offset = offset.func_72441_c(0.0, 1.25 * (double)this.getSizeVariation(), 0.0);
        this.parts[0].func_70107_b(this.field_70165_t + offset.field_72450_a, this.field_70163_u + offset.field_72448_b, this.field_70161_v + offset.field_72449_c);
        Vec3d offsetEmittersHorizontal = this.func_70040_Z().func_72432_b().func_186678_a(0.5 * (double)this.getSizeVariation());
        Vec3d offsetEmitters = this.func_70040_Z().func_72432_b().func_186678_a(-0.4 * (double)this.getSizeVariation());
        offsetEmitters = offsetEmitters.func_72441_c(0.0, 2.375 * (double)this.getSizeVariation(), 0.0);
        offsetEmittersHorizontal = VectorUtil.rotateVectorAroundY(offsetEmittersHorizontal, 90.0);
        this.parts[2].func_70107_b(this.field_70165_t + offsetEmitters.field_72450_a + offsetEmittersHorizontal.field_72450_a, this.field_70163_u + offsetEmitters.field_72448_b, this.field_70161_v + offsetEmitters.field_72449_c + offsetEmittersHorizontal.field_72449_c);
        offsetEmittersHorizontal = VectorUtil.rotateVectorAroundY(offsetEmittersHorizontal, 180.0);
        this.parts[1].func_70107_b(this.field_70165_t + offsetEmitters.field_72450_a + offsetEmittersHorizontal.field_72450_a, this.field_70163_u + offsetEmitters.field_72448_b, this.field_70161_v + offsetEmitters.field_72449_c + offsetEmittersHorizontal.field_72449_c);
    }

    @Override
    public void resize(float widthScale, float heightSacle) {
        super.resize(widthScale, heightSacle);
        for (MultiPartEntityPart part : this.parts) {
            if (!(part instanceof ISizable)) continue;
            ((ISizable)part).resize(widthScale, heightSacle);
        }
    }

    @Override
    public boolean isSitting() {
        return false;
    }

    public void func_70106_y() {
        for (MultiPartEntityPart part : this.parts) {
            this.field_70170_p.func_72973_f((Entity)part);
        }
        super.func_70106_y();
    }

    public boolean isCannonArmReadyToShoot() {
        return this.isCannonRaised() && !this.isCannonArmPlayingAnimation() && !this.isCurrentlyPlayingAnimation();
    }

    public boolean isExecutingThrow() {
        if (this.isCurrentlyPlayingAnimation() && this.getCurrentAnimation() != null) {
            return this.getCurrentAnimation().equalsIgnoreCase(ANIM_NAME_THROW);
        }
        return false;
    }

    public boolean isExecutingGroundSlam() {
        if (this.isCurrentlyPlayingAnimation() && this.getCurrentAnimation() != null) {
            return this.getCurrentAnimation().equalsIgnoreCase(ANIM_NAME_GROUND_SMASH);
        }
        return false;
    }

    @Override
    public boolean isMagicArmorActive() {
        return super.isMagicArmorActive() || this.isStunned();
    }

    @Override
    protected void updateCooldownForMagicArmor() {
        if (this.isStunned()) {
            return;
        }
        super.updateCooldownForMagicArmor();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.deathCause = cause;
        super.func_70645_a(cause);
    }

    @Override
    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
    }

    @Override
    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 65) {
            this.spawnDeathPoofParticles();
        }
        if (this.field_70725_aQ >= 70 && this.func_70613_aW()) {
            if (this.deathCause != null) {
                super.func_184610_a(this.field_70718_bc > 0, ForgeHooks.getLootingLevel((Entity)this, (Entity)this.deathCause.func_76346_g(), (DamageSource)this.deathCause), this.deathCause);
            }
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            this.onFinalDeath();
        }
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        if (!this.partSoundFlag) {
            return SoundEvents.field_187689_f;
        }
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187605_cG;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean switchCannonArmState(boolean raised) {
        this.resetCannonTimeout();
        if (raised == (Boolean)this.field_70180_af.func_187225_a(CANNON_RAISED)) {
            return true;
        }
        if (this.cannonArmTimer != 0) {
            return false;
        }
        this.field_70180_af.func_187227_b(CANNON_RAISED, (Object)raised);
        this.cannonArmTimer = 40;
        return true;
    }

    public void setCannonArmAutoTimeoutForLowering(int value) {
        this.cannonTimeOut = value;
    }

    public void resetCannonTimeout() {
        this.setCannonArmAutoTimeoutForLowering(0);
    }

    public boolean startShootingAnimation(boolean fastShot) {
        if (this.isCannonArmReadyToShoot()) {
            this.cannonArmTimer = 12;
            if (fastShot) {
                this.cannonArmTimer /= 2;
            }
            this.sendAnimationUpdate(ANIM_NAME_CANNON_SHOOT);
            return true;
        }
        return false;
    }

    public boolean isCannonArmPlayingAnimation() {
        return this.cannonArmTimer != 0;
    }

    public boolean isCannonRaised() {
        return (Boolean)this.field_70180_af.func_187225_a(CANNON_RAISED);
    }

    public Vec3d getCannonFiringPointOffset() {
        Vec3d result = Vec3d.field_186680_a;
        float scale = this.getSizeVariation();
        result = result.func_72441_c(0.0, 1.88, 0.0);
        Vec3d facing = this.func_174806_f(this.field_70125_A, this.field_70761_aq);
        result = result.func_178787_e(facing.func_186678_a(1.25));
        result = result.func_178787_e(VectorUtil.rotateVectorAroundY(facing, 270.0).func_186678_a(0.68));
        result = result.func_186678_a((double)scale);
        return result;
    }

    public Vec3d getCannonFiringLocation() {
        Vec3d result = this.getCannonFiringPointOffset();
        result = result.func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isUsingKickAnimation() {
        return this.kickInProgressClient;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void processAnimationUpdate(String animationID) {
        this.currentAnimationPlaying = animationID;
        switch (animationID) {
            case "animation.exterminator.shoot_cannon": {
                this.shootIndicator = true;
                break;
            }
            case "animation.exterminator.throw": {
                this.throwIndicator = true;
                break;
            }
            case "animation.exterminator.ground_slam": {
                this.smashIndicator = true;
            }
        }
    }

    public boolean canElectricCoilsBeActive() {
        return !super.isSitting() && !this.isStunned() && !this.isExecutingGroundSlam() && !this.canPlayDeathAnimation();
    }

    public void updateEmitterTargetRightClient(Entity object) {
        if (object != null && object instanceof EntityLivingBase) {
            this.setElectroCuteTargetRight((EntityLivingBase)object);
        } else {
            this.setElectroCuteTargetRight(null);
        }
    }

    public void updateEmitterTargetLeftClient(Entity object) {
        if (object != null && object instanceof EntityLivingBase) {
            this.setElectroCuteTargetLeft((EntityLivingBase)object);
        } else {
            this.setElectroCuteTargetLeft(null);
        }
    }

    public boolean func_70026_G() {
        return this.func_70090_H();
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(CQRItems.BATTLE_AXE_BULL));
    }

    public void tick() {
    }

    public int tickTimer() {
        return this.field_70173_aa;
    }
}

