/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.gianttortoise;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemShield;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ISizable;
import team.cqr.cqrepoured.entity.ai.EntityAIIdleSit;
import team.cqr.cqrepoured.entity.ai.boss.gianttortoise.BossAITortoiseHealing;
import team.cqr.cqrepoured.entity.ai.boss.gianttortoise.BossAITortoiseMoveToHome;
import team.cqr.cqrepoured.entity.ai.boss.gianttortoise.BossAITortoiseMoveToLeader;
import team.cqr.cqrepoured.entity.ai.boss.gianttortoise.BossAITortoiseSpinAttack;
import team.cqr.cqrepoured.entity.ai.boss.gianttortoise.BossAITortoiseStun;
import team.cqr.cqrepoured.entity.ai.boss.gianttortoise.BossAITortoiseSwimming;
import team.cqr.cqrepoured.entity.ai.target.EntityAICQRNearestAttackTarget;
import team.cqr.cqrepoured.entity.ai.target.EntityAIHurtByTarget;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.entity.boss.gianttortoise.SubEntityGiantTortoisePart;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityCQRGiantTortoise
extends AbstractEntityCQRBoss
implements IEntityMultiPart,
IRangedAttackMob,
IAnimatable,
IAnimationTickable {
    private static final DataParameter<Boolean> IN_SHELL = EntityDataManager.func_187226_a(EntityCQRGiantTortoise.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IN_SHELL_BYPASS = EntityDataManager.func_187226_a(EntityCQRGiantTortoise.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CURRENT_ANIMATION_ID = EntityDataManager.func_187226_a(EntityCQRGiantTortoise.class, (DataSerializer)DataSerializers.field_187192_b);
    private int nextAnimationId = 5;
    private int currentAnimationTick = 0;
    public static final int ANIMATION_ID_IN_SHELL = 5;
    public static final int ANIMATION_ID_EXIT_SHELL = 4;
    public static final int ANIMATION_ID_ENTER_SHELL = 3;
    public static final int ANIMATION_ID_STUNNED = 2;
    public static final int ANIMATION_ID_SPINNING = 1;
    public static final int ANIMATION_ID_WALK = 0;
    public static final String ANIMATION_NAME_DEATH = "animation.giant_tortoise.death";
    public static final AnimationGecko[] ANIMATIONS = new AnimationGecko[]{new AnimationGecko("animation.giant_tortoise.walk", 20), new AnimationGecko("animation.giant_tortoise.spin", 260), new AnimationGecko("animation.giant_tortoise.stun", 140), new AnimationGecko("animation.giant_tortoise.enter_shell", 31), new AnimationGecko("animation.giant_tortoise.exit_shell", 31), new AnimationGecko("animation.giant_tortoise.in_shell", 1)};
    protected SubEntityGiantTortoisePart[] parts = new SubEntityGiantTortoisePart[5];
    public static final int TARGET_MOVE_OUT = 1;
    public static final int TARGET_MOVE_IN = -1;
    private boolean partSoundFlag = false;
    private boolean stunned = false;
    private boolean canBeStunned = true;
    private boolean readyToSpin = true;
    private boolean spinning = false;
    private int spinsBlocked = 0;
    private int timesHealed = 1;
    private boolean isHealing = false;
    private Vec3d lastTickPos = null;
    private int stuckTicks = 0;
    private static final int MAX_STUCK_TICKS = 60;
    private static List<ResourceLocation> hardBlocks = new ArrayList<ResourceLocation>();
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    @SideOnly(value=Side.CLIENT)
    private int currentAnimationClient;
    private DamageSource deathCause = null;

    public EntityCQRGiantTortoise(World worldIn) {
        super(worldIn);
        this.field_70138_W = 2.1f;
        for (int i = 0; i < this.parts.length - 1; ++i) {
            this.parts[i] = new SubEntityGiantTortoisePart(this, "tortoise_leg" + i, 0.7f, 1.1f, false);
        }
        this.parts[this.parts.length - 1] = new SubEntityGiantTortoisePart(this, "tortoise_head", 0.7f, 0.7f, true);
        this.field_70145_X = false;
        this.func_189654_d(false);
        this.field_70178_ae = true;
        this.field_70728_aV = 100;
        this.field_70158_ak = true;
    }

    @Override
    public void enableBossBar() {
        super.enableBossBar();
        if (this.bossInfoServer != null) {
            this.bossInfoServer.func_186745_a(BossInfo.Color.GREEN);
        }
    }

    public static void realoadHardBlocks() {
        hardBlocks.clear();
        for (String s : CQRConfig.bosses.giantTortoiseHardBlocks) {
            ResourceLocation rs = new ResourceLocation(s);
            hardBlocks.add(rs);
        }
    }

    public static boolean isHardBlock(ResourceLocation rl) {
        return !hardBlocks.isEmpty() && hardBlocks.contains(rl);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new BossAITortoiseSwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new BossAITortoiseStun(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new BossAITortoiseHealing(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new BossAITortoiseSpinAttack(this));
        this.field_70714_bg.func_75776_a(19, (EntityAIBase)new BossAITortoiseMoveToLeader(this));
        this.field_70714_bg.func_75776_a(20, (EntityAIBase)new BossAITortoiseMoveToHome(this));
        this.field_70714_bg.func_75776_a(21, (EntityAIBase)new EntityAIIdleSit(this){

            @Override
            public boolean func_75250_a() {
                if (super.func_75250_a() && ((EntityCQRGiantTortoise)this.entity).isInShell() && !EntityCQRGiantTortoise.this.isHealing && !EntityCQRGiantTortoise.this.isStunned() && !EntityCQRGiantTortoise.this.isSpinning()) {
                    return true;
                }
                if (super.func_75250_a() && !EntityCQRGiantTortoise.this.isHealing && !EntityCQRGiantTortoise.this.isStunned() && !EntityCQRGiantTortoise.this.isSpinning() && EntityCQRGiantTortoise.this.getCurrentAnimationId() != 5 && EntityCQRGiantTortoise.this.getCurrentAnimationId() == 0) {
                    EntityCQRGiantTortoise.this.setNextAnimation(3);
                }
                return false;
            }
        });
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAICQRNearestAttackTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(this));
    }

    @Override
    public float getDefaultWidth() {
        return 2.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 1.7f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IN_SHELL, (Object)true);
        this.field_70180_af.func_187214_a(IN_SHELL_BYPASS, (Object)false);
        this.field_70180_af.func_187214_a(CURRENT_ANIMATION_ID, (Object)this.nextAnimationId);
    }

    public int getCurrentAnimationId() {
        return (Integer)this.field_70180_af.func_187225_a(CURRENT_ANIMATION_ID);
    }

    private void setCurrentAnimation(int id) {
        if (this.func_70613_aW() && id >= 0 && id < ANIMATIONS.length) {
            this.field_70180_af.func_187227_b(CURRENT_ANIMATION_ID, (Object)id);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.99);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.125);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_70965_a(null, source, amount);
    }

    public boolean func_70965_a(@Nullable MultiPartEntityPart part, DamageSource source, float amount) {
        boolean sentFromPart;
        boolean bl = sentFromPart = part != null;
        if (source.func_76357_e() || source == DamageSource.field_76380_i || source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).func_184812_l_()) {
            return super.func_70097_a(source, amount);
        }
        this.partSoundFlag = sentFromPart;
        if (source.func_76346_g() instanceof EntityLivingBase && !(source.func_76346_g() instanceof EntityPlayer) && this.func_70681_au().nextBoolean() && !sentFromPart) {
            sentFromPart = true;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (!sentFromPart) {
            amount = 0.0f;
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184601_bQ(source), SoundCategory.HOSTILE, 1.0f, 1.0f, true);
        }
        if (sentFromPart && (!this.isInShell() || source == DamageSource.field_76368_d)) {
            if (this.stunned) {
                amount *= 2.0f;
            }
            return super.func_70097_a(source, amount);
        }
        return true;
    }

    public boolean isInShell() {
        return (Boolean)this.field_70180_af.func_187225_a(IN_SHELL);
    }

    public boolean isStunned() {
        return this.stunned;
    }

    public boolean canBeStunned() {
        return this.canBeStunned;
    }

    public void setCanBeStunned(boolean value) {
        this.canBeStunned = value;
    }

    public void setStunned(boolean value) {
        this.stunned = value;
        this.readyToSpin = !this.stunned;
    }

    public boolean bypassInShell() {
        return (Boolean)this.field_70180_af.func_187225_a(IN_SHELL_BYPASS);
    }

    public void setBypassInShell(boolean val) {
        this.field_70180_af.func_187227_b(IN_SHELL_BYPASS, (Object)val);
    }

    public int func_70086_ai() {
        return 100;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_TURTLE;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.GiantTortoise;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.BEASTS;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70050_g(999);
        for (SubEntityGiantTortoisePart part : this.parts) {
            this.field_70170_p.func_72866_a((Entity)part, true);
        }
        this.alignParts();
        this.breakBlocksInWay();
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.hasAttackTarget()) {
            if (this.lastTickPos == null) {
                this.lastTickPos = this.func_174791_d();
            }
            if (this.getHomePositionCQR() == null) {
                this.setHomePositionCQR(this.func_180425_c());
            }
            Vec3d curPos = this.func_174791_d();
            if (this.getHomePositionCQR().func_177954_c(curPos.field_72450_a, curPos.field_72448_b, curPos.field_72449_c) > 16.0) {
                if (curPos.func_72438_d(this.lastTickPos) <= 0.05) {
                    ++this.stuckTicks;
                } else {
                    this.lastTickPos = curPos;
                }
                if (this.stuckTicks >= 60) {
                    this.func_70624_b(null);
                    this.stuckTicks = 0;
                }
            }
        } else {
            this.stuckTicks = 0;
        }
        this.updateAnimations();
    }

    private void breakBlocksInWay() {
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177963_a((double)(this.field_70130_N + 1.0f), (double)this.field_70131_O, (double)(this.field_70130_N + 1.0f)), (BlockPos)this.func_180425_c().func_177963_a((double)(-this.field_70130_N - 1.0f), -1.0, (double)(-this.field_70130_N - 1.0f)))) {
            Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
            if (block.func_149703_v() && !block.func_176205_b((IBlockAccess)this.field_70170_p, pos) || block == Blocks.field_150358_i || block == Blocks.field_150355_j || block == Blocks.field_150356_k || block == Blocks.field_150353_l) continue;
            this.field_70170_p.func_175698_g(pos);
        }
    }

    private void alignParts() {
        float rotYawHead = this.field_70759_as;
        if (rotYawHead > 180.0f) {
            rotYawHead -= 360.0f;
        }
        Vec3d v = this.func_70040_Z().func_186678_a((double)(this.field_70130_N / 2.0f) + (double)this.field_70130_N * 0.1);
        float vy = this.getCurrentAnimationId() != 0 ? 0.15f : 0.5f;
        this.parts[this.parts.length - 1].func_70107_b(this.field_70165_t + v.field_72450_a, this.field_70163_u + (double)(vy *= this.getSizeVariation()), this.field_70161_v + v.field_72449_c);
        this.parts[this.parts.length - 1].func_70101_b(rotYawHead, this.field_70125_A);
        v = VectorUtil.rotateVectorAroundY(v, 45.0);
        for (int i = 0; i < this.parts.length - 1; ++i) {
            double x = this.field_70165_t + v.field_72450_a;
            double y = this.field_70163_u;
            double z = this.field_70161_v + v.field_72449_c;
            this.parts[i].func_70107_b(x, y, z);
            this.parts[i].func_70101_b(rotYawHead + ((float)i * 90.0f + 45.0f), this.field_70125_A);
            v = VectorUtil.rotateVectorAroundY(v, 90.0);
        }
    }

    public Entity[] func_70021_al() {
        return this.parts;
    }

    public void func_70106_y() {
        super.func_70106_y();
        for (SubEntityGiantTortoisePart part : this.parts) {
            this.field_70170_p.func_72973_f((Entity)part);
        }
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        if (this.isInShell()) {
            return SoundEvents.field_187603_D;
        }
        if (this.partSoundFlag) {
            this.partSoundFlag = false;
            return SoundEvents.field_187880_fp;
        }
        return SoundEvents.field_187603_D;
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.isSpinning()) {
            boolean blocked = false;
            if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_184607_cu().func_77973_b() instanceof ItemShield) {
                if (this.func_70681_au().nextBoolean()) {
                    ++this.spinsBlocked;
                }
                ++this.spinsBlocked;
                blocked = true;
            }
            if (!blocked) {
                entityIn.func_70097_a(DamageSource.func_92087_a((Entity)this), 4.0f * ((float)Math.max(1, this.field_70170_p.func_175659_aa().func_151525_a()) * 1.5f));
            }
            Vec3d v = entityIn.func_174791_d().func_178788_d(this.func_174791_d());
            v = v.func_72432_b();
            v = blocked ? v.func_186678_a(0.8) : v.func_186678_a(1.5);
            entityIn.field_70159_w = v.field_72450_a;
            entityIn.field_70181_x = v.field_72448_b + 0.75;
            entityIn.field_70179_y = v.field_72449_c;
            entityIn.field_70133_I = true;
            if (blocked) {
                v = v.func_186678_a(1.7);
                this.field_70159_w = -v.field_72450_a;
                this.field_70181_x = v.field_72448_b + 0.25;
                this.field_70179_y = -v.field_72449_c;
                this.field_70133_I = true;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187603_D, SoundCategory.HOSTILE, 1.0f, 1.0f, true);
            }
        } else {
            super.func_82167_n(entityIn);
        }
    }

    public void func_70015_d(int seconds) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void setInShell(boolean val) {
        this.field_70180_af.func_187227_b(IN_SHELL, (Object)val);
        this.readyToSpin = val && !this.isHealing();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("timesHealed", this.timesHealed);
        compound.func_74757_a("inShell", this.isInShell());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setTimesHealed(compound.func_74762_e("timesHealed"));
        if (this.getTimesHealed() < 1) {
            this.setTimesHealed(1);
        }
        this.setInShell(compound.func_74767_n("inShell"));
    }

    public int getTimesHealed() {
        return this.timesHealed;
    }

    public void setTimesHealed(int val) {
        this.timesHealed = val;
    }

    public void setHealing(boolean val) {
        this.isHealing = val;
        this.readyToSpin = !this.isHealing;
    }

    public boolean isHealing() {
        return this.isHealing;
    }

    public void setSpinning(boolean value) {
        this.spinning = value;
        this.readyToSpin = !this.spinning;
    }

    public boolean isSpinning() {
        return this.spinning;
    }

    @Override
    public boolean canOpenDoors() {
        return false;
    }

    public void setReadyToSpin(boolean value) {
        this.readyToSpin = value;
    }

    public boolean isReadyToSpin() {
        return this.readyToSpin;
    }

    public Vec3d func_174824_e(float partialTicks) {
        Vec3d headPos = this.parts[this.parts.length - 1].func_174791_d();
        return headPos.func_178787_e(headPos.func_178786_a(this.field_70165_t, 0.0, this.field_70161_v)).func_72432_b().func_186678_a(0.25);
    }

    public int getSpinsBlocked() {
        return this.spinsBlocked;
    }

    public void resetSpinsBlocked() {
        this.spinsBlocked = 0;
    }

    @Override
    public boolean canPutOutFire() {
        return false;
    }

    @Override
    public boolean canIgniteTorch() {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIMATION_NAME_DEATH, Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.getCurrentAnimationId() < 0) {
            return PlayState.STOP;
        }
        if (this.currentAnimationClient != this.getCurrentAnimationId()) {
            this.currentAnimationClient = this.getCurrentAnimationId();
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIMATIONS[this.currentAnimationClient].getAnimationName()));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void setNextAnimation(int id) {
        this.nextAnimationId = id;
    }

    private void updateAnimations() {
        if (this.func_70613_aW()) {
            int currentAnimation = this.getCurrentAnimationId();
            if (this.nextAnimationId != currentAnimation) {
                AnimationGecko nextAnimation = ANIMATIONS[this.nextAnimationId];
                this.currentAnimationTick = nextAnimation.getAnimationDuration();
                this.setCurrentAnimation(this.nextAnimationId);
                this.onAnimationEnd(this.nextAnimationId, false);
                return;
            }
            if (this.currentAnimationTick >= 0) {
                --this.currentAnimationTick;
            } else if (this.currentAnimationTick == -1) {
                this.onAnimationEnd(currentAnimation, true);
            }
        }
    }

    public int getCurrentAnimationTick() {
        return ANIMATIONS[this.getCurrentAnimationId()].getAnimationDuration() - this.currentAnimationTick;
    }

    public void resetCurrentAnimationTickTime() {
        this.currentAnimationTick = ANIMATIONS[this.getCurrentAnimationId()].getAnimationDuration();
    }

    public boolean shouldCurrentAnimationBePlaying() {
        if (!this.func_70613_aW()) {
            return false;
        }
        return this.currentAnimationTick >= 0;
    }

    protected void onAnimationEnd(int animationID, boolean endByAnimationFinished) {
        if (endByAnimationFinished) {
            switch (animationID) {
                case 4: {
                    this.setNextAnimation(0);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.setNextAnimation(5);
                }
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.deathCause = cause;
        super.func_70645_a(cause);
    }

    @Override
    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
    }

    @Override
    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ > 20) {
            float sizeVariation = this.getSizeVariation();
            double f = (this.field_70146_Z.nextDouble() - 0.5) * (double)(this.getDefaultWidth() * (sizeVariation *= 1.5f));
            double f1 = (this.field_70146_Z.nextDouble() - 0.5) * (double)(this.getDefaultHeight() * sizeVariation);
            double f2 = (this.field_70146_Z.nextDouble() - 0.5) * (double)(this.getDefaultWidth() * sizeVariation);
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, this.field_70165_t + f, this.field_70163_u + (double)(this.getDefaultHeight() * sizeVariation / 2.0f) + f1, this.field_70161_v + f2, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.DAMAGE_INDICATOR, this.field_70165_t + f, this.field_70163_u + (double)(this.getDefaultHeight() * sizeVariation / 2.0f) + f1, this.field_70161_v + f2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_70725_aQ == 34 && this.func_70613_aW()) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
        }
        if (this.field_70725_aQ >= 35 && this.func_70613_aW()) {
            if (this.deathCause != null) {
                super.func_184610_a(this.field_70718_bc > 0, ForgeHooks.getLootingLevel((Entity)this, (Entity)this.deathCause.func_76346_g(), (DamageSource)this.deathCause), this.deathCause);
            }
            this.func_70106_y();
            this.onFinalDeath();
        }
    }

    @Override
    public void resize(float widthScale, float heightSacle) {
        super.resize(widthScale, heightSacle);
        for (SubEntityGiantTortoisePart part : this.parts) {
            if (!(part instanceof ISizable)) continue;
            part.resize(widthScale, heightSacle);
        }
    }

    public void tick() {
    }

    public int tickTimer() {
        return this.field_70173_aa;
    }

    public static class AnimationGecko {
        private final String animationName;
        private final int animationDuration;

        public AnimationGecko(String name, int duration) {
            this.animationDuration = duration;
            this.animationName = name;
        }

        public String getAnimationName() {
            return this.animationName;
        }

        public int getAnimationDuration() {
            return this.animationDuration;
        }
    }
}

