/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.netherdragon;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ICirclingEntity;
import team.cqr.cqrepoured.entity.IDontRenderFire;
import team.cqr.cqrepoured.entity.ai.boss.netherdragon.BossAICircleAroundLocation;
import team.cqr.cqrepoured.entity.ai.boss.netherdragon.BossAIFlyToLocation;
import team.cqr.cqrepoured.entity.ai.boss.netherdragon.BossAIFlyToTarget;
import team.cqr.cqrepoured.entity.ai.boss.netherdragon.BossAISpiralUpToCirclingCenter;
import team.cqr.cqrepoured.entity.ai.navigator.MoveHelperDirectFlight;
import team.cqr.cqrepoured.entity.ai.navigator.PathNavigateDirectLine;
import team.cqr.cqrepoured.entity.ai.target.EntityAICQRNearestAttackTarget;
import team.cqr.cqrepoured.entity.ai.target.EntityAIHurtByTarget;
import team.cqr.cqrepoured.entity.ai.target.EntityAINearestAttackTargetAtHomeArea;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.entity.boss.netherdragon.SubEntityNetherDragonSegment;
import team.cqr.cqrepoured.entity.projectiles.ProjectileHotFireball;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.util.EntityUtil;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityCQRNetherDragon
extends AbstractEntityCQRBoss
implements IEntityMultiPart,
IRangedAttackMob,
ICirclingEntity,
IDontRenderFire {
    public final int INITIAL_SEGMENT_COUNT;
    public final int SEGMENT_COUNT_ON_DEATH = 4;
    public int segmentCount;
    private int phase;
    private int phaseChangeTimer;
    private float damageTmpPhaseTwo;
    private int fireballTimer;
    private int mouthTimer;
    boolean deathPhaseEnd;
    private SubEntityNetherDragonSegment[] dragonBodyParts;
    private static final DataParameter<Boolean> MOUTH_OPEN = EntityDataManager.func_187226_a(EntityCQRNetherDragon.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SKELE_COUNT = EntityDataManager.func_187226_a(EntityCQRNetherDragon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(EntityCQRNetherDragon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SPIT_FIRE = EntityDataManager.func_187226_a(EntityCQRNetherDragon.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SERVER_PART_LENGTH = EntityDataManager.func_187226_a(EntityCQRNetherDragon.class, (DataSerializer)DataSerializers.field_187192_b);
    private Vec3d targetLocation;
    private boolean flyingUp;
    private static List<ResourceLocation> breakableBlocks = new ArrayList<ResourceLocation>();

    @Override
    public void setSizeVariation(float size) {
    }

    @Override
    public float getSizeVariation() {
        return 0.0f;
    }

    public EntityCQRNetherDragon(World worldIn) {
        super(worldIn);
        this.INITIAL_SEGMENT_COUNT = CQRConfig.bosses.netherDragonLength;
        this.SEGMENT_COUNT_ON_DEATH = 4;
        this.segmentCount = this.INITIAL_SEGMENT_COUNT;
        this.phase = 0;
        this.phaseChangeTimer = 0;
        this.damageTmpPhaseTwo = CQRConfig.bosses.netherDragonStageTwoSegmentHP;
        this.fireballTimer = 240;
        this.mouthTimer = 0;
        this.deathPhaseEnd = false;
        this.dragonBodyParts = new SubEntityNetherDragonSegment[this.INITIAL_SEGMENT_COUNT];
        this.targetLocation = null;
        this.flyingUp = false;
        this.field_70728_aV = 100;
        this.field_70145_X = true;
        this.field_70158_ak = true;
        this.initBody();
        this.field_70765_h = new MoveHelperDirectFlight((EntityLiving)this);
    }

    public static void reloadBreakableBlocks() {
        breakableBlocks.clear();
        for (String s : CQRConfig.bosses.netherDragonBreakableBlocks) {
            ResourceLocation rs = new ResourceLocation(s);
            breakableBlocks.add(rs);
        }
    }

    public void setFlyingUp(boolean value) {
        this.flyingUp = value;
    }

    public boolean isFlyingUp() {
        return this.flyingUp;
    }

    private void initBody() {
        if (this.segmentCount < 0) {
            this.segmentCount = this.INITIAL_SEGMENT_COUNT;
        }
        this.dragonBodyParts = new SubEntityNetherDragonSegment[this.segmentCount];
        for (int i = 0; i < this.dragonBodyParts.length; ++i) {
            this.dragonBodyParts[i] = new SubEntityNetherDragonSegment(this, i + 1, false);
            this.field_70170_p.func_72838_d((Entity)this.dragonBodyParts[i]);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public float getDefaultWidth() {
        return 2.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 2.0f;
    }

    @Override
    protected boolean usesEnderDragonDeath() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOUTH_OPEN, (Object)false);
        this.field_70180_af.func_187214_a(SKELE_COUNT, (Object)-1);
        this.field_70180_af.func_187214_a(PHASE, (Object)this.phase);
        this.field_70180_af.func_187214_a(SPIT_FIRE, (Object)false);
        this.field_70180_af.func_187214_a(SERVER_PART_LENGTH, (Object)this.segmentCount);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_70965_a(null, source, amount);
    }

    public boolean func_70965_a(@Nullable MultiPartEntityPart part, DamageSource source, float damage) {
        if (source.func_76347_k() || source.func_94541_c()) {
            return false;
        }
        if (this.phase == 0 && (damage = damage / 4.0f + Math.min(damage, 1.0f)) >= this.func_110143_aJ()) {
            ++this.phase;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(PHASE, (Object)this.phase);
            }
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFinalDeathSound(), SoundCategory.MASTER, 1.0f, 1.0f, false);
            this.func_70606_j(this.func_110138_aP() - 1.0f);
            damage = 0.0f;
            return false;
        }
        if (this.phase == 1) {
            return false;
        }
        if (this.phase == 2) {
            this.handleAttackedInSkeletalPhase(damage, source);
            return super.func_70097_a(source, 0.0f);
        }
        if (this.phase == 0) {
            return super.func_70097_a(source, damage);
        }
        return super.func_70097_a(source, damage);
    }

    private void handleAttackedInSkeletalPhase(float damage, DamageSource source) {
        this.damageTmpPhaseTwo -= damage;
        if (this.damageTmpPhaseTwo <= 0.0f) {
            this.damageTmpPhaseTwo = CQRConfig.bosses.netherDragonStageTwoSegmentHP;
            damage = this.func_110138_aP() / (float)(this.INITIAL_SEGMENT_COUNT - this.SEGMENT_COUNT_ON_DEATH);
            this.func_70606_j(this.func_110143_aJ() - damage);
            if (damage >= this.func_110143_aJ()) {
                super.func_70097_a(source, damage + 1.0f);
            }
        }
        this.updateSegmentCount();
    }

    private void removeLastSegment() {
        int indx = Math.max(0, this.dragonBodyParts.length - 1);
        SubEntityNetherDragonSegment segment = this.dragonBodyParts[indx];
        if (indx > 0) {
            SubEntityNetherDragonSegment[] partsTmp = new SubEntityNetherDragonSegment[this.dragonBodyParts.length - 1];
            for (int i = 0; i < partsTmp.length; ++i) {
                partsTmp[i] = this.dragonBodyParts[i];
            }
            this.dragonBodyParts = partsTmp;
        } else {
            this.dragonBodyParts = new SubEntityNetherDragonSegment[0];
        }
        segment.die();
        if (!this.field_70170_p.field_72995_K) {
            segment.onRemovedFromBody();
        }
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new BossAIFlyToTarget(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new BossAIFlyToLocation(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new BossAISpiralUpToCirclingCenter(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new BossAICircleAroundLocation(this));
        this.field_70715_bh.func_75776_a(0, new EntityAINearestAttackTargetAtHomeArea<EntityCQRNetherDragon>(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAICQRNearestAttackTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(this));
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return false;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.NetherDragon;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.UNDEAD;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.mouthTimer > 0 || this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70681_au().nextDouble() < 0.4) {
            this.mouthTimer = 10;
            Vec3d velocity = target.func_174791_d().func_178788_d(this.func_174791_d());
            velocity = velocity.func_72432_b().func_186678_a(1.5);
            ProjectileHotFireball proj = new ProjectileHotFireball(this.field_70170_p, (EntityLivingBase)this, this.field_70165_t + velocity.field_72450_a, this.field_70163_u + velocity.field_72448_b, this.field_70161_v + velocity.field_72449_c);
            proj.field_70159_w = velocity.field_72450_a;
            proj.field_70181_x = velocity.field_72448_b;
            proj.field_70179_y = velocity.field_72449_c;
            proj.field_70133_I = true;
            this.field_70170_p.func_72838_d((Entity)proj);
        } else {
            this.mouthTimer = 160;
            this.field_70180_af.func_187227_b(SPIT_FIRE, (Object)true);
        }
    }

    public void setBreathingFireFlag(boolean value) {
        this.mouthTimer = value ? 100 : 10;
        this.field_70180_af.func_187227_b(SPIT_FIRE, (Object)value);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (this.phase > 1 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100 + entityIn.field_70170_p.func_175659_aa().ordinal() * 40, 3));
            }
            if (!this.field_70170_p.field_72995_K) {
                this.mouthTimer = 5;
            }
            return true;
        }
        return false;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected void moveParts() {
        for (int i = 0; i < this.dragonBodyParts.length; ++i) {
            EntityCQRNetherDragon leader;
            if (this.dragonBodyParts[i] == null) continue;
            IDontRenderFire iDontRenderFire = leader = i == 0 ? this : this.dragonBodyParts[i - 1];
            if (leader == null) continue;
            double headerX = ((Entity)leader).field_70165_t;
            double headerY = ((Entity)leader).field_70163_u;
            double headerZ = ((Entity)leader).field_70161_v;
            float angle = (((Entity)leader).field_70177_z + 180.0f) * new Float(Math.PI).floatValue() / 180.0f;
            double straightDegree = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            double calculatedRotatedX = (double)(-MathHelper.func_76126_a((float)angle)) * straightDegree;
            double calculatedRotatedZ = (double)MathHelper.func_76134_b((float)angle) * straightDegree;
            double x = this.dragonBodyParts[i].field_70165_t;
            double y = this.dragonBodyParts[i].field_70163_u;
            double z = this.dragonBodyParts[i].field_70161_v;
            Vec3d deltaPos = new Vec3d(x - headerX, y - headerY, z - headerZ);
            deltaPos = deltaPos.func_72432_b();
            deltaPos = deltaPos.func_178787_e(new Vec3d(calculatedRotatedX, 0.0, calculatedRotatedZ).func_72432_b());
            double f = i != 0 ? 0.378 : 0.338;
            double targetX = headerX + f * deltaPos.field_72450_a;
            double targetY = headerY + f * deltaPos.field_72448_b;
            double targetZ = headerZ + f * deltaPos.field_72449_c;
            this.dragonBodyParts[i].func_70107_b(targetX, targetY, targetZ);
            double distance = MathHelper.func_76133_a((double)(deltaPos.field_72450_a * deltaPos.field_72450_a + deltaPos.field_72449_c * deltaPos.field_72449_c));
            this.dragonBodyParts[i].func_70101_b((float)(Math.atan2(deltaPos.field_72449_c, deltaPos.field_72450_a) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(deltaPos.field_72448_b, distance) * 180.0 / Math.PI)));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.destroyBlocksInAABB(this.func_174813_aQ().func_186662_g(0.5).func_191194_a(new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186678_a(1.5)));
        for (SubEntityNetherDragonSegment segment : this.dragonBodyParts) {
            if (segment == null) continue;
            this.destroyBlocksInAABB(segment.func_174813_aQ());
        }
        --this.fireballTimer;
        if (!this.field_70170_p.field_72995_K && this.phase > 1 && this.fireballTimer <= 0) {
            this.fireballTimer = CQRConfig.bosses.netherDragonStageTwoFireballInterval;
            this.shootFireballFromBody();
        }
        if (((Boolean)this.field_70180_af.func_187225_a(SPIT_FIRE)).booleanValue()) {
            this.breatheFire();
        }
    }

    @Override
    public double getAttackReach(EntityLivingBase target) {
        return super.getAttackReach(target) * (double)this.INITIAL_SEGMENT_COUNT;
    }

    public void shootFireballFromBody() {
        if (this.dragonBodyParts != null && this.dragonBodyParts.length > 0) {
            int indx = this.func_70681_au().nextInt(this.dragonBodyParts.length);
            while (this.dragonBodyParts[indx] == null) {
                indx = this.func_70681_au().nextInt(this.dragonBodyParts.length);
            }
            EntityCQRNetherDragon pre = indx == 0 ? this : this.dragonBodyParts[indx - 1];
            Vec3d v = this.dragonBodyParts[indx].func_174791_d();
            if (this.hasAttackTarget() && this.func_70681_au().nextDouble() > 0.6) {
                v = this.func_70638_az().func_174791_d().func_178788_d(v).func_72441_c(0.0, 0.5, 0.0);
            } else {
                int angle;
                v = pre.func_174791_d().func_178788_d(v);
                v = v.func_178787_e(new Vec3d(0.0, 1.0 - 2.0 * this.func_70681_au().nextDouble(), 0.0));
                if (this.func_70681_au().nextBoolean()) {
                    v = VectorUtil.rotateVectorAroundY(v, 45.0);
                    angle = this.func_70681_au().nextInt(61);
                    v = VectorUtil.rotateVectorAroundY(v, (double)angle);
                } else {
                    v = VectorUtil.rotateVectorAroundY(v, -45.0);
                    angle = -this.func_70681_au().nextInt(61);
                    v = VectorUtil.rotateVectorAroundY(v, (double)angle);
                }
            }
            v = v.func_72432_b();
            ProjectileHotFireball proj = new ProjectileHotFireball(this.field_70170_p, (EntityLivingBase)this, this.dragonBodyParts[indx].field_70165_t + v.field_72450_a, this.dragonBodyParts[indx].field_70163_u + v.field_72448_b, this.dragonBodyParts[indx].field_70161_v + v.field_72449_c);
            v = v.func_186678_a(1.5);
            proj.field_70159_w = v.field_72450_a;
            proj.field_70181_x = v.field_72448_b;
            proj.field_70179_y = v.field_72449_c;
            proj.field_70133_I = true;
            this.field_70170_p.func_72838_d((Entity)proj);
        }
    }

    public void breatheFire() {
        Vec3d look = this.func_70040_Z();
        double motionX = look.field_72450_a;
        double motionZ = look.field_72449_c;
        Vec3d flameStartPos = this.func_174791_d().func_178787_e(new Vec3d(motionX, 0.0, motionZ).func_186678_a((double)(this.field_70130_N / 2.0f) - 0.25).func_178786_a(0.0, 0.2, 0.0));
        flameStartPos = flameStartPos.func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0);
        Vec3d v = new Vec3d(motionX, 0.0, motionZ).func_186678_a(0.75);
        double ANGLE_MAX = 22.5;
        double MAX_LENGTH = 24.0;
        double angle = ANGLE_MAX / MAX_LENGTH;
        double dY = -0.05;
        v = VectorUtil.rotateVectorAroundY(v, -(ANGLE_MAX / 2.0));
        if (this.field_70170_p.field_72995_K) {
            int i = 0;
            while ((double)i <= MAX_LENGTH) {
                for (int iY = 0; iY <= 10; ++iY) {
                    Vec3d vOrig = v;
                    v = new Vec3d(v.field_72450_a, -0.15 + (double)iY * dY, v.field_72449_c).func_186678_a(1.5);
                    this.field_70170_p.func_175682_a(EnumParticleTypes.FLAME, true, flameStartPos.field_72450_a, flameStartPos.field_72448_b, flameStartPos.field_72449_c, v.field_72450_a * 0.5, v.field_72448_b * 0.5, v.field_72449_c * 0.5, new int[0]);
                    this.field_70170_p.func_175682_a(EnumParticleTypes.FLAME, true, flameStartPos.field_72450_a, flameStartPos.field_72448_b, flameStartPos.field_72449_c, v.field_72450_a, v.field_72448_b, v.field_72449_c, new int[0]);
                    v = vOrig;
                }
                v = VectorUtil.rotateVectorAroundY(v, angle);
                ++i;
            }
        } else {
            double currentLength;
            v = new Vec3d(motionX, 0.0, motionZ).func_186678_a(0.75);
            double angleTan = Math.tan(Math.toRadians(ANGLE_MAX / 2.0));
            int count = 9;
            double lengthIncr = currentLength = (MAX_LENGTH *= 1.25) / (double)count;
            for (int i = 0; i < count; ++i) {
                double r = angleTan * currentLength;
                Vec3d v2 = new Vec3d(v.field_72450_a, -0.4, v.field_72449_c).func_186678_a(currentLength - r);
                Vec3d pCenter = flameStartPos.func_178787_e(v2);
                AxisAlignedBB aabb = new AxisAlignedBB(pCenter.field_72450_a - r, pCenter.field_72448_b - r, pCenter.field_72449_c - r, pCenter.field_72450_a + r, pCenter.field_72448_b + r, pCenter.field_72449_c + r).func_186664_h(0.25);
                for (Entity ent : this.field_70170_p.func_175674_a((Entity)this, aabb, TargetUtil.createPredicateNonAlly(this.getFaction()))) {
                    ent.func_70015_d(8);
                    ent.func_70097_a(DamageSource.field_76370_b, 5.0f);
                }
                currentLength += lengthIncr;
            }
        }
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB aabb) {
        if (!CQRConfig.bosses.netherDragonDestroysBlocks || this.field_70128_L || this.func_82194_d().func_82736_K().func_82765_e("mobGriefing") && !this.func_82194_d().func_82736_K().func_82766_b("mobGriefing") || this.field_70170_p.field_72995_K) {
            return false;
        }
        int x1 = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int y1 = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int z1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int x2 = MathHelper.func_76128_c((double)aabb.field_72336_d);
        int y2 = MathHelper.func_76128_c((double)aabb.field_72337_e);
        int z2 = MathHelper.func_76128_c((double)aabb.field_72334_f);
        boolean cancelled = false;
        boolean blockDestroyed = false;
        for (int k1 = x1; k1 <= x2; ++k1) {
            for (int l1 = y1; l1 <= y2; ++l1) {
                for (int i2 = z1; i2 <= z2; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || iblockstate.func_185904_a() == Material.field_151581_o) continue;
                    if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        cancelled = true;
                        continue;
                    }
                    if (ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) {
                        boolean container;
                        boolean bl = container = block.hasTileEntity(iblockstate) && block.createTileEntity(this.field_70170_p, iblockstate).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                        if (breakableBlocks.contains(block.getRegistryName()) && !container && block.func_149703_v() && block != Blocks.field_150357_h && block != Blocks.field_185779_df && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_185775_db && block != Blocks.field_150384_bq && block != Blocks.field_150427_aO && block != CQRBlocks.PHYLACTERY && block != CQRBlocks.FORCE_FIELD_NEXUS && block != CQRBlocks.EXPORTER) {
                            blockDestroyed = this.field_70170_p.func_175698_g(blockpos) || blockDestroyed;
                            continue;
                        }
                        cancelled = true;
                        continue;
                    }
                    cancelled = true;
                }
            }
        }
        if (blockDestroyed) {
            double x = aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double y = aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double z = aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
        return cancelled;
    }

    @Override
    public void func_70071_h_() {
        if (this.phase == 1 && !this.field_70170_p.field_72995_K) {
            --this.phaseChangeTimer;
            if (this.phaseChangeTimer <= 0) {
                this.phaseChangeTimer = 2;
                for (int i = 0; i < this.dragonBodyParts.length; ++i) {
                    if (this.dragonBodyParts[i].isSkeletal()) continue;
                    this.dragonBodyParts[i].switchToSkeletalState();
                    if (this.field_70170_p.field_72995_K) break;
                    if (i == 0) {
                        this.field_70180_af.func_187227_b(SKELE_COUNT, (Object)1);
                        break;
                    }
                    this.field_70180_af.func_187227_b(SKELE_COUNT, (Object)(i + 1));
                    break;
                }
            }
            if (this.dragonBodyParts[this.dragonBodyParts.length - 1].isSkeletal()) {
                this.field_70180_af.func_187227_b(SKELE_COUNT, (Object)(this.dragonBodyParts.length + 1));
                ++this.phase;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70180_af.func_187227_b(PHASE, (Object)this.phase);
                }
            }
        }
        if (this.field_70170_p.field_72995_K && (Integer)this.field_70180_af.func_187225_a(PHASE) > this.phase) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFinalDeathSound(), SoundCategory.MASTER, 1.0f, 1.0f, false);
            ++this.phase;
        }
        if (!this.field_70170_p.field_72995_K && this.mouthTimer > 0) {
            --this.mouthTimer;
            this.field_70180_af.func_187227_b(MOUTH_OPEN, (Object)(this.mouthTimer > 0 ? 1 : 0));
            if (this.mouthTimer <= 0 && ((Boolean)this.field_70180_af.func_187225_a(SPIT_FIRE)).booleanValue()) {
                this.field_70180_af.func_187227_b(SPIT_FIRE, (Object)false);
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70148_d && this.dragonBodyParts.length > this.getSegmentCount()) {
            this.updateSegmentCount();
        }
        if (this.field_70170_p.field_72995_K) {
            this.lengthSyncClient();
        } else {
            if (this.phase > 1) {
                this.updateSegmentCount();
            }
            this.lengthSyncServer();
        }
        super.func_70071_h_();
        for (SubEntityNetherDragonSegment segment : this.dragonBodyParts) {
            if (segment == null) continue;
            this.field_70170_p.func_72866_a((Entity)segment, true);
            segment.func_70071_h_();
            if (this.phase != 2 || segment.isSkeletal() || this.field_70170_p.field_72995_K) continue;
            segment.switchToSkeletalState();
        }
        this.moveParts();
    }

    private void lengthSyncServer() {
        this.field_70180_af.func_187227_b(SERVER_PART_LENGTH, (Object)this.dragonBodyParts.length);
    }

    private void lengthSyncClient() {
        int serverLength = (Integer)this.field_70180_af.func_187225_a(SERVER_PART_LENGTH);
        if (serverLength > 0 && serverLength < this.dragonBodyParts.length) {
            SubEntityNetherDragonSegment[] partsTmp = new SubEntityNetherDragonSegment[serverLength];
            for (int i = 0; i < this.dragonBodyParts.length; ++i) {
                if (i < partsTmp.length) {
                    partsTmp[i] = this.dragonBodyParts[i];
                    continue;
                }
                this.field_70170_p.func_72900_e((Entity)this.dragonBodyParts[i]);
            }
            this.dragonBodyParts = partsTmp;
        }
    }

    private void updateSegmentCount() {
        if (!this.field_70170_p.field_72995_K) {
            double divisor = this.func_110138_aP() / (float)(this.INITIAL_SEGMENT_COUNT - this.SEGMENT_COUNT_ON_DEATH);
            int actualSegmentCount = (int)Math.floor((double)this.func_110143_aJ() / divisor) + this.SEGMENT_COUNT_ON_DEATH;
            if (actualSegmentCount < this.dragonBodyParts.length - 1) {
                this.removeLastSegment();
            }
            this.segmentCount = this.dragonBodyParts.length;
        }
    }

    public int getSkeleProgress() {
        return (Integer)this.field_70180_af.func_187225_a(SKELE_COUNT);
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        return CQRSounds.NETHER_DRAGON_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return CQRSounds.NETHER_DRAGON_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    public void func_70106_y() {
        super.func_70106_y();
        for (SubEntityNetherDragonSegment dragonPart : this.dragonBodyParts) {
            if (dragonPart == null) continue;
            dragonPart.onRemovedFromBody();
            this.field_70170_p.func_72973_f((Entity)dragonPart);
        }
    }

    public Entity[] func_70021_al() {
        return this.dragonBodyParts;
    }

    @Override
    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfoServer.func_186760_a(player);
    }

    @Override
    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfoServer.func_186761_b(player);
    }

    @Override
    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateDirectLine((EntityLiving)this, worldIn){

            public float func_111269_d() {
                return 128.0f;
            }
        };
    }

    @Override
    public int getHealingPotions() {
        return 0;
    }

    public void setMouthOpen(boolean open) {
        this.field_70180_af.func_187227_b(MOUTH_OPEN, (Object)open);
    }

    public boolean isMouthOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(MOUTH_OPEN);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(((Boolean)this.field_70180_af.func_187225_a(MOUTH_OPEN)).booleanValue());
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.field_70180_af.func_187227_b(MOUTH_OPEN, (Object)additionalData.readBoolean());
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_DRAGON_NETHER;
    }

    @Override
    public boolean canOpenDoors() {
        return false;
    }

    @Override
    public boolean canPutOutFire() {
        return false;
    }

    @Override
    public boolean canIgniteTorch() {
        return false;
    }

    @Override
    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ % 5 == 0) {
            if (this.dragonBodyParts.length > 0) {
                SubEntityNetherDragonSegment segment = this.dragonBodyParts[this.dragonBodyParts.length - 1];
                if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    this.dropExperience(MathHelper.func_76141_d((float)120.0f), segment.field_70165_t, segment.field_70163_u, segment.field_70161_v);
                    this.field_70170_p.func_72876_a((Entity)segment, segment.field_70165_t, segment.field_70163_u, segment.field_70161_v, 1.0f, false);
                    this.removeLastSegment();
                }
            } else {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFinalDeathSound(), SoundCategory.MASTER, 1.0f, 1.0f, false);
                this.onFinalDeath();
                this.func_70106_y();
            }
        }
    }

    private void dropExperience(int p_184668_1_, double x, double y, double z) {
        while (p_184668_1_ > 0) {
            int i = EntityXPOrb.func_70527_a((int)p_184668_1_);
            p_184668_1_ -= i;
            EntityXPOrb xp = new EntityXPOrb(this.field_70170_p, x, y, z, i);
            xp.func_184224_h(true);
            this.field_70170_p.func_72838_d((Entity)xp);
        }
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("segmentCount", this.segmentCount);
        compound.func_74768_a("phase", this.phase);
        compound.func_74768_a("skeleCount", this.getSkeleProgress());
        if (this.targetLocation != null) {
            compound.func_74782_a("targetLocation", (NBTBase)VectorUtil.createVectorNBTTag(this.targetLocation));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("segmentCount")) {
            this.segmentCount = compound.func_74762_e("segmentCount");
            this.field_70180_af.func_187227_b(SERVER_PART_LENGTH, (Object)this.segmentCount);
        }
        if (compound.func_74764_b("skeleCount")) {
            this.field_70180_af.func_187227_b(SKELE_COUNT, (Object)compound.func_74762_e("skeleCount"));
        }
        if (compound.func_74764_b("phase")) {
            this.phase = compound.func_74762_e("phase");
            this.field_70180_af.func_187227_b(PHASE, (Object)this.phase);
        }
        if (compound.func_74764_b("targetLocation")) {
            this.targetLocation = VectorUtil.getVectorFromTag(compound.func_74775_l("targetLocation"));
        }
    }

    @Override
    protected void onFinalDeath() {
        for (SubEntityNetherDragonSegment segment : this.dragonBodyParts) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.dropExperience(MathHelper.func_76141_d((float)120.0f), segment.field_70165_t, segment.field_70163_u, segment.field_70161_v);
            }
            this.field_70170_p.func_72876_a((Entity)segment, segment.field_70165_t, segment.field_70163_u, segment.field_70161_v, 1.0f, false);
            this.field_70170_p.func_72973_f((Entity)segment);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.dropExperience(MathHelper.func_76141_d((float)800.0f), this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false);
    }

    @Override
    public EnumParticleTypes getDeathAnimParticles() {
        return EnumParticleTypes.LAVA;
    }

    @Override
    public BlockPos getCirclingCenter() {
        if (this.getHomePositionCQR() == null) {
            this.setHomePositionCQR(this.func_180425_c());
        }
        return this.getHomePositionCQR();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        EntityUtil.move3D((Entity)this, strafe, vertical, forward, this.func_70605_aq().func_75638_b(), this.field_70177_z, this.field_70125_A);
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.9;
        this.field_70181_x *= 0.9;
        this.field_70179_y *= 0.9;
        this.field_70133_I = true;
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Nullable
    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(Vec3d newTarget) {
        this.targetLocation = newTarget;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.phase > 0 ? EnumCreatureAttribute.UNDEAD : EnumCreatureAttribute.UNDEFINED;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    @Override
    protected boolean canHealWhenIdling() {
        return this.phase == 0;
    }
}

