/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.spectrelord;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.ai.boss.spectrelord.EntityAISpectreLordIllusionExplosion;
import team.cqr.cqrepoured.entity.ai.boss.spectrelord.EntityAISpectreLordIllusionHeal;
import team.cqr.cqrepoured.entity.boss.spectrelord.EntityCQRSpectreLord;
import team.cqr.cqrepoured.entity.mobs.EntityCQRSpectre;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.faction.FactionRegistry;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.util.EntityUtil;

public class EntitySpectreLordIllusion
extends EntityCQRSpectre {
    private EntityLivingBase caster;
    private int lifeTime;
    private boolean canCastHeal;
    private boolean canCastExplosion;

    public EntitySpectreLordIllusion(World worldIn) {
        this(worldIn, null, 200, false, false);
    }

    public EntitySpectreLordIllusion(World worldIn, EntityLivingBase caster, int lifeTime, boolean canCastHeal, boolean canCastExplosion) {
        super(worldIn);
        if (caster != null) {
            this.caster = caster;
            Faction faction = FactionRegistry.instance((Entity)this).getFactionOf((Entity)caster);
            if (faction != null) {
                this.setFaction(faction.getName(), true);
            }
        }
        this.lifeTime = lifeTime;
        this.canCastHeal = canCastHeal;
        this.canCastExplosion = canCastExplosion;
        if (canCastHeal) {
            this.spellHandler.addSpell(0, new EntityAISpectreLordIllusionHeal(this, 160, 40));
        }
        if (canCastExplosion) {
            this.spellHandler.addSpell(0, new EntityAISpectreLordIllusionExplosion(this, 160, 40));
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        if (this.field_70146_Z.nextDouble() < 0.3) {
            switch (this.field_70146_Z.nextInt(3)) {
                case 0: {
                    this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(CQRItems.SPEAR_IRON));
                    break;
                }
                case 1: {
                    this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(CQRItems.DAGGER_IRON));
                    break;
                }
                case 2: {
                    this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(CQRItems.GREAT_SWORD_IRON));
                }
            }
        } else {
            this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151040_l));
        }
        this.setHealingPotions(0);
        return livingdata;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.225);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.canCastHeal || this.canCastExplosion ? 8.0 : 12.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(this.canCastHeal || this.canCastExplosion ? 4.0 : 6.0);
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && this.lifeTime-- <= 0) {
            this.func_70106_y();
        }
        super.func_70030_z();
    }

    @Override
    public float getBaseHealth() {
        return 20.0f;
    }

    @Override
    public boolean canPutOutFire() {
        return false;
    }

    @Override
    public boolean canIgniteTorch() {
        return false;
    }

    @Override
    public boolean canTameEntity() {
        return false;
    }

    @Override
    public boolean canMountEntity() {
        return false;
    }

    @Override
    protected boolean func_146066_aG() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.caster != null && this.caster.func_70089_S()) {
            compound.func_186854_a("Summoner", this.caster.getPersistentID());
        }
        compound.func_74768_a("lifeTime", this.lifeTime);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        UUID uuid;
        Entity e;
        super.func_70037_a(compound);
        if (compound.func_150297_b("SummonerMost", 4) && (e = EntityUtil.getEntityByUUID(this.field_70170_p, uuid = compound.func_186857_a("Summoner"))) instanceof EntityCQRSpectreLord) {
            this.caster = (EntityCQRSpectreLord)e;
        }
        this.lifeTime = compound.func_74762_e("lifeTime");
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.caster != null) {
            this.caster.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), this.caster.func_110138_aP() * 0.025f);
        }
    }
}

