/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.misc;

import com.google.common.base.Predicates;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.Capes;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.boss.EntityCQRWalkerKing;
import team.cqr.cqrepoured.entity.mobs.EntityCQRWalker;
import team.cqr.cqrepoured.init.CQRCreatureAttributes;

public class EntityWalkerKingIllusion
extends EntityCQRWalker {
    private EntityCQRWalkerKing parent;
    private int ttl = 1200;
    private int searchTicksForParent = 20;
    private int damageCounter = 0;
    private UUID parentUUID = null;

    public EntityWalkerKingIllusion(World worldIn) {
        super(worldIn);
    }

    public EntityWalkerKingIllusion(int ttl, EntityCQRWalkerKing parent, World world) {
        this(world);
        this.parent = parent;
        this.ttl = ttl;
        this.parentUUID = parent.getPersistentID();
        this.cloneParentEquipment(parent);
    }

    private void cloneParentEquipment(AbstractEntityCQR parent) {
        this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, parent.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.POTION));
        this.func_184201_a(EntityEquipmentSlot.CHEST, parent.func_184582_a(EntityEquipmentSlot.CHEST));
        this.func_184201_a(EntityEquipmentSlot.HEAD, parent.func_184582_a(EntityEquipmentSlot.HEAD));
        this.func_184201_a(EntityEquipmentSlot.LEGS, parent.func_184582_a(EntityEquipmentSlot.LEGS));
        this.func_184201_a(EntityEquipmentSlot.FEET, parent.func_184582_a(EntityEquipmentSlot.FEET));
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, parent.func_184582_a(EntityEquipmentSlot.OFFHAND));
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(parent.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b(), 1));
    }

    @Override
    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enpty");
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.parent != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.parent.func_110138_aP());
            this.func_70606_j(this.parent.func_110143_aJ());
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.damageCounter >= 2 * (this.field_70170_p.func_175659_aa().ordinal() <= 0 ? 1 : this.field_70170_p.func_175659_aa().ordinal())) {
            this.func_70106_y();
        }
        ++this.damageCounter;
        return true;
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            this.playDeathEffect();
        }
        super.func_70106_y();
    }

    private void playDeathEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.025, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.025, 0.01, 0.025, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.025, 0.01, -0.025, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, -0.025, 0.01, 0.025, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, -0.025, 0.01, -0.025, new int[0]);
            }
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.AMBIENT, 2.0f, 0.75f, true);
        }
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.ttl < 0) {
                this.func_70106_y();
                return;
            }
            if (this.parent == null && this.parentUUID != null) {
                if (this.searchTicksForParent > 0) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_180425_c().func_177982_a(-10, -10, -10), this.func_180425_c().func_177982_a(10, 10, 10)), Predicates.instanceOf(EntityCQRWalkerKing.class)).forEach(t -> {
                            if (t.getPersistentID().equals(this.parentUUID)) {
                                this.parent = (EntityCQRWalkerKing)t;
                            }
                        });
                        --this.searchTicksForParent;
                    }
                } else {
                    this.func_70106_y();
                    return;
                }
            }
            if (this.parent == null || this.parent.field_70128_L) {
                this.func_70106_y();
                return;
            }
            super.func_70030_z();
            this.func_70606_j(this.parent.func_110143_aJ());
            this.ttl = this.parent.func_70638_az() != null || this.func_70638_az() != null ? --this.ttl : (this.ttl -= 10);
        } else {
            super.func_70030_z();
        }
    }

    @Override
    public ResourceLocation getResourceLocationOfCape() {
        return Capes.CAPE_WALKER;
    }

    @Override
    public boolean hasCape() {
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ttl", this.ttl);
        compound.func_74782_a("illusionParent", (NBTBase)NBTUtil.func_186862_a((UUID)this.parentUUID));
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.ttl = compound.func_74762_e("ttl");
        this.parentUUID = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("illusionParent"));
    }

    @Override
    public EnumCreatureAttribute func_70668_bt() {
        return CQRCreatureAttributes.VOID;
    }
}

