/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.entity.IDontRenderFire;
import team.cqr.cqrepoured.entity.particle.EntityParticle;
import team.cqr.cqrepoured.entity.particle.ParticleWalkerTornado;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.faction.FactionRegistry;

public class EntityWalkerTornado
extends Entity
implements IEntityOwnable,
IDontRenderFire {
    protected static final int PARTICLE_COUNT = 2;
    protected static final int MAX_LIVING_TICKS = 200;
    protected final List<EntityParticle> particles = new ArrayList<EntityParticle>();
    protected Vec3d velocity = new Vec3d(0.0, 0.0, 0.0);
    protected Entity owner = null;
    public static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityWalkerTornado.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> OWNER_ID = EntityDataManager.func_187226_a(EntityWalkerTornado.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityWalkerTornado(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)4980889);
        this.field_70180_af.func_187214_a(OWNER_ID, (Object)"");
    }

    public void func_70071_h_() {
        Entity ent;
        super.func_70071_h_();
        if (this.field_70173_aa >= 200) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateParticles();
        } else {
            this.handleNearbyEntities();
        }
        if (this.func_184753_b() != null && this.owner == null && this.field_70173_aa % 10 == 0 && this.field_70170_p instanceof WorldServer && (ent = ((WorldServer)this.field_70170_p).func_175733_a(this.func_184753_b())).func_70089_S()) {
            this.owner = ent;
        }
        this.func_70091_d(MoverType.SELF, this.velocity.field_72450_a, this.velocity.field_72448_b, this.velocity.field_72449_c);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateParticles() {
        Integer color = this.getColor();
        for (int k = 0; k < 4; ++k) {
            double d1 = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 0.25f;
            double d2 = (float)this.field_70163_u + this.field_70131_O + 0.125f;
            double d3 = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 0.25f;
            float f = this.field_70146_Z.nextFloat() * 360.0f;
            ParticleWalkerTornado particle = new ParticleWalkerTornado(this.field_70170_p, -Math.sin(0.01745329f * f) * 0.75, d2 - 0.25, Math.cos(0.01745329f * f) * 0.75, d1, 0.125, d3);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)particle);
            this.particles.add(particle);
            particle.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            particle.func_187109_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        for (int i2 = 0; i2 < this.particles.size(); ++i2) {
            EntityParticle particle3 = this.particles.get(i2);
            if (!particle3.func_187113_k()) {
                this.particles.remove((Object)particle3);
                --i2;
                continue;
            }
            double d7 = particle3.getX();
            double d8 = particle3.func_187116_l().field_72338_b;
            double d9 = particle3.getZ();
            double d10 = this.getDistanceToParticle(particle3);
            double d11 = d8 - this.field_70163_u;
            particle3.setMotionY(0.115f);
            double d12 = Math.atan2(this.field_70165_t - d7, this.field_70161_v - d9) / 0.01745329424738884;
            particle3.setMotionX(-Math.cos(0.01745329424738884 * (d12 += 160.0)) * (d10 * 2.5 - d11) * (double)0.1f);
            particle3.setMotionZ(Math.sin(0.01745329424738884 * d12) * (d10 * 2.5 - d11) * (double)0.1f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getDistanceToParticle(EntityParticle particle) {
        float f = (float)(this.field_70165_t - particle.getX());
        float f2 = (float)(this.field_70163_u - particle.getY());
        float f3 = (float)(this.field_70161_v - particle.getZ());
        return MathHelper.func_76129_c((float)(f * f + f2 * f2 + f3 * f3));
    }

    private void handleNearbyEntities() {
        double r = 0.75;
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - r, this.field_70163_u, this.field_70161_v - r, this.field_70165_t + r, this.field_70163_u + 2.0 * r, this.field_70161_v + r);
        List list = this.field_70170_p.func_72839_b((Entity)this, aabb);
        for (Entity ent : list) {
            this.collideWithEntity(ent);
        }
    }

    protected void collideWithEntity(Entity entityIn) {
        if (this.isEntityAffected(entityIn)) {
            Vec3d vAway = entityIn.func_174791_d().func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(1.25);
            vAway = vAway.func_72441_c(0.0, vAway.field_72448_b * 0.1, 0.0);
            entityIn.field_70159_w = vAway.field_72450_a * 0.75;
            entityIn.field_70181_x = Math.max(Math.abs(vAway.field_72448_b), 0.6);
            entityIn.field_70179_y = vAway.field_72449_c * 0.75;
            entityIn.field_70133_I = true;
        }
    }

    private boolean isEntityAffected(Entity ent) {
        if (ent instanceof EntityWalkerTornado) {
            return false;
        }
        if (this.func_184753_b() != null) {
            if (ent.getPersistentID().equals(this.func_184753_b())) {
                return false;
            }
            Faction faction = FactionRegistry.instance(this).getFactionOf(this.owner);
            if (faction != null) {
                return !faction.isAlly(ent);
            }
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound compound) {
        if (this.func_184753_b() != null) {
            compound.func_74782_a("summoner", (NBTBase)NBTUtil.func_186862_a((UUID)this.func_184753_b()));
        }
        compound.func_74780_a("vX", this.velocity.field_72450_a);
        compound.func_74780_a("vY", this.velocity.field_72448_b);
        compound.func_74780_a("vZ", this.velocity.field_72449_c);
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("summoner")) {
            this.setOwner(NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("summoner")));
        }
        double x = compound.func_74769_h("vX");
        double y = compound.func_74769_h("vY");
        double z = compound.func_74769_h("vZ");
        this.velocity = new Vec3d(x, y, z);
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
    }

    public void setVelocity(Vec3d v) {
        this.velocity = v;
    }

    public void setOwner(UUID ownerID) {
        this.field_70180_af.func_187227_b(OWNER_ID, (Object)ownerID.toString());
    }

    public UUID func_184753_b() {
        if (this.field_70180_af.func_187225_a(OWNER_ID) != null && !((String)this.field_70180_af.func_187225_a(OWNER_ID)).isEmpty()) {
            return UUID.fromString((String)this.field_70180_af.func_187225_a(OWNER_ID));
        }
        return null;
    }

    public void setColor(int value) {
        this.field_70180_af.func_187227_b(COLOR, (Object)value);
    }

    private Integer getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public Entity func_70902_q() {
        return this.owner;
    }
}

