/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.mobs.EntityCQREnderman;
import team.cqr.cqrepoured.entity.projectiles.ProjectileBase;

public class ProjectileHomingEnderEye
extends ProjectileBase {
    private Entity target = null;
    private EntityLivingBase shooter = null;

    public ProjectileHomingEnderEye(World worldIn) {
        super(worldIn);
    }

    public ProjectileHomingEnderEye(World worldIn, EntityLivingBase shooter, Entity target) {
        super(worldIn, shooter);
        this.shooter = shooter;
        this.target = target;
        this.field_70178_ae = true;
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184481_a(this.shooter);
            entityareaeffectcloud.func_184491_a(EnumParticleTypes.DRAGON_BREATH);
            entityareaeffectcloud.func_184483_a(2.0f);
            entityareaeffectcloud.func_184486_b(200);
            entityareaeffectcloud.func_184495_b(-0.25f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76433_i, 20, 1));
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.field_70170_p.func_72876_a((Entity)this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
                this.func_70106_y();
            } else if (result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g != null && result.field_72308_g != this.shooter && !(result.field_72308_g instanceof MultiPartEntityPart)) {
                this.applyEntityCollisionEye(result.field_72308_g);
            }
        }
        super.func_70184_a(result);
    }

    public void applyEntityCollisionEye(Entity entityIn) {
        boolean hitTarget;
        if (entityIn == null) {
            return;
        }
        if (entityIn == this.shooter) {
            return;
        }
        if (entityIn instanceof ProjectileBase || entityIn instanceof EntityEnderman || entityIn instanceof EntityCQREnderman) {
            return;
        }
        boolean bl = hitTarget = this.target != null && entityIn != this.shooter;
        if (hitTarget) {
            this.field_70170_p.func_72876_a((Entity)this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
            this.func_70106_y();
        }
        if (this.shooter != null) {
            entityIn.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.shooter), (float)(2 + this.field_70170_p.func_175659_aa().func_151525_a()));
        }
    }

    @Override
    protected void onUpdateInAir() {
        super.onUpdateInAir();
        if (this.field_70173_aa > 400 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72876_a((Entity)this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.target != null) {
            Vec3d v = this.target.func_174791_d().func_178788_d(this.func_174791_d());
            v = v.func_72432_b();
            v = v.func_186678_a(0.2);
            this.field_70159_w = v.field_72450_a;
            this.field_70181_x = v.field_72448_b;
            this.field_70179_y = v.field_72449_c;
            this.field_70133_I = true;
        }
    }
}

