/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.projectiles;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.projectiles.ProjectileBase;

public class ProjectileThrownBlock
extends ProjectileBase
implements IEntityAdditionalSpawnData {
    private ResourceLocation block = Blocks.field_150377_bs.getRegistryName();
    private IBlockState state = null;
    private boolean placeOnImpact = false;

    public ProjectileThrownBlock(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    private ProjectileThrownBlock(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.func_70105_a(1.0f, 1.0f);
    }

    public ProjectileThrownBlock(World worldIn, EntityLivingBase shooter, IBlockState block, boolean placeOnImpact) {
        super(worldIn, shooter);
        this.block = block.func_177230_c().getRegistryName();
        this.placeOnImpact = placeOnImpact;
        this.state = block;
        this.func_70105_a(1.0f, 1.0f);
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.block.toString());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.block = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)additionalData));
        this.state = ((Block)Block.field_149771_c.func_82594_a((Object)this.block)).func_176223_P();
    }

    public IBlockState getBlock() {
        return this.state != null ? this.state : Blocks.field_150357_h.func_176223_P();
    }

    @Override
    public boolean func_189652_ae() {
        return false;
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (result.field_72308_g == this.field_70192_c) {
                return;
            }
            if (result.field_72308_g instanceof MultiPartEntityPart && ((MultiPartEntityPart)result.field_72308_g).field_70259_a == this.field_70192_c) {
                return;
            }
            result.field_72308_g.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.field_70192_c), 10.0f);
            this.func_70106_y();
            return;
        }
        if (CQRConfig.bosses.thrownBlocksGetPlaced && this.placeOnImpact) {
            this.field_70170_p.func_175656_a(new BlockPos(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c), this.state);
            if (this.field_70170_p instanceof WorldServer) {
                WorldServer ws = (WorldServer)this.field_70170_p;
                Vec3d pos = result.field_72307_f;
                double particleSpeed = 0.2;
                for (int i = 0; i < 50; ++i) {
                    double dx = -0.5 + this.field_70146_Z.nextDouble();
                    double dy = -0.5 + this.field_70146_Z.nextDouble();
                    double dz = -0.5 + this.field_70146_Z.nextDouble();
                    ws.func_175688_a(EnumParticleTypes.BLOCK_CRACK, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dx *= particleSpeed, dy *= particleSpeed, dz *= particleSpeed, new int[]{Block.func_176210_f((IBlockState)this.state)});
                }
                this.func_184185_a(this.state.func_177230_c().getSoundType(this.state, this.field_70170_p, this.func_180425_c(), (Entity)this).func_185841_e(), 1.5f, 1.25f);
            }
        }
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound compound) {
        NBTTagCompound blockstate = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)blockstate, (IBlockState)this.state);
        compound.func_74782_a("blockdata", (NBTBase)blockstate);
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        try {
            NBTTagCompound blockstate = compound.func_74775_l("blockdata");
            this.state = NBTUtil.func_190008_d((NBTTagCompound)blockstate);
        }
        catch (Exception ex) {
            this.state = Blocks.field_150377_bs.func_176223_P();
        }
        super.func_70037_a(compound);
    }
}

