/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.event.item;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import team.cqr.cqrepoured.capability.armor.CapabilityCooldownHandlerHelper;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.item.armor.ItemArmorTurtle;
import team.cqr.cqrepoured.util.ItemUtil;

@Mod.EventBusSubscriber(modid="cqrepoured")
public class TurtleArmorEventHandler {
    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (ItemUtil.hasFullSet(entity, ItemArmorTurtle.class) && !entity.field_70170_p.field_72995_K && entity.field_70173_aa % 100 == 0) {
            entity.func_70691_i(1.0f);
            double x = entity.field_70165_t;
            double y = entity.field_70163_u + (double)entity.func_70047_e();
            double z = entity.field_70161_v;
            ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.HEART, x, y, z, 2, 0.5, 0.5, 0.5, 1.0, new int[0]);
        }
    }

    @SubscribeEvent
    public static void onLivingDamageEvent(LivingDamageEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!ItemUtil.hasFullSet(entity, ItemArmorTurtle.class)) {
            return;
        }
        if (CapabilityCooldownHandlerHelper.onCooldown(entity, CQRItems.CHESTPLATE_TURTLE)) {
            return;
        }
        if (entity.func_110143_aJ() - event.getAmount() > entity.func_110138_aP() * 0.2f) {
            return;
        }
        event.setAmount(Math.min(event.getAmount(), entity.func_110143_aJ() - 1.0f));
        entity.func_70691_i(entity.func_110138_aP() * 0.2f);
        entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0, false, true));
        entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 4, false, true));
        entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 100, 1, false, true));
        double x = entity.field_70165_t;
        double y = entity.field_70163_u + (double)entity.func_70047_e();
        double z = entity.field_70161_v;
        ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.HEART, x, y, z, 4, 0.5, 0.5, 0.5, 1.0, new int[0]);
        entity.field_70170_p.func_184148_a(null, x, y, z, SoundEvents.field_187664_bz, SoundCategory.PLAYERS, 0.6f, 1.2f);
        CapabilityCooldownHandlerHelper.setCooldown(entity, CQRItems.CHESTPLATE_TURTLE, 12000);
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == CQRItems.CHESTPLATE_TURTLE && source.func_188404_v() != null) {
            double y;
            double pitch;
            Vec3d hitVec = source.func_188404_v();
            double x = entity.field_70165_t - hitVec.field_72450_a;
            double z = entity.field_70161_v - hitVec.field_72449_c;
            double yaw = Math.toDegrees(Math.atan2(-x, z));
            if (ItemUtil.compareRotations(entity.field_70761_aq, yaw, 45.0) && ItemUtil.compareRotations(0.0, pitch = -Math.toDegrees(Math.asin(y = entity.field_70163_u + (double)entity.field_70131_O * 0.5 - hitVec.field_72448_b)), 60.0)) {
                if (!entity.field_70170_p.field_72995_K) {
                    entity.field_70170_p.func_184148_a(null, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, SoundEvents.field_187767_eL, SoundCategory.NEUTRAL, 0.5f, 0.8f);
                }
                event.setAmount(event.getAmount() * 0.5f);
            }
        }
    }
}

