/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.init;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;

public class CQRLoottables {
    private static final Set<ResourceLocation> LOOT_TABLES = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CHEST_LOOT_TABLES = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> ENTITY_LOOT_TABLES = new HashSet<ResourceLocation>();
    public static final ResourceLocation ENTITIES_BOARMAN = CQRLoottables.createEntityLootTable("boarman");
    public static final ResourceLocation ENTITIES_DWARF = CQRLoottables.createEntityLootTable("dwarf");
    public static final ResourceLocation ENTITIES_ENDERMAN = CQRLoottables.createEntityLootTable("enderman");
    public static final ResourceLocation ENTITIES_GOBLIN = CQRLoottables.createEntityLootTable("goblin");
    public static final ResourceLocation ENTITIES_GOLEM = CQRLoottables.createEntityLootTable("golem");
    public static final ResourceLocation ENTITIES_GREMLIN = CQRLoottables.createEntityLootTable("gremlin");
    public static final ResourceLocation ENTITIES_HUMAN = CQRLoottables.createEntityLootTable("human");
    public static final ResourceLocation ENTITIES_ILLAGER = CQRLoottables.createEntityLootTable("illager");
    public static final ResourceLocation ENTITIES_MANDRIL = CQRLoottables.createEntityLootTable("mandril");
    public static final ResourceLocation ENTITIES_MINOTAUR = CQRLoottables.createEntityLootTable("minotaur");
    public static final ResourceLocation ENTITIES_MUMMY = CQRLoottables.createEntityLootTable("mummy");
    public static final ResourceLocation ENTITIES_NPC = CQRLoottables.createEntityLootTable("npc");
    public static final ResourceLocation ENTITIES_OGRE = CQRLoottables.createEntityLootTable("ogre");
    public static final ResourceLocation ENTITIES_ORC = CQRLoottables.createEntityLootTable("orc");
    public static final ResourceLocation ENTITIES_PIRATE = CQRLoottables.createEntityLootTable("pirate");
    public static final ResourceLocation ENTITIES_SKELETON = CQRLoottables.createEntityLootTable("skeleton");
    public static final ResourceLocation ENTITIES_SPECTRE = CQRLoottables.createEntityLootTable("spectre");
    public static final ResourceLocation ENTITIES_TRITON = CQRLoottables.createEntityLootTable("triton");
    public static final ResourceLocation ENTITIES_WALKER = CQRLoottables.createEntityLootTable("walker");
    public static final ResourceLocation ENTITIES_ZOMBIE = CQRLoottables.createEntityLootTable("zombie");
    public static final ResourceLocation ENTITIES_BEE = CQRLoottables.createEntityLootTable("mounts/bee");
    public static final ResourceLocation ENTITIES_GIANT_ENDERMITE = CQRLoottables.createEntityLootTable("mounts/endermite");
    public static final ResourceLocation ENTITIES_POLLO = CQRLoottables.createEntityLootTable("mounts/pollo");
    public static final ResourceLocation ENTITIES_GIANT_SILVERFISH_GREEN = CQRLoottables.createEntityLootTable("mounts/silverfish_green");
    public static final ResourceLocation ENTITIES_GIANT_SILVERFISH_RED = CQRLoottables.createEntityLootTable("mounts/silverfish_red");
    public static final ResourceLocation ENTITIES_GIANT_SILVERFISH = CQRLoottables.createEntityLootTable("mounts/silverfish");
    public static final ResourceLocation ENTITIES_BOARMAGE = CQRLoottables.createEntityLootTable("bosses/boar_mage");
    public static final ResourceLocation ENTITIES_BULL_ICE = CQRLoottables.createEntityLootTable("bosses/bull_ice");
    public static final ResourceLocation ENTITIES_BULL = CQRLoottables.createEntityLootTable("bosses/bull");
    public static final ResourceLocation ENTITIES_DRAGON_LAND = CQRLoottables.createEntityLootTable("bosses/dragon_land");
    public static final ResourceLocation ENTITIES_DRAGON_NETHER = CQRLoottables.createEntityLootTable("bosses/dragon_nether");
    public static final ResourceLocation ENTITIES_DRAGON = CQRLoottables.createEntityLootTable("bosses/dragon_normal");
    public static final ResourceLocation ENTITIES_DWARF_ENGINEER = CQRLoottables.createEntityLootTable("bosses/dwarf_engineer");
    public static final ResourceLocation ENTITIES_ENDER_CALAMITY = CQRLoottables.createEntityLootTable("bosses/ender_calamity");
    public static final ResourceLocation ENTITIES_TURTLE = CQRLoottables.createEntityLootTable("bosses/giant_turtle");
    public static final ResourceLocation ENTITIES_GOBLIN_SHAMAN = CQRLoottables.createEntityLootTable("bosses/goblin_shaman");
    public static final ResourceLocation ENTITIES_EXTERMINATOR = CQRLoottables.createEntityLootTable("bosses/golem_bosses");
    public static final ResourceLocation ENTITIES_LICH = CQRLoottables.createEntityLootTable("bosses/lich");
    public static final ResourceLocation ENTITIES_MONKING = CQRLoottables.createEntityLootTable("bosses/monking");
    public static final ResourceLocation ENTITIES_NECROMANCER = CQRLoottables.createEntityLootTable("bosses/necromancer");
    public static final ResourceLocation ENTITIES_PHARAO = CQRLoottables.createEntityLootTable("bosses/pharao");
    public static final ResourceLocation ENTITIES_PIRATE_CAPTAIN = CQRLoottables.createEntityLootTable("bosses/pirate_captain");
    public static final ResourceLocation ENTITIES_SECRET = CQRLoottables.createEntityLootTable("bosses/secret_bosses");
    public static final ResourceLocation ENTITIES_SPIDER = CQRLoottables.createEntityLootTable("bosses/shelob");
    public static final ResourceLocation ENTITIES_SLIME = CQRLoottables.createEntityLootTable("bosses/slime_frog");
    public static final ResourceLocation ENTITIES_SPECTRE_LORD = CQRLoottables.createEntityLootTable("bosses/spectre_lord");
    public static final ResourceLocation ENTITIES_SPHINX = CQRLoottables.createEntityLootTable("bosses/sphinx_bosses");
    public static final ResourceLocation ENTITIES_WALKER_KING = CQRLoottables.createEntityLootTable("bosses/walker_king");
    public static final ResourceLocation ENTITIES_WALKER_QUEEN = CQRLoottables.createEntityLootTable("bosses/walker_queen");
    public static final ResourceLocation CHESTS_TREASURE = CQRLoottables.createChestLootTable("treasure");
    public static final ResourceLocation CHESTS_EQUIPMENT = CQRLoottables.createChestLootTable("equipment");
    public static final ResourceLocation CHESTS_FOOD = CQRLoottables.createChestLootTable("food");
    public static final ResourceLocation CHESTS_MATERIAL = CQRLoottables.createChestLootTable("material");
    public static final ResourceLocation CHESTS_CLUTTER = CQRLoottables.createChestLootTable("clutter");

    public static ResourceLocation createChestLootTable(String name) {
        ResourceLocation loc = CQRLoottables.createLootTable("chests/" + name);
        CHEST_LOOT_TABLES.add(loc);
        return loc;
    }

    public static ResourceLocation createEntityLootTable(String name) {
        ResourceLocation loc = CQRLoottables.createLootTable("entities/" + name);
        ENTITY_LOOT_TABLES.add(loc);
        return loc;
    }

    public static ResourceLocation createLootTable(String name) {
        ResourceLocation lootTable = new ResourceLocation("cqrepoured", name);
        LOOT_TABLES.add(lootTable);
        return lootTable;
    }

    public static void registerLootTables() {
        for (ResourceLocation lootTable : LOOT_TABLES) {
            LootTableList.func_186375_a((ResourceLocation)lootTable);
        }
    }

    public static Set<ResourceLocation> getLootTables() {
        return Collections.unmodifiableSet(LOOT_TABLES);
    }

    public static Set<ResourceLocation> getChestLootTables() {
        return Collections.unmodifiableSet(CHEST_LOOT_TABLES);
    }

    public static Set<ResourceLocation> getEntityLootTables() {
        return Collections.unmodifiableSet(ENTITY_LOOT_TABLES);
    }
}

