/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.integration.ebwizardry;

import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

public class EntityAICastSpell
extends AbstractCQREntityAI<AbstractEntityCQR> {
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int useTick = -1;
    private SpellModifiers modifiers;

    public EntityAICastSpell(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(3);
    }

    protected boolean hasSpell() {
        Spell[] spells = WandHelper.getSpells((ItemStack)this.entity.func_184614_ca());
        if (spells.length == 0) {
            return false;
        }
        return Arrays.stream(spells).anyMatch(spell -> spell != null && spell != Spells.none);
    }

    public boolean func_75250_a() {
        if (!this.hasSpell()) {
            return false;
        }
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (attackTarget == null) {
            return false;
        }
        return this.entity.func_70635_at().func_75522_a((Entity)attackTarget);
    }

    public boolean func_75253_b() {
        if (!this.hasSpell()) {
            return false;
        }
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (attackTarget == null) {
            return false;
        }
        return this.entity.getLastTimeSeenAttackTarget() + 100 >= this.entity.field_70173_aa;
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        if (this.isCasting()) {
            ItemStack stack = this.entity.func_184614_ca();
            Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
            int chargeup = (int)((float)spell.getChargeup() * this.modifiers.get("chargeup"));
            int castingTick = this.useTick - chargeup;
            if (spell.isContinuous && castingTick >= 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Finish(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)this.entity, this.modifiers, castingTick));
                spell.finishCasting(this.world, (EntityLivingBase)this.entity, Double.NaN, Double.NaN, Double.NaN, null, castingTick, this.modifiers);
                this.entity.setContinuousSpell(Spells.none);
                PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(this.entity.func_145782_y(), -1, EnumHand.MAIN_HAND, Spells.none, new SpellModifiers());
                WizardryPacketHandler.net.sendToAllTracking((IMessage)msg, (Entity)this.entity);
                EntityAICastSpell.setCooldown(stack, spell, this.entity, this.modifiers, CQRConfig.wizardry.minCooldown, CQRConfig.wizardry.maxCooldown);
            }
            this.stopCasting();
        }
        this.entity.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (attackTarget == null) {
            return;
        }
        double distanceSq = this.entity.func_70068_e((Entity)attackTarget);
        double attackRangeSq = CQRConfig.wizardry.range * CQRConfig.wizardry.range;
        if (this.entity.func_70635_at().func_75522_a((Entity)attackTarget) && (distanceSq < attackRangeSq * 0.9 * 0.9 || distanceSq < attackRangeSq && !this.entity.func_70781_l())) {
            this.entity.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
            this.checkAndPerformAttack(attackTarget);
            this.entity.func_70661_as().func_75499_g();
            ++this.strafingTime;
        } else {
            this.entity.func_70661_as().func_75497_a((Entity)attackTarget, 1.0);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if (this.random.nextDouble() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if (this.random.nextDouble() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.canStrafe() && this.strafingTime > -1) {
            if (distanceSq > attackRangeSq * 0.75 * 0.75) {
                this.strafingBackwards = false;
            } else if (distanceSq < attackRangeSq * 0.25 * 0.25) {
                this.strafingBackwards = true;
            }
            float f = this.getStrafingSpeed();
            this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -f : f, this.strafingClockwise ? f : -f);
        }
    }

    protected float getStrafingSpeed() {
        return (float)(this.entity.func_184222_aU() ? CQRConfig.mobs.entityStrafingSpeed : CQRConfig.mobs.entityStrafingSpeedBoss);
    }

    protected boolean canStrafe() {
        if (!this.entity.canStrafe()) {
            return false;
        }
        return this.entity.func_184222_aU() ? CQRConfig.mobs.enableEntityStrafing : CQRConfig.mobs.enableEntityStrafingBoss;
    }

    protected void checkAndPerformAttack(EntityLivingBase attackTarget) {
        Spell spell;
        int chargeup;
        ItemStack stack = this.entity.func_184614_ca();
        if (!this.isCasting() && stack.func_77973_b() instanceof ItemWand) {
            Spell[] spells = WandHelper.getSpells((ItemStack)stack);
            int[] cooldowns = WandHelper.getCooldowns((ItemStack)stack);
            for (int i : IntArrays.shuffle((int[])IntStream.range(0, spells.length).toArray(), (Random)this.random)) {
                SpellModifiers modifiers;
                Spell spell2 = spells[i];
                if (spell2 == null || spell2 == Spells.none || spell2.getTier().level > ((ItemWand)stack.func_77973_b()).tier.level || i < cooldowns.length && cooldowns[i] > 0 || MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, spell2, (EntityLivingBase)this.entity, modifiers = EntityAICastSpell.calculateModifiers(stack, (EntityLivingBase)this.entity, spell2)))) continue;
                WandHelper.selectSpell((ItemStack)stack, (int)i);
                int chargeup2 = (int)((float)spell2.getChargeup() * modifiers.get("chargeup"));
                if (!spell2.isContinuous && chargeup2 <= 0) {
                    EntityAICastSpell.cast(stack, spell2, this.entity, EnumHand.MAIN_HAND, 0, attackTarget, modifiers);
                    EntityAICastSpell.setCooldown(stack, spell2, this.entity, modifiers, CQRConfig.wizardry.minCooldown, CQRConfig.wizardry.maxCooldown);
                    break;
                }
                this.startCasting(modifiers);
                break;
            }
        }
        if (this.isCasting() && this.useTick >= (chargeup = (int)((float)(spell = WandHelper.getCurrentSpell((ItemStack)stack)).getChargeup() * this.modifiers.get("chargeup")))) {
            if (!spell.isContinuous) {
                EntityAICastSpell.cast(stack, spell, this.entity, EnumHand.MAIN_HAND, 0, attackTarget, this.modifiers);
                EntityAICastSpell.setCooldown(stack, spell, this.entity, this.modifiers, CQRConfig.wizardry.minCooldown, CQRConfig.wizardry.maxCooldown);
                this.stopCasting();
            } else {
                int castingTick = this.useTick - chargeup;
                if (castingTick == 0) {
                    EntityAICastSpell.cast(stack, spell, this.entity, EnumHand.MAIN_HAND, castingTick, attackTarget, this.modifiers);
                } else if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)this.entity, this.modifiers, castingTick)) || !EntityAICastSpell.cast(stack, spell, this.entity, EnumHand.MAIN_HAND, castingTick, attackTarget, this.modifiers) || castingTick >= CQRConfig.wizardry.continuousDuration - 1) {
                    MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Finish(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)this.entity, this.modifiers, castingTick));
                    spell.finishCasting(this.world, (EntityLivingBase)this.entity, Double.NaN, Double.NaN, Double.NaN, null, castingTick, this.modifiers);
                    this.entity.setContinuousSpell(Spells.none);
                    PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(this.entity.func_145782_y(), -1, EnumHand.MAIN_HAND, Spells.none, new SpellModifiers());
                    WizardryPacketHandler.net.sendToAllTracking((IMessage)msg, (Entity)this.entity);
                    EntityAICastSpell.setCooldown(stack, spell, this.entity, this.modifiers, CQRConfig.wizardry.minCooldown, CQRConfig.wizardry.maxCooldown);
                    this.stopCasting();
                }
            }
        }
        if (this.isCasting()) {
            ++this.useTick;
        }
    }

    private boolean isCasting() {
        return this.useTick >= 0;
    }

    private void startCasting(SpellModifiers modifiers) {
        this.useTick = 0;
        this.modifiers = modifiers;
        this.entity.func_184598_c(EnumHand.MAIN_HAND);
    }

    private void stopCasting() {
        this.useTick = -1;
        this.modifiers = null;
        this.entity.func_184597_cx();
    }

    public static boolean cast(ItemStack stack, Spell spell, AbstractEntityCQR caster, EnumHand hand, int castingTick, EntityLivingBase target, SpellModifiers modifiers) {
        if (!spell.cast(caster.field_70170_p, (EntityLiving)caster, hand, castingTick, target, modifiers)) {
            return false;
        }
        if (castingTick == 0) {
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)caster, modifiers));
            if (spell.isContinuous) {
                caster.setContinuousSpell(spell);
            }
            if (spell.isContinuous || spell.requiresPacket()) {
                PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(caster.func_145782_y(), target.func_145782_y(), hand, spell, modifiers);
                WizardryPacketHandler.net.sendToAllTracking((IMessage)msg, (Entity)caster);
            }
        }
        return true;
    }

    public static void setCooldown(ItemStack stack, Spell spell, AbstractEntityCQR caster, SpellModifiers modifiers, int minCooldown, int maxCooldown) {
        WandHelper.setCurrentCooldown((ItemStack)stack, (int)Math.min((int)((float)spell.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade)), maxCooldown));
        int[] cooldowns = WandHelper.getCooldowns((ItemStack)stack);
        for (int i = 0; i < cooldowns.length; ++i) {
            cooldowns[i] = Math.max(cooldowns[i], minCooldown);
        }
    }

    public static SpellModifiers calculateModifiers(ItemStack stack, EntityLivingBase entity, Spell spell) {
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.range_upgrade);
        if (level > 0) {
            modifiers.set(WizardryItems.range_upgrade, 1.0f + (float)level * Constants.RANGE_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.duration_upgrade)) > 0) {
            modifiers.set(WizardryItems.duration_upgrade, 1.0f + (float)level * Constants.DURATION_INCREASE_PER_LEVEL, false);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.blast_upgrade)) > 0) {
            modifiers.set(WizardryItems.blast_upgrade, 1.0f + (float)level * Constants.BLAST_RADIUS_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.cooldown_upgrade)) > 0) {
            modifiers.set(WizardryItems.cooldown_upgrade, 1.0f - (float)level * Constants.COOLDOWN_REDUCTION_PER_LEVEL, true);
        }
        return modifiers;
    }
}

