/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.inventory;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.trade.Trade;
import team.cqr.cqrepoured.entity.trade.TradeInput;
import team.cqr.cqrepoured.inventory.IInteractable;
import team.cqr.cqrepoured.inventory.InventoryMerchant;
import team.cqr.cqrepoured.inventory.SlotMerchantOutput;
import team.cqr.cqrepoured.util.CraftingHelper;
import team.cqr.cqrepoured.util.GuiHandler;

public class ContainerMerchant
extends Container
implements IInteractable {
    private final AbstractEntityCQR entity;
    private final InventoryMerchant merchantInventory;

    public ContainerMerchant(AbstractEntityCQR entity, EntityPlayer player) {
        this.entity = entity;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 139 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, k, 139 + k * 18, 142));
        }
        this.merchantInventory = new InventoryMerchant(entity, player);
        this.func_75146_a(new Slot((IInventory)this.merchantInventory, 0, 141, 37));
        this.func_75146_a(new Slot((IInventory)this.merchantInventory, 1, 167, 37));
        this.func_75146_a(new Slot((IInventory)this.merchantInventory, 2, 193, 37));
        this.func_75146_a(new Slot((IInventory)this.merchantInventory, 3, 219, 37));
        this.func_75146_a(new SlotMerchantOutput(player, this.merchantInventory, 4, 277, 37));
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.merchantInventory.resetTradeAndSlots();
        super.func_75130_a(inventoryIn);
    }

    public void setCurrentTradeIndex(int index) {
        this.merchantInventory.setCurrentTradeIndex(index);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.entity.field_70128_L) {
            return false;
        }
        return playerIn.func_70068_e((Entity)this.entity) <= 64.0;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return !(slotIn instanceof SlotMerchantOutput);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack oldStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack newStack = slot.func_75211_c();
            oldStack = newStack.func_77946_l();
            if (index == 40) {
                if (!this.func_75135_a(newStack, 0, 36, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(newStack, oldStack);
            } else if (index > 35 ? !this.func_75135_a(newStack, 0, 36, false) : !this.func_75135_a(newStack, 36, 40, false) && (index > 26 ? this.func_75135_a(newStack, 0, 27, false) : this.func_75135_a(newStack, 27, 36, false))) {
                return ItemStack.field_190927_a;
            }
            if (newStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (newStack.func_190916_E() == oldStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, newStack);
        }
        return oldStack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
            for (int i = 0; i < 4; ++i) {
                playerIn.func_71019_a(this.merchantInventory.func_70304_b(i), false);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, this.merchantInventory.func_70304_b(i));
            }
        }
    }

    public void updateInputsForTrade(int tradeIndex) {
        Trade trade = this.entity.getTrades().get(tradeIndex);
        if (trade != null) {
            int i;
            NonNullList<TradeInput> input = trade.getInputItems();
            for (i = 0; i < 4; ++i) {
                ItemStack stack = this.merchantInventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (!this.func_75135_a(stack, 0, 36, true)) {
                    return;
                }
                this.merchantInventory.func_70299_a(i, stack);
            }
            for (i = 0; i < 4 && i < input.size(); ++i) {
                this.fillSlot(i, (TradeInput)input.get(i));
            }
        }
    }

    private void fillSlot(int slotIndex, TradeInput input) {
        if (!input.getStack().func_190926_b()) {
            for (int i = 0; i < 36; ++i) {
                ItemStack stack1 = ((Slot)this.field_75151_b.get(i)).func_75211_c();
                if (stack1.func_190926_b() || !CraftingHelper.areItemStacksEqualIgnoreCount(input.getStack(), stack1, input.ignoreMeta(), input.ignoreNBT())) continue;
                ItemStack stack2 = this.merchantInventory.func_70301_a(slotIndex);
                int j = stack2.func_190926_b() ? 0 : stack2.func_190916_E();
                int k = Math.min(input.getStack().func_77976_d() - j, stack1.func_190916_E());
                ItemStack stack3 = stack1.func_77946_l();
                int l = j + k;
                stack1.func_190918_g(k);
                stack3.func_190920_e(l);
                this.merchantInventory.func_70299_a(slotIndex, stack3);
                if (l >= input.getStack().func_77976_d()) break;
            }
        }
    }

    @Override
    public void onClickButton(EntityPlayer player, int button, ByteBuf extraData) {
        if (button < 10) {
            if (button == 0) {
                player.openGui((Object)CQRMain.INSTANCE, GuiHandler.MERCHANT_EDIT_TRADE_GUI_ID, player.field_70170_p, this.entity.func_145782_y(), this.entity.getTrades().size(), 0);
            }
        } else if (button < 20) {
            int index = extraData.readInt();
            this.setCurrentTradeIndex(index);
            this.updateInputsForTrade(index);
        } else if (button < 30) {
            int index = extraData.readInt();
            int newIndex = index - 1;
            this.entity.getTrades().updateTradeIndex(index, newIndex);
        } else if (button < 40) {
            int index = extraData.readInt();
            int newIndex = index + 1;
            this.entity.getTrades().updateTradeIndex(index, newIndex);
        } else if (button < 50) {
            int index = extraData.readInt();
            this.entity.getTrades().deleteTrade(index);
        } else if (button < 60) {
            int index = extraData.readInt();
            player.openGui((Object)CQRMain.INSTANCE, GuiHandler.MERCHANT_EDIT_TRADE_GUI_ID, player.field_70170_p, this.entity.func_145782_y(), index, 0);
        }
    }

    public void onTradesUpdated() {
        this.merchantInventory.resetTradeAndSlots();
    }

    public AbstractEntityCQR getMerchant() {
        return this.entity;
    }
}

