/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.inventory;

import io.netty.buffer.ByteBuf;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.trade.Trade;
import team.cqr.cqrepoured.entity.trade.TradeInput;
import team.cqr.cqrepoured.entity.trade.TraderOffer;
import team.cqr.cqrepoured.faction.EReputationState;
import team.cqr.cqrepoured.inventory.IInteractable;
import team.cqr.cqrepoured.util.GuiHandler;

public class ContainerMerchantEditTrade
extends Container
implements IInteractable {
    private final AbstractEntityCQR entity;
    private final IInventory tradeInventory;

    public ContainerMerchantEditTrade(AbstractEntityCQR entity, EntityPlayer player, int tradeIndex) {
        this.entity = entity;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 72 + j * 18, 60 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, k, 72 + k * 18, 118));
        }
        this.tradeInventory = new InventoryBasic("", false, 5);
        this.func_75146_a(new Slot(this.tradeInventory, 0, 74, 12));
        this.func_75146_a(new Slot(this.tradeInventory, 1, 100, 12));
        this.func_75146_a(new Slot(this.tradeInventory, 2, 126, 12));
        this.func_75146_a(new Slot(this.tradeInventory, 3, 152, 12));
        this.func_75146_a(new Slot(this.tradeInventory, 4, 210, 12));
        Trade trade = entity.getTrades().get(tradeIndex);
        if (trade != null) {
            NonNullList<TradeInput> tradeInputs = trade.getInputItems();
            for (int i = 0; i < tradeInputs.size() && i < this.tradeInventory.func_70302_i_() - 1; ++i) {
                this.tradeInventory.func_70299_a(i, ((TradeInput)tradeInputs.get(i)).getStack());
            }
            this.tradeInventory.func_70299_a(this.tradeInventory.func_70302_i_() - 1, trade.getOutput());
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (!playerIn.func_184812_l_()) {
            return false;
        }
        if (this.entity.field_70128_L) {
            return false;
        }
        return playerIn.func_70068_e((Entity)this.entity) <= 64.0;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            ItemStack itemstack = itemstack1.func_77946_l();
            if (index > 35 ? this.func_75135_a(itemstack1, 0, 36, false) : this.func_75135_a(itemstack1, 36, this.field_75151_b.size(), false)) {
                return itemstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
    }

    public ItemStack getOutput() {
        return this.tradeInventory.func_70301_a(4);
    }

    public ItemStack[] getInput() {
        ItemStack[] input = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            input[i] = this.tradeInventory.func_70301_a(i);
        }
        return input;
    }

    @Override
    public void onClickButton(EntityPlayer player, int button, ByteBuf extraData) {
        if (button == 0) {
            player.openGui((Object)CQRMain.INSTANCE, GuiHandler.MERCHANT_GUI_ID, player.field_70170_p, this.entity.func_145782_y(), 0, 0);
        } else if (button == 1) {
            int index = extraData.readInt();
            boolean[] ignoreMeta = new boolean[4];
            IntStream.range(0, ignoreMeta.length).forEach(i -> {
                ignoreMeta[i] = extraData.readBoolean();
            });
            boolean[] ignoreNBT = new boolean[4];
            IntStream.range(0, ignoreNBT.length).forEach(i -> {
                ignoreNBT[i] = extraData.readBoolean();
            });
            String reputationName = ByteBufUtils.readUTF8String((ByteBuf)extraData);
            String advancementName = ByteBufUtils.readUTF8String((ByteBuf)extraData);
            boolean stock = extraData.readBoolean();
            int restock = extraData.readInt();
            int inStock = extraData.readInt();
            int maxStock = extraData.readInt();
            TraderOffer trades = this.entity.getTrades();
            int reputation = this.getRequriedReputation(reputationName);
            ResourceLocation advancement = this.getRequiredAdvancement((WorldServer)player.field_70170_p, advancementName);
            ItemStack output = this.getOutput();
            TradeInput[] input = this.getTradeInput(this.getInput(), ignoreMeta, ignoreNBT);
            Trade trade = new Trade(trades, reputation, advancement, stock, restock, inStock, maxStock, output, input);
            this.entity.getTrades().editTrade(index, trade);
            player.openGui((Object)CQRMain.INSTANCE, GuiHandler.MERCHANT_GUI_ID, player.field_70170_p, this.entity.func_145782_y(), 0, 0);
        }
    }

    private TradeInput[] getTradeInput(ItemStack[] stacks, boolean[] ignoreMeta, boolean[] ignoreNBT) {
        TradeInput[] input = new TradeInput[stacks.length];
        for (int i = 0; i < input.length; ++i) {
            input[i] = new TradeInput(stacks[i], i < ignoreMeta.length && ignoreMeta[i], i < ignoreNBT.length && ignoreNBT[i]);
        }
        return input;
    }

    private int getRequriedReputation(String reputation) {
        try {
            EReputationState reputationState = EReputationState.valueOf(reputation.toUpperCase());
            if (reputationState != null) {
                return reputationState.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.MIN_VALUE;
    }

    @Nullable
    private ResourceLocation getRequiredAdvancement(WorldServer world, String advancement) {
        ResourceLocation requiredAdvancement = new ResourceLocation(advancement);
        if (world.func_191952_z().func_192778_a(requiredAdvancement) != null) {
            return requiredAdvancement;
        }
        return null;
    }
}

