/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.world.structure.generation.DungeonDataManager;
import team.cqr.cqrepoured.world.structure.generation.DungeonRegistry;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;

public class ItemDungeonPlacer
extends Item {
    private static final List<ClientDungeon> CLIENT_DUNGEON_LIST = new ArrayList<ClientDungeon>();
    public static final int HIGHEST_ICON_NUMBER = 19;
    private int iconID;

    public ItemDungeonPlacer(int iconID) {
        this.func_77625_d(1);
        this.iconID = iconID;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (ClientDungeon fakeDungeon : CLIENT_DUNGEON_LIST) {
                int iconID = fakeDungeon.getIconID() <= 19 ? fakeDungeon.getIconID() : 0;
                if (iconID != this.iconID) continue;
                ItemStack stack = new ItemStack((Item)this);
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("dungeonName", fakeDungeon.getDungeonName());
                compound.func_74768_a("iconID", iconID);
                NBTTagList dependencies = new NBTTagList();
                for (String dependency : fakeDungeon.getDependencies()) {
                    dependencies.func_74742_a((NBTBase)new NBTTagString(dependency));
                }
                compound.func_74782_a("dependencies", (NBTBase)dependencies);
                stack.func_77982_d(compound);
                items.add((Object)stack);
            }
        }
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.HEAD;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("dependencies")) {
            tooltip.add("Mod Dependencies: ");
            for (NBTBase nbtTag : stack.func_77978_p().func_150295_c("dependencies", 8)) {
                String dependency = nbtTag.toString().replace("\"", "");
                if (Loader.isModLoaded((String)dependency)) {
                    tooltip.add(TextFormatting.GRAY + "- " + TextFormatting.DARK_GREEN + dependency);
                    continue;
                }
                tooltip.add(TextFormatting.GRAY + "- " + TextFormatting.RED + dependency);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            return "Dungeon Placer - " + compound.func_74779_i("dungeonName");
        }
        return "Dungeon Placer";
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack;
        if (!worldIn.field_72995_K && (stack = playerIn.func_184586_b(handIn)).func_77942_o()) {
            Vec3d look;
            Vec3d vec;
            RayTraceResult result;
            String dungeonName = stack.func_77978_p().func_74779_i("dungeonName");
            DungeonBase dungeon = DungeonRegistry.getInstance().getDungeon(dungeonName);
            if (dungeon != null && (result = worldIn.func_72933_a(vec = playerIn.func_174824_e(1.0f), vec.func_178787_e((look = playerIn.func_70040_Z()).func_186678_a(256.0)))) != null) {
                BlockPos pos = result.func_178782_a().func_177972_a(result.field_178784_b);
                dungeon.generateWithOffsets(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), new Random(), DungeonDataManager.DungeonSpawnType.DUNGEON_PLACER_ITEM);
                playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), 30);
                if (!playerIn.func_184812_l_() && !playerIn.func_175149_v()) {
                    stack.func_190918_g(1);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public static void updateClientDungeonList(List<ClientDungeon> list) {
        CLIENT_DUNGEON_LIST.clear();
        CLIENT_DUNGEON_LIST.addAll(list);
    }

    public static class ClientDungeon {
        private String dungeonName;
        private int iconID;
        private String[] dependencies;

        public ClientDungeon(String dungeonName, int iconID, String[] dependencies) {
            this.dungeonName = dungeonName;
            this.iconID = iconID;
            this.dependencies = dependencies;
        }

        public String getDungeonName() {
            return this.dungeonName;
        }

        public int getIconID() {
            return this.iconID;
        }

        public String[] getDependencies() {
            return this.dependencies;
        }
    }
}

