/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import team.cqr.cqrepoured.item.ItemLore;

public abstract class ItemMagazineBased
extends ItemLore {
    public static final String CONSTANT_AMMO_NBT_KEY = "cqr_magazine_item_ammo";
    protected final Predicate<ItemStack> predicateAmmo;

    public ItemMagazineBased(Predicate<ItemStack> fuelPredicate) {
        this.predicateAmmo = fuelPredicate;
        this.func_77625_d(1);
    }

    public abstract int getMaxAmmo();

    protected abstract int getMaxProcessedItemsPerReloadCycle();

    protected abstract int getAmmoForSingleAmmoItem(ItemStack var1);

    public boolean isRepairable() {
        return false;
    }

    public boolean hasMagazineTag(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(CONSTANT_AMMO_NBT_KEY, 3);
    }

    public void removeAmmoFromItem(ItemStack stack, int amount) {
        this.setAmmo(stack, this.getAmmoInItem(stack) - amount);
    }

    public int getAmmoInItem(ItemStack stack) {
        if (this.hasMagazineTag(stack)) {
            return stack.func_77978_p().func_74762_e(CONSTANT_AMMO_NBT_KEY);
        }
        return 0;
    }

    public void addAmmoToItem(ItemStack stack, int amount) {
        this.setAmmo(stack, amount + this.getAmmoInItem(stack));
    }

    public void setAmmo(ItemStack stack, int amount) {
        int n = amount = amount < 0 ? 0 : amount;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(CONSTANT_AMMO_NBT_KEY, amount);
    }

    public float getAmmoInItemInPercent(ItemStack stack) {
        return (float)this.getAmmoInItem(stack) / (float)this.getMaxAmmo();
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getAmmoInItemInPercent(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(this.getAmmoInItemInPercent(stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public List<ItemStack> getAmmoItemsInInventory(InventoryPlayer playerInventory) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
            ItemStack stack = playerInventory.func_70301_a(i);
            if (!this.isValidAmmo(stack)) continue;
            result.add(stack);
        }
        return result;
    }

    public ItemStack func_190903_i() {
        ItemStack def = super.func_190903_i();
        if (!def.func_77942_o()) {
            def.func_77982_d(new NBTTagCompound());
        }
        this.setAmmo(def, this.getMaxAmmo());
        return def;
    }

    protected void reloadFromInventory(InventoryPlayer playerInventory, ItemStack stack, boolean removeItems) {
        this.reloadFromAmmoItems(playerInventory, this.getAmmoItemsInInventory(playerInventory), stack, removeItems);
    }

    protected void reloadFromAmmoItems(InventoryPlayer playerInventory, List<ItemStack> fuelItems, ItemStack stack, boolean removeItems) {
        if (fuelItems.isEmpty()) {
            return;
        }
        int freeFuel = this.getMaxAmmo() - this.getAmmoInItem(stack);
        int refueled = 0;
        int processedItems = 0;
        for (int itemIndx = 0; itemIndx < fuelItems.size(); ++itemIndx) {
            ItemStack fuel = fuelItems.get(itemIndx);
            int stackSize = fuel.func_190916_E();
            for (int i = 0; i < stackSize; ++i) {
                int fc = this.getAmmoForSingleAmmoItem(fuel);
                if (fc > freeFuel) continue;
                freeFuel -= fc;
                refueled += fc;
                if (removeItems) {
                    fuel.func_190918_g(1);
                }
                if (++processedItems >= this.getMaxProcessedItemsPerReloadCycle()) break;
            }
            if (fuel.func_190926_b() && removeItems) {
                playerInventory.func_184437_d(fuel);
            }
            if (processedItems >= this.getMaxProcessedItemsPerReloadCycle()) break;
        }
        this.addAmmoToItem(stack, refueled);
    }

    public boolean isValidAmmo(ItemStack item) {
        return this.predicateAmmo.test(item);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return this.getAmmoInItem(newStack) > 0;
    }
}

