/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item.gun;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.projectiles.ProjectileBubble;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.item.IRangedWeapon;
import team.cqr.cqrepoured.item.ItemLore;

public class ItemBubblePistol
extends ItemLore
implements IRangedWeapon {
    private final Random rng = new Random();

    public ItemBubblePistol() {
        this.func_77656_e(this.getMaxUses());
        this.func_77625_d(1);
    }

    public int getMaxUses() {
        return 200;
    }

    public double getInaccurary() {
        return 0.5;
    }

    public int func_77626_a(ItemStack stack) {
        return 10;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_184811_cZ().func_185145_a((Item)this, this.getCooldown());
        }
        stack.func_77972_a(1, entityLiving);
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        stack.func_77972_a(1, entityLiving);
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_184811_cZ().func_185145_a((Item)this, this.getCooldown());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_184587_cr() && ((EntityLivingBase)entityIn).func_184607_cu() == stack) {
            this.shootBubbles((EntityLivingBase)entityIn);
        }
    }

    private void shootBubbles(EntityLivingBase entity) {
        double x = -Math.sin(Math.toRadians(entity.field_70177_z));
        double z = Math.cos(Math.toRadians(entity.field_70177_z));
        double y = -Math.sin(Math.toRadians(entity.field_70125_A));
        this.shootBubbles(new Vec3d(x, y, z), entity);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    private void shootBubbles(Vec3d velocity, EntityLivingBase shooter) {
        Vec3d v = new Vec3d(-this.getInaccurary() + velocity.field_72450_a + 2.0 * this.getInaccurary() * this.rng.nextDouble(), -this.getInaccurary() + velocity.field_72448_b + 2.0 * this.getInaccurary() * this.rng.nextDouble(), -this.getInaccurary() + velocity.field_72449_c + 2.0 * this.getInaccurary() * this.rng.nextDouble());
        v = v.func_72432_b();
        v = v.func_186678_a(1.4);
        shooter.func_184185_a(CQRSounds.BUBBLE_BUBBLE, 1.0f, 0.75f + 0.5f * shooter.func_70681_au().nextFloat());
        ProjectileBubble bubble = new ProjectileBubble(shooter.field_70170_p, shooter);
        bubble.field_70159_w = v.field_72450_a;
        bubble.field_70181_x = v.field_72448_b;
        bubble.field_70179_y = v.field_72449_c;
        bubble.field_70133_I = true;
        shooter.field_70170_p.func_72838_d((Entity)bubble);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public void shoot(World world, EntityLivingBase shooter, Entity target, EnumHand hand) {
        this.shootBubbles(shooter);
    }

    @Override
    public SoundEvent getShootSound() {
        return SoundEvents.field_187612_G;
    }

    @Override
    public double getRange() {
        return 32.0;
    }

    @Override
    public int getCooldown() {
        return 80;
    }

    @Override
    public int getChargeTicks() {
        return 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

