/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.mixin;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.world.structure.generation.generation.PortalGenerationHandler;
import team.cqr.cqrepoured.world.structure.generation.generation.SpawnpointGenerationHandler;

@Mixin(value={WorldServer.class})
public abstract class WorldServerMixin
implements SpawnpointGenerationHandler,
PortalGenerationHandler {
    @Unique
    private final Set<ChunkPos> delayedChunks = new HashSet<ChunkPos>();
    @Unique
    private boolean isGeneratingDelayedChunks;
    @Unique
    private boolean isGeneratingDestinationChunks;

    @Inject(method={"createSpawnPosition"}, at={@At(value="FIELD", target="Lnet/minecraft/world/WorldServer;findingSpawnPoint:Z", ordinal=1, shift=At.Shift.AFTER)})
    private void createSpawnPosition(WorldSettings settings, CallbackInfo info) {
        long worldSeed = ((WorldServer)this).func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        this.isGeneratingDelayedChunks = true;
        for (ChunkPos chunkPos : this.delayedChunks) {
            long chunkSeed = xSeed * (long)chunkPos.field_77276_a + zSeed * (long)chunkPos.field_77275_b ^ worldSeed;
            fmlRandom.setSeed(chunkSeed);
            CQRMain.DUNGEON_GENERATOR.generate(fmlRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, (World)((WorldServer)this), this.func_72863_F().field_186029_c, (IChunkProvider)this.func_72863_F());
            CQRMain.WALL_GENERATOR.generate(fmlRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, (World)((WorldServer)this), this.func_72863_F().field_186029_c, (IChunkProvider)this.func_72863_F());
        }
        this.isGeneratingDelayedChunks = false;
        this.delayedChunks.clear();
    }

    @Shadow
    public abstract ChunkProviderServer func_72863_F();

    @Override
    public boolean isDungeonGenerationDelayed(int chunkX, int chunkZ) {
        boolean delayed = ((WorldServer)this).field_72987_B;
        if (delayed) {
            this.delayedChunks.add(new ChunkPos(chunkX, chunkZ));
        }
        return delayed;
    }

    @Override
    public boolean isGeneratingDelayedChunks() {
        return this.isGeneratingDelayedChunks;
    }

    @Override
    public void isGeneratingDestinationChunks(boolean value) {
        this.isGeneratingDestinationChunks = value;
    }

    @Override
    public boolean isGeneratingDestinationChunks() {
        return this.isGeneratingDestinationChunks;
    }
}

