/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import team.cqr.cqrepoured.network.datasync.DataEntry;

public class DataEntryBoolean
extends DataEntry<Boolean> {
    private boolean value;

    public DataEntryBoolean(String name, boolean defaultValue, boolean isClientModificationAllowed) {
        super(name, isClientModificationAllowed);
        this.value = defaultValue;
    }

    @Override
    public NBTBase write() {
        return new NBTTagByte((byte)(this.value ? 1 : 0));
    }

    @Override
    protected void readInternal(NBTBase nbt) {
        if (nbt instanceof NBTTagByte) {
            this.value = ((NBTTagByte)nbt).func_150290_f() != 0;
        }
    }

    @Override
    public void writeChanges(ByteBuf buf) {
        buf.writeBoolean(this.value);
    }

    @Override
    protected void readChangesInternal(ByteBuf buf) {
        this.value = buf.readBoolean();
    }

    @Override
    @Deprecated
    public void set(@Nonnull Boolean value) {
        if (value == null) {
            return;
        }
        this.set(value);
    }

    @Override
    @Deprecated
    protected void setInternal(@Nonnull Boolean value) {
        if (value == null) {
            return;
        }
        this.setInternal(value);
    }

    @Override
    @Deprecated
    public boolean isSavedValueEqualTo(Boolean value) {
        return this.isSavedValueEqualTo(value);
    }

    @Override
    @Deprecated
    public Boolean get() {
        return this.getBoolean();
    }

    @Override
    public void set(boolean value) {
        if (!this.isSavedValueEqualTo(value)) {
            this.setInternal(value);
            this.onValueChanged();
            this.markDirty();
        }
    }

    @Override
    protected void setInternal(boolean value) {
        this.value = value;
    }

    @Override
    public boolean isSavedValueEqualTo(boolean value) {
        return this.value == value;
    }

    public boolean getBoolean() {
        return this.value;
    }
}

