/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.server.handler;

import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.network.client.packet.CPacketCloseMapPlaceholderGuiSimple;
import team.cqr.cqrepoured.tileentity.TileEntityMap;

public class SPacketHandlerCloseMapPlaceholderGuiSimple
implements IMessageHandler<CPacketCloseMapPlaceholderGuiSimple, IMessage> {
    public IMessage onMessage(CPacketCloseMapPlaceholderGuiSimple message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                EntityPlayer player = CQRMain.proxy.getPlayer(ctx);
                World world = CQRMain.proxy.getWorld(ctx);
                EnumFacing facing = message.getFacing();
                BlockPos pos = message.getPos().func_177972_a(facing);
                if (player.func_174831_c(pos) > 256.0) {
                    return;
                }
                int scale = message.getScale();
                EnumFacing orientation = message.getOrientation();
                boolean lockOrientation = message.isLockOrientation();
                boolean fillMap = message.isFillMap();
                int fillRadius = message.getFillRadius();
                EnumFacing facingOpposite = facing.func_176734_d();
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int leftRight = -message.getSizeLeft(); leftRight <= message.getSizeRight(); ++leftRight) {
                    for (int downUp = -message.getSizeDown(); downUp <= message.getSizeUp(); ++downUp) {
                        TileEntity tileEntity;
                        int x = 0;
                        int z = 0;
                        switch (facingOpposite) {
                            case NORTH: {
                                x = leftRight;
                                break;
                            }
                            case SOUTH: {
                                x = -leftRight;
                                break;
                            }
                            case WEST: {
                                z = -leftRight;
                                break;
                            }
                            case EAST: {
                                z = leftRight;
                                break;
                            }
                        }
                        mutablePos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + downUp, pos.func_177952_p() + z);
                        if (world.func_175623_d((BlockPos)mutablePos)) {
                            if (!CQRBlocks.MAP_PLACEHOLDER.canAttachTo(world, mutablePos.func_177972_a(facingOpposite), facing)) continue;
                            world.func_175656_a((BlockPos)mutablePos, CQRBlocks.MAP_PLACEHOLDER.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing));
                        }
                        if (!((tileEntity = world.func_175625_s((BlockPos)mutablePos)) instanceof TileEntityMap)) continue;
                        int originX = 0;
                        int originZ = 0;
                        int offsetX = 0;
                        int offsetZ = 0;
                        switch (orientation) {
                            case NORTH: {
                                originX = -leftRight;
                                originZ = 0;
                                offsetX = leftRight;
                                offsetZ = -downUp;
                                break;
                            }
                            case SOUTH: {
                                originX = leftRight;
                                originZ = 0;
                                offsetX = -leftRight;
                                offsetZ = downUp;
                                break;
                            }
                            case WEST: {
                                originX = 0;
                                originZ = leftRight;
                                offsetX = -downUp;
                                offsetZ = -leftRight;
                                break;
                            }
                            case EAST: {
                                originX = 0;
                                originZ = -leftRight;
                                offsetX = downUp;
                                offsetZ = leftRight;
                                break;
                            }
                        }
                        ((TileEntityMap)tileEntity).set(scale, orientation, lockOrientation, originX, originZ, offsetX, offsetZ, fillMap, fillRadius);
                    }
                }
            });
        }
        return null;
    }
}

