/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.server.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.item.ItemDungeonPlacer;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;

public class SPacketDungeonSync
implements IMessage {
    private Collection<DungeonBase> dungeons;
    private List<ItemDungeonPlacer.ClientDungeon> fakeDungeonSet;

    public SPacketDungeonSync() {
    }

    public SPacketDungeonSync(Collection<DungeonBase> dungeons) {
        this.dungeons = dungeons;
    }

    public void fromBytes(ByteBuf buf) {
        int dungeonCount = buf.readShort();
        this.fakeDungeonSet = new ArrayList<ItemDungeonPlacer.ClientDungeon>(dungeonCount);
        for (int i = 0; i < dungeonCount; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            byte iconID = buf.readByte();
            int dependencyCount = buf.readByte();
            String[] dependencies = new String[dependencyCount];
            for (int j = 0; j < dependencyCount; ++j) {
                dependencies[j] = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
            this.fakeDungeonSet.add(new ItemDungeonPlacer.ClientDungeon(name, iconID, dependencies));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.dungeons.size());
        for (DungeonBase dungeon : this.dungeons) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)dungeon.getDungeonName());
            buf.writeByte(dungeon.getIconID());
            buf.writeByte(dungeon.getModDependencies().length);
            for (String dependency : dungeon.getModDependencies()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)dependency);
            }
        }
    }

    public List<ItemDungeonPlacer.ClientDungeon> getFakeDungeonList() {
        return this.fakeDungeonSet;
    }
}

